/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.services.resources.admin;

import java.net.URI;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.NotFoundException;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriInfo;
import org.jboss.resteasy.annotations.cache.NoCache;
import org.keycloak.models.RealmModel;
import org.keycloak.models.RoleContainerModel;
import org.keycloak.models.RoleModel;
import org.keycloak.representations.idm.RoleRepresentation;
import org.keycloak.services.managers.ModelToRepresentation;
import org.keycloak.services.resources.admin.RealmAuth;
import org.keycloak.services.resources.admin.RoleResource;
import org.keycloak.services.resources.flows.Flows;

public class RoleContainerResource
extends RoleResource {
    private final RealmModel realm;
    private final RealmAuth auth;
    protected RoleContainerModel roleContainer;

    public RoleContainerResource(RealmModel realm, RealmAuth auth, RoleContainerModel roleContainer) {
        super(realm);
        this.realm = realm;
        this.auth = auth;
        this.roleContainer = roleContainer;
    }

    @Path(value="")
    @GET
    @NoCache
    @Produces(value={"application/json"})
    public List<RoleRepresentation> getRoles() {
        this.auth.requireAny();
        Set roleModels = this.roleContainer.getRoles();
        ArrayList<RoleRepresentation> roles = new ArrayList<RoleRepresentation>();
        for (RoleModel roleModel : roleModels) {
            if (roleModel.getName().startsWith("KEYCLOAK_")) continue;
            roles.add(ModelToRepresentation.toRepresentation(roleModel));
        }
        return roles;
    }

    @Path(value="")
    @POST
    @Consumes(value={"application/json"})
    public Response createRole(@Context UriInfo uriInfo, RoleRepresentation rep) {
        this.auth.requireManage();
        if (this.roleContainer.getRole(rep.getName()) != null || rep.getName().startsWith("KEYCLOAK_")) {
            return Flows.errors().exists("Role with name " + rep.getName() + " already exists");
        }
        RoleModel role = this.roleContainer.addRole(rep.getName());
        if (role == null) {
            throw new NotFoundException();
        }
        role.setDescription(rep.getDescription());
        return Response.created((URI)uriInfo.getAbsolutePathBuilder().path(role.getName()).build(new Object[0])).build();
    }

    @Path(value="{role-name}")
    @GET
    @NoCache
    @Produces(value={"application/json"})
    public RoleRepresentation getRole(@PathParam(value="role-name") String roleName) {
        this.auth.requireView();
        RoleModel roleModel = this.roleContainer.getRole(roleName);
        if (roleModel == null || roleModel.getName().startsWith("KEYCLOAK_")) {
            throw new NotFoundException("Could not find role: " + roleName);
        }
        return this.getRole(roleModel);
    }

    @Path(value="{role-name}")
    @DELETE
    @NoCache
    public void deleteRole(@PathParam(value="role-name") String roleName) {
        this.auth.requireManage();
        RoleModel role = this.roleContainer.getRole(roleName);
        if (role == null) {
            throw new NotFoundException("Could not find role: " + roleName);
        }
        this.deleteRole(role);
    }

    @Path(value="{role-name}")
    @PUT
    @Consumes(value={"application/json"})
    public void updateRole(@PathParam(value="role-name") String roleName, RoleRepresentation rep) {
        this.auth.requireManage();
        RoleModel role = this.roleContainer.getRole(roleName);
        if (role == null || role.getName().startsWith("KEYCLOAK_")) {
            throw new NotFoundException("Could not find role: " + roleName);
        }
        this.updateRole(rep, role);
    }

    @Path(value="{role-name}/composites")
    @POST
    @Consumes(value={"application/json"})
    public void addComposites(@PathParam(value="role-name") String roleName, List<RoleRepresentation> roles) {
        this.auth.requireManage();
        RoleModel role = this.roleContainer.getRole(roleName);
        if (role == null || role.getName().startsWith("KEYCLOAK_")) {
            throw new NotFoundException("Could not find role: " + roleName);
        }
        this.addComposites(roles, role);
    }

    @Path(value="{role-name}/composites")
    @GET
    @NoCache
    @Produces(value={"application/json"})
    public Set<RoleRepresentation> getRoleComposites(@PathParam(value="role-name") String roleName) {
        this.auth.requireManage();
        RoleModel role = this.roleContainer.getRole(roleName);
        if (role == null || role.getName().startsWith("KEYCLOAK_")) {
            throw new NotFoundException("Could not find role: " + roleName);
        }
        return this.getRoleComposites(role);
    }

    @Path(value="{role-name}/composites/realm")
    @GET
    @NoCache
    @Produces(value={"application/json"})
    public Set<RoleRepresentation> getRealmRoleComposites(@PathParam(value="role-name") String roleName) {
        this.auth.requireManage();
        RoleModel role = this.roleContainer.getRole(roleName);
        if (role == null || role.getName().startsWith("KEYCLOAK_")) {
            throw new NotFoundException("Could not find role: " + roleName);
        }
        return this.getRealmRoleComposites(role);
    }

    @Path(value="{role-name}/composites/application/{app}")
    @GET
    @NoCache
    @Produces(value={"application/json"})
    public Set<RoleRepresentation> getApplicationRoleComposites(@PathParam(value="role-name") String roleName, @PathParam(value="app") String appName) {
        this.auth.requireManage();
        RoleModel role = this.roleContainer.getRole(roleName);
        if (role == null || role.getName().startsWith("KEYCLOAK_")) {
            throw new NotFoundException("Could not find role: " + roleName);
        }
        return this.getApplicationRoleComposites(appName, role);
    }

    @Path(value="{role-name}/composites")
    @DELETE
    @Consumes(value={"application/json"})
    public void deleteComposites(@PathParam(value="role-name") String roleName, List<RoleRepresentation> roles) {
        this.auth.requireManage();
        RoleModel role = this.roleContainer.getRole(roleName);
        if (role == null || role.getName().startsWith("KEYCLOAK_")) {
            throw new NotFoundException("Could not find role: " + roleName);
        }
        this.deleteComposites(roles, role);
    }
}

