/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.services.managers;

import java.util.Arrays;
import java.util.Collections;
import org.jboss.logging.Logger;
import org.keycloak.Config;
import org.keycloak.models.AdminRoles;
import org.keycloak.models.ApplicationModel;
import org.keycloak.models.AuthenticationProviderModel;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.RealmModel;
import org.keycloak.models.RoleModel;
import org.keycloak.models.UserCredentialModel;
import org.keycloak.models.UserModel;
import org.keycloak.provider.ProviderSession;
import org.keycloak.provider.ProviderSessionFactory;
import org.keycloak.services.managers.RealmManager;

public class ApplianceBootstrap {
    private static final Logger logger = Logger.getLogger(ApplianceBootstrap.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void bootstrap(ProviderSessionFactory factory, String contextPath) {
        ProviderSession providerSession = factory.createSession();
        KeycloakSession session = (KeycloakSession)providerSession.getProvider(KeycloakSession.class);
        session.getTransaction().begin();
        try {
            this.bootstrap(session, contextPath);
            session.getTransaction().commit();
        }
        finally {
            providerSession.close();
        }
    }

    public void bootstrap(KeycloakSession session, String contextPath) {
        String adminRealmName = Config.getAdminRealm();
        if (session.getRealm(adminRealmName) != null) {
            return;
        }
        logger.info((Object)("Initializing " + adminRealmName + " realm"));
        RealmManager manager = new RealmManager(session);
        manager.setContextPath(contextPath);
        RealmModel realm = manager.createRealm(adminRealmName, adminRealmName);
        realm.setName(adminRealmName);
        realm.setEnabled(true);
        realm.addRequiredCredential("password");
        realm.setSsoSessionIdleTimeout(300);
        realm.setAccessTokenLifespan(60);
        realm.setSsoSessionMaxLifespan(36000);
        realm.setAccessCodeLifespan(60);
        realm.setAccessCodeLifespanUserAction(300);
        realm.setSslNotRequired(true);
        realm.setRegistrationAllowed(false);
        manager.generateRealmKeys(realm);
        realm.setAuthenticationProviders(Arrays.asList(AuthenticationProviderModel.DEFAULT_PROVIDER));
        realm.setAuditListeners(Collections.singleton("jboss-logging"));
        UserModel adminUser = realm.addUser("admin");
        adminUser.setEnabled(true);
        UserCredentialModel password = new UserCredentialModel();
        password.setType("password");
        password.setValue("admin");
        realm.updateCredential(adminUser, password);
        adminUser.addRequiredAction(UserModel.RequiredAction.UPDATE_PASSWORD);
        RoleModel adminRole = realm.getRole(AdminRoles.ADMIN);
        realm.grantRole(adminUser, adminRole);
        ApplicationModel accountApp = (ApplicationModel)realm.getApplicationNameMap().get("account");
        for (String r : accountApp.getDefaultRoles()) {
            realm.grantRole(adminUser, accountApp.getRole(r));
        }
    }
}

