/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.services.resources;

import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import javax.ws.rs.core.Response;
import org.jboss.resteasy.spi.HttpRequest;
import org.keycloak.models.ClientModel;
import org.keycloak.util.CollectionUtil;

public class Cors {
    public static final long DEFAULT_MAX_AGE = TimeUnit.HOURS.toSeconds(1L);
    public static final String DEFAULT_ALLOW_METHODS = "GET, HEAD, OPTIONS";
    public static final String DEFAULT_ALLOW_HEADERS = "Origin, Accept, X-Requested-With, Content-Type, Access-Control-Request-Method, Access-Control-Request-Headers";
    public static final String ORIGIN_HEADER = "Origin";
    public static final String AUTHORIZATION_HEADER = "Authorization";
    public static final String ACCESS_CONTROL_ALLOW_ORIGIN = "Access-Control-Allow-Origin";
    public static final String ACCESS_CONTROL_ALLOW_METHODS = "Access-Control-Allow-Methods";
    public static final String ACCESS_CONTROL_ALLOW_HEADERS = "Access-Control-Allow-Headers";
    public static final String ACCESS_CONTROL_EXPOSE_HEADERS = "Access-Control-Expose-Headers";
    public static final String ACCESS_CONTROL_ALLOW_CREDENTIALS = "Access-Control-Allow-Credentials";
    public static final String ACCESS_CONTROL_MAX_AGE = "Access-Control-Max-Age";
    private HttpRequest request;
    private Response.ResponseBuilder response;
    private Set<String> allowedOrigins;
    private Set<String> allowedMethods;
    private Set<String> exposedHeaders;
    private boolean preflight;
    private boolean auth;

    public Cors(HttpRequest request, Response.ResponseBuilder response) {
        this.request = request;
        this.response = response;
    }

    public static Cors add(HttpRequest request, Response.ResponseBuilder response) {
        return new Cors(request, response);
    }

    public Cors preflight() {
        this.preflight = true;
        return this;
    }

    public Cors auth() {
        this.auth = true;
        return this;
    }

    public Cors allowedOrigins(ClientModel client) {
        if (client != null) {
            this.allowedOrigins = client.getWebOrigins();
        }
        return this;
    }

    public Cors allowedMethods(String ... allowedMethods) {
        this.allowedMethods = new HashSet<String>(Arrays.asList(allowedMethods));
        return this;
    }

    public Cors exposedHeaders(String ... exposedHeaders) {
        this.exposedHeaders = new HashSet<String>(Arrays.asList(exposedHeaders));
        return this;
    }

    public Response build() {
        String origin = (String)this.request.getHttpHeaders().getRequestHeaders().getFirst((Object)ORIGIN_HEADER);
        if (origin == null) {
            return this.response.build();
        }
        if (!(this.preflight || this.allowedOrigins != null && this.allowedOrigins.contains(origin))) {
            return this.response.build();
        }
        this.response.header(ACCESS_CONTROL_ALLOW_ORIGIN, (Object)origin);
        if (this.allowedMethods != null) {
            this.response.header(ACCESS_CONTROL_ALLOW_METHODS, (Object)CollectionUtil.join(this.allowedMethods));
        } else {
            this.response.header(ACCESS_CONTROL_ALLOW_METHODS, (Object)DEFAULT_ALLOW_METHODS);
        }
        if (this.exposedHeaders != null) {
            this.response.header(ACCESS_CONTROL_EXPOSE_HEADERS, (Object)CollectionUtil.join(this.exposedHeaders));
        }
        this.response.header(ACCESS_CONTROL_ALLOW_CREDENTIALS, (Object)Boolean.toString(this.auth));
        if (this.auth) {
            this.response.header(ACCESS_CONTROL_ALLOW_HEADERS, (Object)String.format("%s, %s", DEFAULT_ALLOW_HEADERS, AUTHORIZATION_HEADER));
        } else {
            this.response.header(ACCESS_CONTROL_ALLOW_HEADERS, (Object)DEFAULT_ALLOW_HEADERS);
        }
        this.response.header(ACCESS_CONTROL_MAX_AGE, (Object)DEFAULT_MAX_AGE);
        return this.response.build();
    }
}

