/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.services.resources;

import javax.ws.rs.GET;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.UriInfo;
import org.jboss.logging.Logger;
import org.jboss.resteasy.annotations.cache.NoCache;
import org.keycloak.models.RealmModel;
import org.keycloak.representations.idm.PublishedRealmRepresentation;
import org.keycloak.services.resources.AccountService;
import org.keycloak.services.resources.TokenService;
import org.keycloak.services.resources.admin.AdminRoot;

public class PublicRealmResource {
    protected static final Logger logger = Logger.getLogger(PublicRealmResource.class);
    @Context
    protected UriInfo uriInfo;
    protected RealmModel realm;

    public PublicRealmResource(RealmModel realm) {
        this.realm = realm;
    }

    @GET
    @NoCache
    @Produces(value={"application/json"})
    public PublishedRealmRepresentation getRealm(@PathParam(value="realm") String id) {
        return PublicRealmResource.realmRep(this.realm, this.uriInfo);
    }

    public static PublishedRealmRepresentation realmRep(RealmModel realm, UriInfo uriInfo) {
        PublishedRealmRepresentation rep = new PublishedRealmRepresentation();
        rep.setRealm(realm.getName());
        rep.setTokenServiceUrl(TokenService.tokenServiceBaseUrl(uriInfo).build(new Object[]{realm.getName()}).toString());
        rep.setAccountServiceUrl(AccountService.accountServiceBaseUrl(uriInfo).build(new Object[]{realm.getName()}).toString());
        rep.setAdminApiUrl(uriInfo.getBaseUriBuilder().path(AdminRoot.class).build(new Object[0]).toString());
        rep.setPublicKeyPem(realm.getPublicKeyPem());
        rep.setNotBefore(realm.getNotBefore());
        return rep;
    }
}

