/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.services.resources.admin;

import org.keycloak.models.AdminRoles;
import org.keycloak.models.ApplicationModel;
import org.keycloak.services.ForbiddenException;
import org.keycloak.services.managers.Auth;

public class RealmAuth {
    private Resource resource;
    private Auth auth;
    private ApplicationModel realmAdminApp;

    public RealmAuth(Auth auth, ApplicationModel realmAdminApp) {
        this.auth = auth;
        this.realmAdminApp = realmAdminApp;
    }

    public RealmAuth init(Resource resource) {
        this.resource = resource;
        return this;
    }

    public void requireAny() {
        if (!this.auth.hasOneOfAppRole(this.realmAdminApp, AdminRoles.ALL_REALM_ROLES)) {
            throw new ForbiddenException();
        }
    }

    public boolean hasView() {
        return this.auth.hasOneOfAppRole(this.realmAdminApp, this.getViewRole(this.resource), this.getManageRole(this.resource));
    }

    public boolean hasManage() {
        return this.auth.hasOneOfAppRole(this.realmAdminApp, this.getManageRole(this.resource));
    }

    public void requireView() {
        if (!this.hasView()) {
            throw new ForbiddenException();
        }
    }

    public void requireManage() {
        if (!this.hasManage()) {
            throw new ForbiddenException();
        }
    }

    private String getViewRole(Resource resource) {
        switch (resource) {
            case APPLICATION: {
                return AdminRoles.VIEW_APPLICATIONS;
            }
            case CLIENT: {
                return AdminRoles.VIEW_CLIENTS;
            }
            case USER: {
                return AdminRoles.VIEW_USERS;
            }
            case REALM: {
                return AdminRoles.VIEW_REALM;
            }
            case AUDIT: {
                return AdminRoles.VIEW_AUDIT;
            }
        }
        throw new IllegalStateException();
    }

    private String getManageRole(Resource resource) {
        switch (resource) {
            case APPLICATION: {
                return AdminRoles.MANAGE_APPLICATIONS;
            }
            case CLIENT: {
                return AdminRoles.MANAGE_CLIENTS;
            }
            case USER: {
                return AdminRoles.MANAGE_USERS;
            }
            case REALM: {
                return AdminRoles.MANAGE_REALM;
            }
            case AUDIT: {
                return AdminRoles.MANAGE_AUDIT;
            }
        }
        throw new IllegalStateException();
    }

    public static enum Resource {
        APPLICATION,
        CLIENT,
        USER,
        REALM,
        AUDIT;

    }
}

