/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.services.resources.admin;

import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.ws.rs.GET;
import javax.ws.rs.core.Context;
import org.keycloak.audit.AuditListener;
import org.keycloak.authentication.AuthenticationProvider;
import org.keycloak.freemarker.Theme;
import org.keycloak.freemarker.ThemeProvider;
import org.keycloak.provider.ProviderSession;
import org.keycloak.social.SocialProvider;
import org.keycloak.util.ProviderLoader;

public class ServerInfoAdminResource {
    @Context
    private ProviderSession providers;

    @GET
    public ServerInfoRepresentation getInfo() {
        ServerInfoRepresentation info = new ServerInfoRepresentation();
        this.setSocialProviders(info);
        this.setThemes(info);
        this.setAuthProviders(info);
        this.setAuditListeners(info);
        return info;
    }

    private void setThemes(ServerInfoRepresentation info) {
        Set themeProviders = this.providers.getAllProviders(ThemeProvider.class);
        info.themes = new HashMap();
        for (Theme.Type type : Theme.Type.values()) {
            LinkedList themes = new LinkedList();
            for (ThemeProvider p : themeProviders) {
                themes.addAll(p.nameSet(type));
            }
            Collections.sort(themes);
            info.themes.put(type.toString().toLowerCase(), themes);
        }
    }

    private void setSocialProviders(ServerInfoRepresentation info) {
        info.socialProviders = new LinkedList();
        for (SocialProvider p : ProviderLoader.load(SocialProvider.class)) {
            info.socialProviders.add(p.getId());
        }
        Collections.sort(info.socialProviders);
    }

    private void setAuthProviders(ServerInfoRepresentation info) {
        info.authProviders = new HashMap();
        Set authProviders = this.providers.getAllProviders(AuthenticationProvider.class);
        for (AuthenticationProvider authProvider : authProviders) {
            info.authProviders.put(authProvider.getName(), authProvider.getAvailableOptions());
        }
    }

    private void setAuditListeners(ServerInfoRepresentation info) {
        info.auditListeners = new LinkedList();
        Set providers = this.providers.listProviderIds(AuditListener.class);
        if (providers != null) {
            info.auditListeners.addAll(providers);
        }
    }

    public static class ServerInfoRepresentation {
        private Map<String, List<String>> themes;
        private List<String> socialProviders;
        private Map<String, List<String>> authProviders;
        private List<String> auditListeners;

        public Map<String, List<String>> getThemes() {
            return this.themes;
        }

        public List<String> getSocialProviders() {
            return this.socialProviders;
        }

        public Map<String, List<String>> getAuthProviders() {
            return this.authProviders;
        }

        public List<String> getAuditListeners() {
            return this.auditListeners;
        }
    }
}

