/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.services.scheduled;

import org.jboss.resteasy.logging.Logger;
import org.keycloak.models.KeycloakSession;
import org.keycloak.provider.ProviderSession;
import org.keycloak.provider.ProviderSessionFactory;
import org.keycloak.services.scheduled.ScheduledTask;

public class ScheduledTaskRunner
implements Runnable {
    private static final Logger logger = Logger.getLogger(ScheduledTaskRunner.class);
    private final ProviderSessionFactory providerSessionFactory;
    private final ScheduledTask task;

    public ScheduledTaskRunner(ProviderSessionFactory providerSessionFactory, ScheduledTask task) {
        this.providerSessionFactory = providerSessionFactory;
        this.task = task;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        ProviderSession providerSession = this.providerSessionFactory.createSession();
        KeycloakSession keycloakSession = (KeycloakSession)providerSession.getProvider(KeycloakSession.class);
        try {
            keycloakSession.getTransaction().begin();
            this.task.run(keycloakSession, providerSession);
            keycloakSession.getTransaction().commit();
            logger.debug("Executed scheduled task " + this.task.getClass().getSimpleName());
        }
        catch (Throwable t) {
            logger.error("Failed to run scheduled task " + this.task.getClass().getSimpleName(), t);
            keycloakSession.getTransaction().rollback();
        }
        finally {
            try {
                providerSession.close();
            }
            catch (Throwable t) {
                logger.error("Failed to close ProviderSession", t);
            }
        }
    }
}

