/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.services;

import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.keycloak.provider.Provider;
import org.keycloak.provider.ProviderFactory;
import org.keycloak.provider.ProviderFactoryLoader;
import org.keycloak.provider.ProviderSession;
import org.keycloak.provider.ProviderSessionFactory;
import org.keycloak.services.DefaultProviderSession;

public class DefaultProviderSessionFactory
implements ProviderSessionFactory {
    private Map<Class<? extends Provider>, ProviderFactoryLoader> loaders = new HashMap<Class<? extends Provider>, ProviderFactoryLoader>();
    private Map<Class<? extends Provider>, String> defaultFactories = new HashMap<Class<? extends Provider>, String>();

    public ProviderSession createSession() {
        return new DefaultProviderSession(this);
    }

    public void close() {
        for (ProviderFactoryLoader loader : this.loaders.values()) {
            loader.close();
        }
    }

    public <T extends Provider> ProviderFactory<T> getProviderFactory(Class<T> clazz) {
        String id = this.defaultFactories.get(clazz);
        if (id == null) {
            return null;
        }
        return this.getProviderFactory(clazz, id);
    }

    public <T extends Provider> ProviderFactory<T> getProviderFactory(Class<T> clazz, String id) {
        ProviderFactoryLoader loader = this.getLoader(clazz);
        return loader != null ? loader.find(id) : null;
    }

    public Set<String> providerIds(Class<? extends Provider> clazz) {
        ProviderFactoryLoader loader = this.getLoader(clazz);
        return loader != null ? loader.providerIds() : null;
    }

    public String getDefaultProvider(Class<? extends Provider> clazz) {
        return this.defaultFactories.get(clazz);
    }

    public void registerLoader(Class<? extends Provider> clazz, ProviderFactoryLoader loader) {
        this.loaders.put(clazz, loader);
    }

    public void registerLoader(Class<? extends Provider> clazz, ProviderFactoryLoader loader, String defaultProvider) {
        this.loaders.put(clazz, loader);
        this.defaultFactories.put(clazz, defaultProvider);
    }

    public void init() {
        for (ProviderFactoryLoader l : this.loaders.values()) {
            l.init();
        }
    }

    private <T extends Provider> ProviderFactoryLoader getLoader(Class<T> clazz) {
        return this.loaders.get(clazz);
    }
}

