/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.services.managers;

import javax.ws.rs.core.HttpHeaders;
import javax.ws.rs.core.UriInfo;
import org.jboss.logging.Logger;
import org.jboss.resteasy.spi.UnauthorizedException;
import org.keycloak.models.RealmModel;
import org.keycloak.models.UserModel;
import org.keycloak.provider.ProviderSession;
import org.keycloak.services.managers.AuthenticationManager;

public class AppAuthManager
extends AuthenticationManager {
    protected static Logger logger = Logger.getLogger(AppAuthManager.class);

    public AppAuthManager(ProviderSession providerSession) {
        super(providerSession);
    }

    public UserModel authenticateRequest(RealmModel realm, UriInfo uriInfo, HttpHeaders headers) {
        AuthenticationManager.AuthResult authResult = this.authenticateIdentityCookie(realm, uriInfo, headers);
        if (authResult != null) {
            return authResult.getUser();
        }
        return this.authenticateBearerToken(realm, uriInfo, headers);
    }

    public String extractAuthorizationHeaderToken(HttpHeaders headers) {
        String tokenString = null;
        String authHeader = (String)headers.getRequestHeaders().getFirst((Object)"Authorization");
        if (authHeader != null) {
            String[] split = authHeader.trim().split("\\s+");
            if (split == null || split.length != 2) {
                throw new UnauthorizedException("Bearer");
            }
            if (!split[0].equalsIgnoreCase("Bearer")) {
                throw new UnauthorizedException("Bearer");
            }
            tokenString = split[1];
        }
        return tokenString;
    }

    public UserModel authenticateBearerToken(RealmModel realm, UriInfo uriInfo, HttpHeaders headers) {
        String tokenString = this.extractAuthorizationHeaderToken(headers);
        if (tokenString == null) {
            return null;
        }
        AuthenticationManager.AuthResult authResult = this.verifyIdentityToken(realm, uriInfo, true, tokenString);
        return authResult != null ? authResult.getUser() : null;
    }
}

