/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.services.resources;

import java.net.URI;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.OPTIONS;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.HttpHeaders;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriBuilder;
import javax.ws.rs.core.UriInfo;
import javax.ws.rs.core.Variant;
import org.jboss.logging.Logger;
import org.jboss.resteasy.spi.BadRequestException;
import org.jboss.resteasy.spi.HttpRequest;
import org.keycloak.account.Account;
import org.keycloak.account.AccountLoader;
import org.keycloak.account.AccountPages;
import org.keycloak.audit.Audit;
import org.keycloak.audit.AuditProvider;
import org.keycloak.audit.Event;
import org.keycloak.authentication.AuthProviderStatus;
import org.keycloak.authentication.AuthenticationProviderException;
import org.keycloak.authentication.AuthenticationProviderManager;
import org.keycloak.models.ApplicationModel;
import org.keycloak.models.AuthenticationLinkModel;
import org.keycloak.models.AuthenticationProviderModel;
import org.keycloak.models.ClientModel;
import org.keycloak.models.OAuthClientModel;
import org.keycloak.models.RealmModel;
import org.keycloak.models.SocialLinkModel;
import org.keycloak.models.UserCredentialModel;
import org.keycloak.models.UserModel;
import org.keycloak.models.utils.TimeBasedOTP;
import org.keycloak.provider.ProviderSession;
import org.keycloak.services.ForbiddenException;
import org.keycloak.services.managers.AppAuthManager;
import org.keycloak.services.managers.Auth;
import org.keycloak.services.managers.ModelToRepresentation;
import org.keycloak.services.managers.SocialRequestManager;
import org.keycloak.services.managers.TokenManager;
import org.keycloak.services.resources.Cors;
import org.keycloak.services.resources.RealmsResource;
import org.keycloak.services.resources.TokenService;
import org.keycloak.services.resources.flows.Flows;
import org.keycloak.services.resources.flows.OAuthRedirect;
import org.keycloak.services.resources.flows.Urls;
import org.keycloak.services.util.ResolveRelative;
import org.keycloak.services.validation.Validation;
import org.keycloak.social.SocialLoader;
import org.keycloak.social.SocialProvider;
import org.keycloak.social.SocialProviderException;

public class AccountService {
    private static final Logger logger = Logger.getLogger(AccountService.class);
    private static final String[] AUDIT_EVENTS = new String[]{"login", "logout", "register", "remove_social_link", "remove_totp", "send_reset_password", "send_verify_email", "social_link", "update_email", "update_password", "update_profile", "update_totp", "verify_email"};
    private static final Set<String> AUDIT_DETAILS = new HashSet<String>();
    public static final String KEYCLOAK_ACCOUNT_IDENTITY_COOKIE = "KEYCLOAK_ACCOUNT_IDENTITY";
    private RealmModel realm;
    @Context
    private HttpRequest request;
    @Context
    protected HttpHeaders headers;
    @Context
    private UriInfo uriInfo;
    @Context
    private ProviderSession providers;
    private final AppAuthManager authManager;
    private final ApplicationModel application;
    private Audit audit;
    private final SocialRequestManager socialRequestManager;
    private Account account;
    private Auth auth;
    private AuditProvider auditProvider;

    public AccountService(RealmModel realm, ApplicationModel application, TokenManager tokenManager, SocialRequestManager socialRequestManager, Audit audit) {
        this.realm = realm;
        this.application = application;
        this.audit = audit;
        this.authManager = new AppAuthManager(this.providers);
        this.socialRequestManager = socialRequestManager;
    }

    public void init() {
        this.auditProvider = (AuditProvider)this.providers.getProvider(AuditProvider.class);
        this.account = AccountLoader.load().createAccount(this.uriInfo).setRealm(this.realm);
        boolean passwordUpdateSupported = false;
        UserModel user = this.authManager.authenticateRequest(this.realm, this.uriInfo, this.headers);
        if (user != null) {
            this.auth = new Auth(this.realm, user, (ClientModel)this.application);
            this.account.setUser(this.auth.getUser());
            AuthenticationLinkModel authLinkModel = this.realm.getAuthenticationLink(this.auth.getUser());
            if (authLinkModel != null) {
                AuthenticationProviderModel authProviderModel = AuthenticationProviderManager.getConfiguredProviderModel((RealmModel)this.realm, (String)authLinkModel.getAuthProvider());
                passwordUpdateSupported = authProviderModel.isPasswordUpdateSupported();
            }
        }
        this.account.setFeatures(this.realm.isSocial(), this.auditProvider != null, passwordUpdateSupported);
    }

    public static UriBuilder accountServiceBaseUrl(UriInfo uriInfo) {
        UriBuilder base = uriInfo.getBaseUriBuilder().path(RealmsResource.class).path(RealmsResource.class, "getAccountService");
        return base;
    }

    public static UriBuilder accountServiceBaseUrl(UriBuilder base) {
        return base.path(RealmsResource.class).path(RealmsResource.class, "getAccountService");
    }

    private Response forwardToPage(String path, AccountPages page) {
        if (this.auth != null) {
            try {
                this.require("manage-account");
            }
            catch (ForbiddenException e) {
                return Flows.forms(this.realm, this.uriInfo).setError("No access").createErrorPage();
            }
            String[] referrer = this.getReferrer();
            if (referrer != null) {
                this.account.setReferrer(referrer);
            }
            return this.account.createResponse(page);
        }
        return this.login(path);
    }

    @Path(value="/")
    @OPTIONS
    public Response accountPreflight() {
        return Cors.add(this.request, Response.ok()).auth().preflight().build();
    }

    @Path(value="/")
    @GET
    public Response accountPage() {
        List types = this.headers.getAcceptableMediaTypes();
        if (types.contains(MediaType.WILDCARD_TYPE) || types.contains(MediaType.TEXT_HTML_TYPE)) {
            return this.forwardToPage(null, AccountPages.ACCOUNT);
        }
        if (types.contains(MediaType.APPLICATION_JSON_TYPE)) {
            this.requireOneOf("manage-account", "view-profile");
            return Cors.add(this.request, Response.ok((Object)ModelToRepresentation.toRepresentation(this.auth.getUser()))).auth().allowedOrigins(this.auth.getClient()).build();
        }
        return Response.notAcceptable((List)Variant.VariantListBuilder.newInstance().mediaTypes(new MediaType[]{MediaType.TEXT_HTML_TYPE, MediaType.APPLICATION_JSON_TYPE}).build()).build();
    }

    public static UriBuilder totpUrl(UriBuilder base) {
        return RealmsResource.accountUrl(base).path(AccountService.class, "totpPage");
    }

    @Path(value="totp")
    @GET
    public Response totpPage() {
        return this.forwardToPage("totp", AccountPages.TOTP);
    }

    public static UriBuilder passwordUrl(UriBuilder base) {
        return RealmsResource.accountUrl(base).path(AccountService.class, "passwordPage");
    }

    @Path(value="password")
    @GET
    public Response passwordPage() {
        return this.forwardToPage("password", AccountPages.PASSWORD);
    }

    public static UriBuilder socialUrl(UriBuilder base) {
        return RealmsResource.accountUrl(base).path(AccountService.class, "socialPage");
    }

    @Path(value="social")
    @GET
    public Response socialPage() {
        return this.forwardToPage("social", AccountPages.SOCIAL);
    }

    public static UriBuilder logUrl(UriBuilder base) {
        return RealmsResource.accountUrl(base).path(AccountService.class, "logPage");
    }

    @Path(value="log")
    @GET
    public Response logPage() {
        if (this.auth != null) {
            List events = this.auditProvider.createQuery().event(AUDIT_EVENTS).user(this.auth.getUser().getId()).maxResults(30).getResultList();
            for (Event e : events) {
                e.setEvent(e.getEvent().replace('_', ' '));
                HashMap details = new HashMap();
                if (e.getDetails() != null) {
                    Iterator itr = e.getDetails().keySet().iterator();
                    for (Map.Entry d : e.getDetails().entrySet()) {
                        if (!AUDIT_DETAILS.contains(d.getKey())) continue;
                        details.put(((String)d.getKey()).replace('_', ' '), d.getValue());
                    }
                }
                e.setDetails(details);
            }
            this.account.setEvents(events);
        }
        return this.forwardToPage("log", AccountPages.LOG);
    }

    @Path(value="/")
    @POST
    @Consumes(value={"application/x-www-form-urlencoded"})
    public Response processAccountUpdate(MultivaluedMap<String, String> formData) {
        this.require("manage-account");
        UserModel user = this.auth.getUser();
        String error = Validation.validateUpdateProfileForm(formData);
        if (error != null) {
            return this.account.setError(error).createResponse(AccountPages.ACCOUNT);
        }
        user.setFirstName((String)formData.getFirst((Object)"firstName"));
        user.setLastName((String)formData.getFirst((Object)"lastName"));
        String email = (String)formData.getFirst((Object)"email");
        String oldEmail = user.getEmail();
        boolean emailChanged = oldEmail != null ? !oldEmail.equals(email) : email != null;
        user.setEmail((String)formData.getFirst((Object)"email"));
        this.audit.event("update_profile").client(this.auth.getClient()).user(this.auth.getUser()).success();
        if (emailChanged) {
            user.setEmailVerified(false);
            this.audit.clone().event("update_email").detail("previous_email", oldEmail).detail("updated_email", email).success();
        }
        return this.account.setSuccess("accountUpdated").createResponse(AccountPages.ACCOUNT);
    }

    @Path(value="totp-remove")
    @GET
    public Response processTotpRemove() {
        this.require("manage-account");
        UserModel user = this.auth.getUser();
        user.setTotp(false);
        this.audit.event("remove_totp").client(this.auth.getClient()).user(this.auth.getUser()).success();
        return this.account.setSuccess("successTotpRemoved").createResponse(AccountPages.TOTP);
    }

    @Path(value="totp")
    @POST
    @Consumes(value={"application/x-www-form-urlencoded"})
    public Response processTotpUpdate(MultivaluedMap<String, String> formData) {
        this.require("manage-account");
        UserModel user = this.auth.getUser();
        String totp = (String)formData.getFirst((Object)"totp");
        String totpSecret = (String)formData.getFirst((Object)"totpSecret");
        if (Validation.isEmpty(totp)) {
            return this.account.setError("missingTotp").createResponse(AccountPages.TOTP);
        }
        if (!new TimeBasedOTP().validate(totp, totpSecret.getBytes())) {
            return this.account.setError("invalidTotp").createResponse(AccountPages.TOTP);
        }
        UserCredentialModel credentials = new UserCredentialModel();
        credentials.setType("totp");
        credentials.setValue(totpSecret);
        this.realm.updateCredential(user, credentials);
        user.setTotp(true);
        this.audit.event("update_totp").client(this.auth.getClient()).user(this.auth.getUser()).success();
        return this.account.setSuccess("successTotp").createResponse(AccountPages.TOTP);
    }

    @Path(value="password")
    @POST
    @Consumes(value={"application/x-www-form-urlencoded"})
    public Response processPasswordUpdate(MultivaluedMap<String, String> formData) {
        this.require("manage-account");
        UserModel user = this.auth.getUser();
        String password = (String)formData.getFirst((Object)"password");
        String passwordNew = (String)formData.getFirst((Object)"password-new");
        String passwordConfirm = (String)formData.getFirst((Object)"password-confirm");
        if (Validation.isEmpty(passwordNew)) {
            return this.account.setError("missingPassword").createResponse(AccountPages.PASSWORD);
        }
        if (!passwordNew.equals(passwordConfirm)) {
            return this.account.setError("invalidPasswordConfirm").createResponse(AccountPages.PASSWORD);
        }
        AuthenticationProviderManager authProviderManager = AuthenticationProviderManager.getManager((RealmModel)this.realm, (ProviderSession)this.providers);
        if (Validation.isEmpty(password)) {
            return this.account.setError("missingPassword").createResponse(AccountPages.PASSWORD);
        }
        if (authProviderManager.validatePassword(user, password) != AuthProviderStatus.SUCCESS) {
            return this.account.setError("invalidPasswordExisting").createResponse(AccountPages.PASSWORD);
        }
        try {
            boolean passwordUpdateSuccess = authProviderManager.updatePassword(user, passwordNew);
            if (!passwordUpdateSuccess) {
                return this.account.setError("Password update failed").createResponse(AccountPages.PASSWORD);
            }
        }
        catch (AuthenticationProviderException ape) {
            return this.account.setError(ape.getMessage()).createResponse(AccountPages.PASSWORD);
        }
        this.audit.event("update_password").client(this.auth.getClient()).user(this.auth.getUser()).success();
        return this.account.setSuccess("accountPasswordUpdated").createResponse(AccountPages.PASSWORD);
    }

    @Path(value="social-update")
    @GET
    public Response processSocialUpdate(@QueryParam(value="action") String action, @QueryParam(value="provider_id") String providerId) {
        this.require("manage-account");
        UserModel user = this.auth.getUser();
        if (Validation.isEmpty(providerId)) {
            return this.account.setError("missingSocialProvider").createResponse(AccountPages.SOCIAL);
        }
        AccountSocialAction accountSocialAction = AccountSocialAction.getAction(action);
        if (accountSocialAction == null) {
            return this.account.setError("invalidSocialAction").createResponse(AccountPages.SOCIAL);
        }
        SocialProvider provider = SocialLoader.load((String)providerId);
        if (provider == null) {
            return this.account.setError("socialProviderNotFound").createResponse(AccountPages.SOCIAL);
        }
        if (!user.isEnabled()) {
            return this.account.setError("accountDisabled").createResponse(AccountPages.SOCIAL);
        }
        switch (accountSocialAction) {
            case ADD: {
                String redirectUri = UriBuilder.fromUri((URI)Urls.accountSocialPage(this.uriInfo.getBaseUri(), this.realm.getName())).build(new Object[0]).toString();
                try {
                    return Flows.social(this.socialRequestManager, this.realm, this.uriInfo, provider).putClientAttribute("realm", this.realm.getName()).putClientAttribute("clientId", "account").putClientAttribute("state", UUID.randomUUID().toString()).putClientAttribute("redirectUri", redirectUri).putClientAttribute("userId", user.getId()).redirectToSocialProvider();
                }
                catch (SocialProviderException spe) {
                    return this.account.setError("socialRedirectError").createResponse(AccountPages.SOCIAL);
                }
            }
            case REMOVE: {
                SocialLinkModel link = this.realm.getSocialLink(user, providerId);
                if (link != null) {
                    if (this.realm.getSocialLinks(user).size() > 1 || this.realm.getAuthenticationLink(user) != null) {
                        this.realm.removeSocialLink(user, providerId);
                        logger.debug((Object)("Social provider " + providerId + " removed successfully from user " + user.getLoginName()));
                        this.audit.event("remove_social_link").client(this.auth.getClient()).user(this.auth.getUser()).detail("username", link.getSocialUserId() + "@" + link.getSocialProvider()).success();
                        return this.account.setSuccess("socialProviderRemoved").createResponse(AccountPages.SOCIAL);
                    }
                    return this.account.setError("socialRemovingLastProvider").createResponse(AccountPages.SOCIAL);
                }
                return this.account.setError("socialLinkNotActive").createResponse(AccountPages.SOCIAL);
            }
        }
        logger.warn((Object)"Action is null!");
        return null;
    }

    public static UriBuilder loginRedirectUrl(UriBuilder base) {
        return RealmsResource.accountUrl(base).path(AccountService.class, "loginRedirect");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Path(value="login-redirect")
    @GET
    public Response loginRedirect(@QueryParam(value="code") String code, @QueryParam(value="state") String state, @QueryParam(value="error") String error, @QueryParam(value="path") String path, @QueryParam(value="referrer") String referrer, @Context HttpHeaders headers) {
        URI redirectUri;
        if (error != null) {
            logger.debug((Object)"error from oauth");
            throw new ForbiddenException("error");
        }
        if (!this.realm.isEnabled()) {
            logger.debug((Object)"realm not enabled");
            throw new ForbiddenException();
        }
        if (!this.application.isEnabled()) {
            logger.debug((Object)"account management app not enabled");
            throw new ForbiddenException();
        }
        if (code == null) {
            logger.debug((Object)"code not specified");
            throw new BadRequestException("code not specified");
        }
        if (state == null) {
            logger.debug((Object)"state not specified");
            throw new BadRequestException("state not specified");
        }
        URI accountUri = Urls.accountBase(this.uriInfo.getBaseUri()).path("/").build(new Object[]{this.realm.getName()});
        URI uRI = redirectUri = path != null ? accountUri.resolve(path) : accountUri;
        if (referrer != null) {
            redirectUri = redirectUri.resolve("?referrer=" + referrer);
        }
        Response response = Response.status((int)302).location(redirectUri).build();
        return response;
    }

    @Path(value="logout")
    @GET
    public Response logout() {
        URI redirect = Urls.accountBase(this.uriInfo.getBaseUri()).build(new Object[]{this.realm.getName()});
        return Response.status((int)302).location(TokenService.logoutUrl(this.uriInfo).queryParam("redirect_uri", new Object[]{redirect.toString()}).build(new Object[]{this.realm.getName()})).build();
    }

    private Response login(String path) {
        String referrerUri;
        String referrer;
        OAuthRedirect oauth = new OAuthRedirect();
        String authUrl = Urls.realmLoginPage(this.uriInfo.getBaseUri(), this.realm.getName()).toString();
        oauth.setAuthUrl(authUrl);
        oauth.setClientId("account");
        UriBuilder uriBuilder = Urls.accountPageBuilder(this.uriInfo.getBaseUri()).path(AccountService.class, "loginRedirect");
        if (path != null) {
            uriBuilder.queryParam("path", new Object[]{path});
        }
        if ((referrer = (String)this.uriInfo.getQueryParameters().getFirst((Object)"referrer")) != null) {
            uriBuilder.queryParam("referrer", new Object[]{referrer});
        }
        if ((referrerUri = (String)this.uriInfo.getQueryParameters().getFirst((Object)"referrer_uri")) != null) {
            uriBuilder.queryParam("referrer_uri", new Object[]{referrerUri});
        }
        URI accountUri = uriBuilder.build(new Object[]{this.realm.getName()});
        oauth.setStateCookiePath(accountUri.getRawPath());
        return oauth.redirect(this.uriInfo, accountUri.toString());
    }

    private String[] getReferrer() {
        OAuthClientModel client;
        String referrer = (String)this.uriInfo.getQueryParameters().getFirst((Object)"referrer");
        if (referrer == null) {
            return null;
        }
        String referrerUri = (String)this.uriInfo.getQueryParameters().getFirst((Object)"referrer_uri");
        ApplicationModel application = this.realm.getApplicationByName(referrer);
        if (application != null ? (referrerUri = referrerUri != null ? TokenService.verifyRedirectUri(this.uriInfo, referrerUri, (ClientModel)application) : ResolveRelative.resolveRelativeUri(this.uriInfo.getRequestUri(), application.getBaseUrl())) != null : referrerUri != null && (client = this.realm.getOAuthClient(referrer)) != null && (referrerUri = TokenService.verifyRedirectUri(this.uriInfo, referrerUri, (ClientModel)application)) != null) {
            return new String[]{referrer, referrerUri};
        }
        return null;
    }

    public void require(String role) {
        if (this.auth == null) {
            throw new ForbiddenException();
        }
        if (!this.auth.hasAppRole(this.application, role)) {
            throw new ForbiddenException();
        }
    }

    public void requireOneOf(String ... roles) {
        if (this.auth == null) {
            throw new ForbiddenException();
        }
        if (!this.auth.hasOneOfAppRole(this.application, roles)) {
            throw new ForbiddenException();
        }
    }

    static {
        AUDIT_DETAILS.add("updated_email");
        AUDIT_DETAILS.add("email");
        AUDIT_DETAILS.add("previous_email");
        AUDIT_DETAILS.add("username");
        AUDIT_DETAILS.add("remember_me");
        AUDIT_DETAILS.add("register_method");
        AUDIT_DETAILS.add("auth_method");
    }

    public static enum AccountSocialAction {
        ADD,
        REMOVE;


        public static AccountSocialAction getAction(String action) {
            if ("add".equalsIgnoreCase(action)) {
                return ADD;
            }
            if ("remove".equalsIgnoreCase(action)) {
                return REMOVE;
            }
            return null;
        }
    }
}

