/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.services.resources;

import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import java.util.StringTokenizer;
import javax.servlet.ServletContext;
import javax.ws.rs.core.Application;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.UriInfo;
import org.jboss.logging.Logger;
import org.jboss.resteasy.core.Dispatcher;
import org.jboss.resteasy.spi.ResteasyProviderFactory;
import org.keycloak.SkeletonKeyContextResolver;
import org.keycloak.audit.AuditListener;
import org.keycloak.audit.AuditListenerFactory;
import org.keycloak.audit.AuditProvider;
import org.keycloak.audit.AuditProviderFactory;
import org.keycloak.authentication.AuthenticationProvider;
import org.keycloak.authentication.AuthenticationProviderFactory;
import org.keycloak.exportimport.ExportImportProvider;
import org.keycloak.models.Config;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.KeycloakSessionFactory;
import org.keycloak.models.ModelProvider;
import org.keycloak.models.RealmModel;
import org.keycloak.models.utils.ModelProviderUtils;
import org.keycloak.provider.ProviderFactory;
import org.keycloak.provider.ProviderFactoryLoader;
import org.keycloak.provider.ProviderSessionFactory;
import org.keycloak.representations.idm.RealmRepresentation;
import org.keycloak.services.DefaultProviderSessionFactory;
import org.keycloak.services.managers.ApplianceBootstrap;
import org.keycloak.services.managers.BruteForceProtector;
import org.keycloak.services.managers.RealmManager;
import org.keycloak.services.managers.SocialRequestManager;
import org.keycloak.services.managers.TokenManager;
import org.keycloak.services.resources.JsResource;
import org.keycloak.services.resources.QRCodeResource;
import org.keycloak.services.resources.RealmsResource;
import org.keycloak.services.resources.SocialResource;
import org.keycloak.services.resources.ThemeResource;
import org.keycloak.services.resources.WelcomeResource;
import org.keycloak.services.resources.admin.AdminRoot;
import org.keycloak.services.scheduled.ClearExpiredAuditEvents;
import org.keycloak.services.scheduled.ClearExpiredUserSessions;
import org.keycloak.services.scheduled.ScheduledTaskRunner;
import org.keycloak.timer.TimerProvider;
import org.keycloak.timer.TimerProviderFactory;
import org.keycloak.util.JsonSerialization;
import org.keycloak.util.ProviderLoader;

public class KeycloakApplication
extends Application {
    private static final Logger log = Logger.getLogger(KeycloakApplication.class);
    protected Set<Object> singletons = new HashSet<Object>();
    protected Set<Class<?>> classes = new HashSet();
    protected KeycloakSessionFactory factory;
    protected ProviderSessionFactory providerSessionFactory;
    protected String contextPath;

    public KeycloakApplication(@Context ServletContext context, @Context Dispatcher dispatcher) {
        dispatcher.getDefaultContextObjects().put(KeycloakApplication.class, this);
        this.contextPath = context.getContextPath();
        this.factory = KeycloakApplication.createSessionFactory();
        BruteForceProtector protector = new BruteForceProtector(this.factory);
        dispatcher.getDefaultContextObjects().put(BruteForceProtector.class, protector);
        ResteasyProviderFactory.pushContext(BruteForceProtector.class, (Object)protector);
        protector.start();
        context.setAttribute(BruteForceProtector.class.getName(), (Object)protector);
        this.providerSessionFactory = KeycloakApplication.createProviderSessionFactory();
        context.setAttribute(KeycloakSessionFactory.class.getName(), (Object)this.factory);
        context.setAttribute(ProviderSessionFactory.class.getName(), (Object)this.providerSessionFactory);
        TokenManager tokenManager = new TokenManager();
        SocialRequestManager socialRequestManager = new SocialRequestManager();
        this.singletons.add(new RealmsResource(tokenManager, socialRequestManager));
        this.singletons.add(new SocialResource(tokenManager, socialRequestManager));
        this.singletons.add(new AdminRoot(tokenManager));
        this.classes.add(SkeletonKeyContextResolver.class);
        this.classes.add(QRCodeResource.class);
        this.classes.add(ThemeResource.class);
        this.classes.add(JsResource.class);
        this.classes.add(WelcomeResource.class);
        this.setupDefaultRealm(context.getContextPath());
        KeycloakApplication.setupScheduledTasks(this.providerSessionFactory, this.factory);
        this.importRealms(context);
        this.checkExportImportProvider();
    }

    public String getContextPath() {
        return this.contextPath;
    }

    public URI getBaseUri(UriInfo uriInfo) {
        return uriInfo.getBaseUriBuilder().replacePath(this.getContextPath()).build(new Object[0]);
    }

    protected void setupDefaultRealm(String contextPath) {
        new ApplianceBootstrap().bootstrap(this.factory, contextPath);
    }

    public static KeycloakSessionFactory createSessionFactory() {
        ModelProvider provider = ModelProviderUtils.getConfiguredModelProvider();
        if (provider != null) {
            log.debug((Object)("Model provider: " + provider.getId()));
            return provider.createFactory();
        }
        throw new RuntimeException("Model provider not found");
    }

    public static DefaultProviderSessionFactory createProviderSessionFactory() {
        DefaultProviderSessionFactory factory = new DefaultProviderSessionFactory();
        factory.registerLoader(AuditProvider.class, ProviderFactoryLoader.create(AuditProviderFactory.class), Config.getAuditProvider());
        factory.registerLoader(AuditListener.class, ProviderFactoryLoader.create(AuditListenerFactory.class));
        factory.registerLoader(TimerProvider.class, ProviderFactoryLoader.create(TimerProviderFactory.class), Config.getTimerProvider());
        try {
            Class<?> identityManagerProvider = Class.forName("org.keycloak.picketlink.IdentityManagerProvider");
            Class<?> identityManagerProviderFactory = Class.forName("org.keycloak.picketlink.IdentityManagerProviderFactory");
            factory.registerLoader(identityManagerProvider, ProviderFactoryLoader.create(identityManagerProviderFactory), Config.getIdentityManagerProvider());
        }
        catch (ClassNotFoundException e) {
            log.warn((Object)"Picketlink libraries not installed for IdentityManagerProviderFactory");
        }
        factory.registerLoader(AuthenticationProvider.class, ProviderFactoryLoader.create(AuthenticationProviderFactory.class));
        factory.init();
        return factory;
    }

    public static void setupScheduledTasks(ProviderSessionFactory providerSessionFactory, KeycloakSessionFactory keycloakSessionFactory) {
        ProviderFactory timerFactory = providerSessionFactory.getProviderFactory(TimerProvider.class);
        if (timerFactory == null) {
            log.error((Object)"Can't setup schedule tasks, no timer provider found");
            return;
        }
        TimerProvider timer = (TimerProvider)timerFactory.create(null);
        timer.schedule((Runnable)new ScheduledTaskRunner(keycloakSessionFactory, providerSessionFactory, new ClearExpiredAuditEvents()), Config.getAuditExpirationSchedule());
        timer.schedule((Runnable)new ScheduledTaskRunner(keycloakSessionFactory, providerSessionFactory, new ClearExpiredUserSessions()), Config.getUserExpirationSchedule());
    }

    public KeycloakSessionFactory getFactory() {
        return this.factory;
    }

    public ProviderSessionFactory getProviderSessionFactory() {
        return this.providerSessionFactory;
    }

    public Set<Class<?>> getClasses() {
        return this.classes;
    }

    public Set<Object> getSingletons() {
        return this.singletons;
    }

    public void importRealms(ServletContext context) {
        this.importRealmFile();
        this.importRealmResources(context);
    }

    public void importRealmResources(ServletContext context) {
        String resources = context.getInitParameter("keycloak.import.realm.resources");
        if (resources != null) {
            StringTokenizer tokenizer = new StringTokenizer(resources, ",");
            while (tokenizer.hasMoreTokens()) {
                String resource = tokenizer.nextToken().trim();
                InputStream is = context.getResourceAsStream(resource);
                if (is == null) {
                    log.warn((Object)("Could not find realm resource to import: " + resource));
                }
                RealmRepresentation rep = KeycloakApplication.loadJson(is, RealmRepresentation.class);
                this.importRealm(rep, "resource " + resource);
            }
        }
    }

    public void importRealmFile() {
        String file = System.getProperty("keycloak.import");
        if (file != null) {
            RealmRepresentation rep = null;
            try {
                rep = KeycloakApplication.loadJson(new FileInputStream(file), RealmRepresentation.class);
            }
            catch (FileNotFoundException e) {
                throw new RuntimeException(e);
            }
            this.importRealm(rep, "file " + file);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void importRealm(RealmRepresentation rep, String from) {
        KeycloakSession session = this.factory.createSession();
        try {
            session.getTransaction().begin();
            RealmManager manager = new RealmManager(session);
            if (rep.getId() != null && manager.getRealm(rep.getId()) != null) {
                log.info((Object)("Not importing realm " + rep.getRealm() + " from " + from + ".  It already exists."));
                return;
            }
            if (manager.getRealmByName(rep.getRealm()) != null) {
                log.info((Object)("Not importing realm " + rep.getRealm() + " from " + from + ".  It already exists."));
                return;
            }
            RealmModel realm = manager.createRealm(rep.getId(), rep.getRealm());
            manager.importRealm(rep, realm);
            log.info((Object)("Imported realm " + realm.getName() + " from " + from));
            session.getTransaction().commit();
        }
        finally {
            session.close();
        }
    }

    private static <T> T loadJson(InputStream is, Class<T> type) {
        try {
            return (T)JsonSerialization.readValue((InputStream)is, type);
        }
        catch (IOException e) {
            throw new RuntimeException("Failed to parse json", e);
        }
    }

    protected void checkExportImportProvider() {
        Iterator providers = ProviderLoader.load(ExportImportProvider.class).iterator();
        if (providers.hasNext()) {
            ExportImportProvider exportImport = (ExportImportProvider)providers.next();
            exportImport.checkExportImport(this.factory);
        } else {
            log.warn((Object)"No ExportImportProvider found!");
        }
    }
}

