/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.services.resources;

import java.io.InputStream;
import javax.activation.FileTypeMap;
import javax.activation.MimetypesFileTypeMap;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.core.Response;
import org.jboss.logging.Logger;
import org.keycloak.freemarker.Theme;
import org.keycloak.freemarker.ThemeLoader;

@Path(value="/theme")
public class ThemeResource {
    private static final Logger logger = Logger.getLogger(ThemeResource.class);
    private static FileTypeMap mimeTypes = MimetypesFileTypeMap.getDefaultFileTypeMap();

    @GET
    @Path(value="/{themType}/{themeName}/{path:.*}")
    public Response getResource(@PathParam(value="themType") String themType, @PathParam(value="themeName") String themeName, @PathParam(value="path") String path) {
        try {
            Theme theme = ThemeLoader.createTheme((String)themeName, (Theme.Type)Theme.Type.valueOf((String)themType.toUpperCase()));
            InputStream resource = theme.getResourceAsStream(path);
            if (resource != null) {
                return Response.ok((Object)resource).type(mimeTypes.getContentType(path)).build();
            }
            return Response.status((Response.Status)Response.Status.NOT_FOUND).build();
        }
        catch (Exception e) {
            logger.warn((Object)"Failed to get theme resource", (Throwable)e);
            return Response.serverError().build();
        }
    }
}

