/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.services.resources.admin;

import java.io.IOException;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.HttpHeaders;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriBuilder;
import javax.ws.rs.core.UriInfo;
import org.jboss.logging.Logger;
import org.jboss.resteasy.spi.NotFoundException;
import org.jboss.resteasy.spi.ResteasyProviderFactory;
import org.jboss.resteasy.spi.UnauthorizedException;
import org.keycloak.jose.jws.JWSInput;
import org.keycloak.models.ApplicationModel;
import org.keycloak.models.ClientModel;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.RealmModel;
import org.keycloak.models.UserModel;
import org.keycloak.representations.AccessToken;
import org.keycloak.services.managers.AppAuthManager;
import org.keycloak.services.managers.Auth;
import org.keycloak.services.managers.RealmManager;
import org.keycloak.services.managers.TokenManager;
import org.keycloak.services.resources.admin.AdminConsole;
import org.keycloak.services.resources.admin.RealmsAdminResource;
import org.keycloak.services.resources.admin.ServerInfoAdminResource;

@Path(value="/admin")
public class AdminRoot {
    protected static final Logger logger = Logger.getLogger(AdminRoot.class);
    @Context
    protected UriInfo uriInfo;
    protected AppAuthManager authManager;
    protected TokenManager tokenManager;
    @Context
    protected KeycloakSession session;

    public AdminRoot(TokenManager tokenManager) {
        this.tokenManager = tokenManager;
        this.authManager = new AppAuthManager(null);
    }

    public static UriBuilder adminBaseUrl(UriInfo uriInfo) {
        return AdminRoot.adminBaseUrl(uriInfo.getBaseUriBuilder());
    }

    public static UriBuilder adminBaseUrl(UriBuilder base) {
        return base.path(AdminRoot.class);
    }

    @GET
    public Response masterRealmAdminConsoleRedirect() {
        RealmModel master = new RealmManager(this.session).getKeycloakAdminstrationRealm();
        return Response.status((int)302).location(this.uriInfo.getBaseUriBuilder().path(AdminRoot.class).path(AdminRoot.class, "getAdminConsole").path("index.html").build(new Object[]{master.getName()})).build();
    }

    @Path(value="index.html")
    @GET
    public Response masterRealmAdminConsoleRedirectHtml() {
        return this.masterRealmAdminConsoleRedirect();
    }

    protected RealmModel locateRealm(String name, RealmManager realmManager) {
        RealmModel realm = realmManager.getRealmByName(name);
        if (realm == null) {
            throw new NotFoundException("Realm " + name + " not found");
        }
        return realm;
    }

    public static UriBuilder adminConsoleUrl(UriInfo uriInfo) {
        return AdminRoot.adminConsoleUrl(uriInfo.getBaseUriBuilder());
    }

    public static UriBuilder adminConsoleUrl(UriBuilder base) {
        return AdminRoot.adminBaseUrl(base).path(AdminRoot.class, "getAdminConsole");
    }

    @Path(value="{realm}/console")
    public AdminConsole getAdminConsole(@PathParam(value="realm") String name) {
        logger.info((Object)("*** get console for realm: " + name));
        RealmManager realmManager = new RealmManager(this.session);
        RealmModel realm = this.locateRealm(name, realmManager);
        AdminConsole service = new AdminConsole(realm);
        ResteasyProviderFactory.getInstance().injectProperties((Object)service);
        logger.info((Object)"returning AdminConsole");
        return service;
    }

    protected Auth authenticateRealmAdminRequest(HttpHeaders headers) {
        AccessToken token;
        String tokenString = this.authManager.extractAuthorizationHeaderToken(headers);
        if (tokenString == null) {
            throw new UnauthorizedException("Bearer");
        }
        JWSInput input = new JWSInput(tokenString);
        try {
            token = (AccessToken)input.readJsonContent(AccessToken.class);
        }
        catch (IOException e) {
            throw new UnauthorizedException("Bearer token format error");
        }
        String realmName = token.getAudience();
        RealmManager realmManager = new RealmManager(this.session);
        RealmModel realm = realmManager.getRealmByName(realmName);
        if (realm == null) {
            throw new UnauthorizedException("Unknown realm in token");
        }
        UserModel user = this.authManager.authenticateBearerToken(realm, this.uriInfo, headers);
        if (user == null) {
            logger.debug((Object)"Token not valid");
            throw new UnauthorizedException("Bearer");
        }
        ApplicationModel consoleApp = realm.getApplicationByName("security-admin-console");
        if (consoleApp == null) {
            throw new NotFoundException("Could not find admin console application");
        }
        Auth auth = new Auth(realm, user, (ClientModel)consoleApp);
        return auth;
    }

    public static UriBuilder realmsUrl(UriInfo uriInfo) {
        return AdminRoot.realmsUrl(uriInfo.getBaseUriBuilder());
    }

    public static UriBuilder realmsUrl(UriBuilder base) {
        return AdminRoot.adminBaseUrl(base).path(AdminRoot.class, "getRealmsAdmin");
    }

    @Path(value="realms")
    public RealmsAdminResource getRealmsAdmin(@Context HttpHeaders headers) {
        Auth auth = this.authenticateRealmAdminRequest(headers);
        RealmsAdminResource adminResource = new RealmsAdminResource(auth, this.tokenManager);
        ResteasyProviderFactory.getInstance().injectProperties((Object)adminResource);
        return adminResource;
    }

    @Path(value="serverinfo")
    public ServerInfoAdminResource getServerInfo(@Context HttpHeaders headers) {
        ServerInfoAdminResource adminResource = new ServerInfoAdminResource();
        ResteasyProviderFactory.getInstance().injectProperties((Object)adminResource);
        return adminResource;
    }
}

