/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.services.managers;

import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.jboss.logging.Logger;
import org.keycloak.Config;
import org.keycloak.models.AccountRoles;
import org.keycloak.models.AdminRoles;
import org.keycloak.models.ApplicationModel;
import org.keycloak.models.AuthenticationLinkModel;
import org.keycloak.models.AuthenticationProviderModel;
import org.keycloak.models.ClientModel;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.OAuthClientModel;
import org.keycloak.models.PasswordPolicy;
import org.keycloak.models.RealmModel;
import org.keycloak.models.RoleModel;
import org.keycloak.models.SocialLinkModel;
import org.keycloak.models.UserCredentialModel;
import org.keycloak.models.UserModel;
import org.keycloak.models.utils.KeycloakModelUtils;
import org.keycloak.representations.idm.ApplicationRepresentation;
import org.keycloak.representations.idm.AuthenticationLinkRepresentation;
import org.keycloak.representations.idm.AuthenticationProviderRepresentation;
import org.keycloak.representations.idm.CredentialRepresentation;
import org.keycloak.representations.idm.OAuthClientRepresentation;
import org.keycloak.representations.idm.RealmAuditRepresentation;
import org.keycloak.representations.idm.RealmRepresentation;
import org.keycloak.representations.idm.RoleRepresentation;
import org.keycloak.representations.idm.ScopeMappingRepresentation;
import org.keycloak.representations.idm.SocialLinkRepresentation;
import org.keycloak.representations.idm.SocialMappingRepresentation;
import org.keycloak.representations.idm.UserRepresentation;
import org.keycloak.representations.idm.UserRoleMappingRepresentation;
import org.keycloak.services.managers.ApplicationManager;
import org.keycloak.services.managers.OAuthClientManager;

public class RealmManager {
    protected static final Logger logger = Logger.getLogger(RealmManager.class);
    protected KeycloakSession identitySession;
    protected String contextPath = "";

    public String getContextPath() {
        return this.contextPath;
    }

    public void setContextPath(String contextPath) {
        this.contextPath = contextPath;
    }

    public RealmManager(KeycloakSession identitySession) {
        this.identitySession = identitySession;
    }

    public RealmModel getKeycloakAdminstrationRealm() {
        return this.getRealm(Config.getAdminRealm());
    }

    public RealmModel getRealm(String id) {
        return this.identitySession.getRealm(id);
    }

    public RealmModel getRealmByName(String name) {
        return this.identitySession.getRealmByName(name);
    }

    public RealmModel createRealm(String name) {
        return this.createRealm(name, name);
    }

    public RealmModel createRealm(String id, String name) {
        if (id == null) {
            id = KeycloakModelUtils.generateId();
        }
        RealmModel realm = this.identitySession.createRealm(id, name);
        realm.setName(name);
        this.setupRealmDefaults(realm);
        this.setupMasterAdminManagement(realm);
        this.setupRealmAdminManagement(realm);
        this.setupAccountManagement(realm);
        this.setupAdminConsole(realm);
        realm.setAuditListeners(Collections.singleton("jboss-logging"));
        return realm;
    }

    protected void setupAdminConsole(RealmModel realm) {
        RoleModel adminRole;
        ApplicationModel adminConsole = realm.getApplicationByName("security-admin-console");
        if (adminConsole == null) {
            adminConsole = new ApplicationManager(this).createApplication(realm, "security-admin-console");
        }
        String baseUrl = this.contextPath + "/admin/" + realm.getName() + "/console";
        adminConsole.setBaseUrl(baseUrl + "/index.html");
        adminConsole.setEnabled(true);
        adminConsole.setPublicClient(true);
        adminConsole.addRedirectUri(baseUrl + "/*");
        if (realm.getName().equals(Config.getAdminRealm())) {
            adminRole = realm.getRole(AdminRoles.ADMIN);
        } else {
            String realmAdminApplicationName = this.getRealmAdminApplicationName(realm);
            ApplicationModel realmAdminApp = realm.getApplicationByName(realmAdminApplicationName);
            adminRole = realmAdminApp.getRole(AdminRoles.REALM_ADMIN);
        }
        realm.addScopeMapping((ClientModel)adminConsole, adminRole);
    }

    public String getMasterRealmAdminApplicationName(RealmModel realm) {
        return realm.getName() + "-realm";
    }

    public String getRealmAdminApplicationName(RealmModel realm) {
        return "realm-management";
    }

    protected void setupRealmDefaults(RealmModel realm) {
        realm.setBruteForceProtected(false);
        realm.setMaxFailureWaitSeconds(900);
        realm.setMinimumQuickLoginWaitSeconds(60);
        realm.setWaitIncrementSeconds(60);
        realm.setQuickLoginCheckMilliSeconds(1000L);
        realm.setMaxDeltaTimeSeconds(43200);
        realm.setFailureFactor(30);
    }

    public boolean removeRealm(RealmModel realm) {
        boolean removed = this.identitySession.removeRealm(realm.getId());
        if (removed) {
            this.getKeycloakAdminstrationRealm().removeApplication(realm.getMasterAdminApp().getId());
        }
        return removed;
    }

    public void generateRealmKeys(RealmModel realm) {
        KeyPair keyPair = null;
        try {
            keyPair = KeyPairGenerator.getInstance("RSA").generateKeyPair();
        }
        catch (NoSuchAlgorithmException e) {
            throw new RuntimeException(e);
        }
        realm.setPrivateKey(keyPair.getPrivate());
        realm.setPublicKey(keyPair.getPublic());
    }

    public void updateRealm(RealmRepresentation rep, RealmModel realm) {
        if (rep.getRealm() != null) {
            realm.setName(rep.getRealm());
        }
        if (rep.isEnabled() != null) {
            realm.setEnabled(rep.isEnabled().booleanValue());
        }
        if (rep.isSocial() != null) {
            realm.setSocial(rep.isSocial().booleanValue());
        }
        if (rep.isBruteForceProtected() != null) {
            realm.setBruteForceProtected(rep.isBruteForceProtected().booleanValue());
        }
        if (rep.getMaxFailureWaitSeconds() != null) {
            realm.setMaxFailureWaitSeconds(rep.getMaxFailureWaitSeconds().intValue());
        }
        if (rep.getMinimumQuickLoginWaitSeconds() != null) {
            realm.setMinimumQuickLoginWaitSeconds(rep.getMinimumQuickLoginWaitSeconds().intValue());
        }
        if (rep.getWaitIncrementSeconds() != null) {
            realm.setWaitIncrementSeconds(rep.getWaitIncrementSeconds().intValue());
        }
        if (rep.getQuickLoginCheckMilliSeconds() != null) {
            realm.setQuickLoginCheckMilliSeconds(rep.getQuickLoginCheckMilliSeconds().longValue());
        }
        if (rep.getMaxDeltaTimeSeconds() != null) {
            realm.setMaxDeltaTimeSeconds(rep.getMaxDeltaTimeSeconds().intValue());
        }
        if (rep.getFailureFactor() != null) {
            realm.setFailureFactor(rep.getFailureFactor().intValue());
        }
        if (rep.isPasswordCredentialGrantAllowed() != null) {
            realm.setPasswordCredentialGrantAllowed(rep.isPasswordCredentialGrantAllowed().booleanValue());
        }
        if (rep.isRegistrationAllowed() != null) {
            realm.setRegistrationAllowed(rep.isRegistrationAllowed().booleanValue());
        }
        if (rep.isRememberMe() != null) {
            realm.setRememberMe(rep.isRememberMe().booleanValue());
        }
        if (rep.isVerifyEmail() != null) {
            realm.setVerifyEmail(rep.isVerifyEmail().booleanValue());
        }
        if (rep.isResetPasswordAllowed() != null) {
            realm.setResetPasswordAllowed(rep.isResetPasswordAllowed().booleanValue());
        }
        if (rep.isUpdateProfileOnInitialSocialLogin() != null) {
            realm.setUpdateProfileOnInitialSocialLogin(rep.isUpdateProfileOnInitialSocialLogin().booleanValue());
        }
        if (rep.isSslNotRequired() != null) {
            realm.setSslNotRequired(rep.isSslNotRequired().booleanValue());
        }
        if (rep.getAccessCodeLifespan() != null) {
            realm.setAccessCodeLifespan(rep.getAccessCodeLifespan().intValue());
        }
        if (rep.getAccessCodeLifespanUserAction() != null) {
            realm.setAccessCodeLifespanUserAction(rep.getAccessCodeLifespanUserAction().intValue());
        }
        if (rep.getNotBefore() != null) {
            realm.setNotBefore(rep.getNotBefore().intValue());
        }
        if (rep.getAccessTokenLifespan() != null) {
            realm.setAccessTokenLifespan(rep.getAccessTokenLifespan().intValue());
        }
        if (rep.getSsoSessionIdleTimeout() != null) {
            realm.setSsoSessionIdleTimeout(rep.getSsoSessionIdleTimeout().intValue());
        }
        if (rep.getSsoSessionMaxLifespan() != null) {
            realm.setSsoSessionMaxLifespan(rep.getSsoSessionMaxLifespan().intValue());
        }
        if (rep.getRequiredCredentials() != null) {
            realm.updateRequiredCredentials(rep.getRequiredCredentials());
        }
        if (rep.getLoginTheme() != null) {
            realm.setLoginTheme(rep.getLoginTheme());
        }
        if (rep.getAccountTheme() != null) {
            realm.setAccountTheme(rep.getAccountTheme());
        }
        if (rep.getAdminTheme() != null) {
            realm.setAdminTheme(rep.getAdminTheme());
        }
        if (rep.getEmailTheme() != null) {
            realm.setEmailTheme(rep.getEmailTheme());
        }
        if (rep.getPasswordPolicy() != null) {
            realm.setPasswordPolicy(new PasswordPolicy(rep.getPasswordPolicy()));
        }
        if (rep.getDefaultRoles() != null) {
            realm.updateDefaultRoles(rep.getDefaultRoles().toArray(new String[rep.getDefaultRoles().size()]));
        }
        if (rep.getSmtpServer() != null) {
            realm.setSmtpConfig(new HashMap(rep.getSmtpServer()));
        }
        if (rep.getSocialProviders() != null) {
            realm.setSocialConfig(new HashMap(rep.getSocialProviders()));
        }
        if (rep.getLdapServer() != null) {
            realm.setLdapServerConfig(new HashMap(rep.getLdapServer()));
        }
        if (rep.getAuthenticationProviders() != null) {
            List<AuthenticationProviderModel> authProviderModels = this.convertAuthenticationProviders(rep.getAuthenticationProviders());
            realm.setAuthenticationProviders(authProviderModels);
        }
        if ("GENERATE".equals(rep.getPublicKey())) {
            this.generateRealmKeys(realm);
        }
    }

    public void updateRealmAudit(RealmAuditRepresentation rep, RealmModel realm) {
        realm.setAuditEnabled(rep.isAuditEnabled());
        realm.setAuditExpiration(rep.getAuditExpiration() != null ? rep.getAuditExpiration() : 0L);
        if (rep.getAuditListeners() != null) {
            realm.setAuditListeners(new HashSet(rep.getAuditListeners()));
        }
    }

    private void setupMasterAdminManagement(RealmModel realm) {
        RoleModel adminRole;
        RealmModel adminRealm;
        if (realm.getName().equals(Config.getAdminRealm())) {
            adminRealm = realm;
            adminRole = realm.addRole(AdminRoles.ADMIN);
            RoleModel createRealmRole = realm.addRole(AdminRoles.CREATE_REALM);
            adminRole.addCompositeRole(createRealmRole);
        } else {
            adminRealm = this.identitySession.getRealmByName(Config.getAdminRealm());
            adminRole = adminRealm.getRole(AdminRoles.ADMIN);
        }
        ApplicationManager applicationManager = new ApplicationManager(new RealmManager(this.identitySession));
        ApplicationModel realmAdminApp = applicationManager.createApplication(adminRealm, this.getMasterRealmAdminApplicationName(realm));
        realmAdminApp.setBearerOnly(true);
        realm.setMasterAdminApp(realmAdminApp);
        for (String r : AdminRoles.ALL_REALM_ROLES) {
            RoleModel role = realmAdminApp.addRole(r);
            adminRole.addCompositeRole(role);
        }
    }

    private void setupRealmAdminManagement(RealmModel realm) {
        if (realm.getName().equals(Config.getAdminRealm())) {
            return;
        }
        ApplicationManager applicationManager = new ApplicationManager(new RealmManager(this.identitySession));
        String realmAdminApplicationName = this.getRealmAdminApplicationName(realm);
        ApplicationModel realmAdminApp = realm.getApplicationByName(realmAdminApplicationName);
        if (realmAdminApp == null) {
            realmAdminApp = applicationManager.createApplication(realm, realmAdminApplicationName);
        }
        RoleModel adminRole = realmAdminApp.addRole(AdminRoles.REALM_ADMIN);
        realmAdminApp.setBearerOnly(true);
        for (String r : AdminRoles.ALL_REALM_ROLES) {
            RoleModel role = realmAdminApp.addRole(r);
            adminRole.addCompositeRole(role);
        }
    }

    private void setupAccountManagement(RealmModel realm) {
        ApplicationModel application = (ApplicationModel)realm.getApplicationNameMap().get("account");
        if (application == null) {
            application = new ApplicationManager(this).createApplication(realm, "account");
            application.setEnabled(true);
            String base = this.contextPath + "/realms/" + realm.getName() + "/account";
            String redirectUri = base + "/*";
            application.addRedirectUri(redirectUri);
            application.setBaseUrl(base);
            for (String role : AccountRoles.ALL) {
                application.addDefaultRole(role);
            }
        }
    }

    public RealmModel importRealm(RealmRepresentation rep) {
        String id = rep.getId();
        if (id == null) {
            id = KeycloakModelUtils.generateId();
        }
        RealmModel realm = this.createRealm(id, rep.getRealm());
        this.importRealm(rep, realm);
        return realm;
    }

    public void importRealm(RealmRepresentation rep, RealmModel newRealm) {
        UserModel user;
        ApplicationModel app;
        RoleModel role;
        Map appMap;
        newRealm.setName(rep.getRealm());
        if (rep.isEnabled() != null) {
            newRealm.setEnabled(rep.isEnabled().booleanValue());
        }
        if (rep.isSocial() != null) {
            newRealm.setSocial(rep.isSocial().booleanValue());
        }
        if (rep.isBruteForceProtected() != null) {
            newRealm.setBruteForceProtected(rep.isBruteForceProtected().booleanValue());
        }
        if (rep.getMaxFailureWaitSeconds() != null) {
            newRealm.setMaxFailureWaitSeconds(rep.getMaxFailureWaitSeconds().intValue());
        }
        if (rep.getMinimumQuickLoginWaitSeconds() != null) {
            newRealm.setMinimumQuickLoginWaitSeconds(rep.getMinimumQuickLoginWaitSeconds().intValue());
        }
        if (rep.getWaitIncrementSeconds() != null) {
            newRealm.setWaitIncrementSeconds(rep.getWaitIncrementSeconds().intValue());
        }
        if (rep.getQuickLoginCheckMilliSeconds() != null) {
            newRealm.setQuickLoginCheckMilliSeconds(rep.getQuickLoginCheckMilliSeconds().longValue());
        }
        if (rep.getMaxDeltaTimeSeconds() != null) {
            newRealm.setMaxDeltaTimeSeconds(rep.getMaxDeltaTimeSeconds().intValue());
        }
        if (rep.getFailureFactor() != null) {
            newRealm.setFailureFactor(rep.getFailureFactor().intValue());
        }
        if (rep.getNotBefore() != null) {
            newRealm.setNotBefore(rep.getNotBefore().intValue());
        }
        if (rep.getAccessTokenLifespan() != null) {
            newRealm.setAccessTokenLifespan(rep.getAccessTokenLifespan().intValue());
        } else {
            newRealm.setAccessTokenLifespan(300);
        }
        if (rep.getSsoSessionIdleTimeout() != null) {
            newRealm.setSsoSessionIdleTimeout(rep.getSsoSessionIdleTimeout().intValue());
        } else {
            newRealm.setSsoSessionIdleTimeout(600);
        }
        if (rep.getSsoSessionMaxLifespan() != null) {
            newRealm.setSsoSessionMaxLifespan(rep.getSsoSessionMaxLifespan().intValue());
        } else {
            newRealm.setSsoSessionMaxLifespan(36000);
        }
        if (rep.getAccessCodeLifespan() != null) {
            newRealm.setAccessCodeLifespan(rep.getAccessCodeLifespan().intValue());
        } else {
            newRealm.setAccessCodeLifespan(60);
        }
        if (rep.getAccessCodeLifespanUserAction() != null) {
            newRealm.setAccessCodeLifespanUserAction(rep.getAccessCodeLifespanUserAction().intValue());
        } else {
            newRealm.setAccessCodeLifespanUserAction(300);
        }
        if (rep.isSslNotRequired() != null) {
            newRealm.setSslNotRequired(rep.isSslNotRequired().booleanValue());
        }
        if (rep.isPasswordCredentialGrantAllowed() != null) {
            newRealm.setPasswordCredentialGrantAllowed(rep.isPasswordCredentialGrantAllowed().booleanValue());
        }
        if (rep.isRegistrationAllowed() != null) {
            newRealm.setRegistrationAllowed(rep.isRegistrationAllowed().booleanValue());
        }
        if (rep.isRememberMe() != null) {
            newRealm.setRememberMe(rep.isRememberMe().booleanValue());
        }
        if (rep.isVerifyEmail() != null) {
            newRealm.setVerifyEmail(rep.isVerifyEmail().booleanValue());
        }
        if (rep.isResetPasswordAllowed() != null) {
            newRealm.setResetPasswordAllowed(rep.isResetPasswordAllowed().booleanValue());
        }
        if (rep.isUpdateProfileOnInitialSocialLogin() != null) {
            newRealm.setUpdateProfileOnInitialSocialLogin(rep.isUpdateProfileOnInitialSocialLogin().booleanValue());
        }
        if (rep.getPrivateKey() == null || rep.getPublicKey() == null) {
            this.generateRealmKeys(newRealm);
        } else {
            newRealm.setPrivateKeyPem(rep.getPrivateKey());
            newRealm.setPublicKeyPem(rep.getPublicKey());
        }
        if (rep.getLoginTheme() != null) {
            newRealm.setLoginTheme(rep.getLoginTheme());
        }
        if (rep.getAccountTheme() != null) {
            newRealm.setAccountTheme(rep.getAccountTheme());
        }
        if (rep.getAdminTheme() != null) {
            newRealm.setAdminTheme(rep.getAdminTheme());
        }
        if (rep.getEmailTheme() != null) {
            newRealm.setEmailTheme(rep.getEmailTheme());
        }
        HashMap<String, UserModel> userMap = new HashMap<String, UserModel>();
        if (rep.getRequiredCredentials() != null) {
            for (String string : rep.getRequiredCredentials()) {
                this.addRequiredCredential(newRealm, string);
            }
        } else {
            this.addRequiredCredential(newRealm, "password");
        }
        if (rep.getPasswordPolicy() != null) {
            newRealm.setPasswordPolicy(new PasswordPolicy(rep.getPasswordPolicy()));
        }
        if (rep.getUsers() != null) {
            for (UserRepresentation userRepresentation : rep.getUsers()) {
                UserModel user2 = this.createUser(newRealm, userRepresentation);
                userMap.put(user2.getLoginName(), user2);
            }
        }
        if (rep.getApplications() != null) {
            appMap = this.createApplications(rep, newRealm);
        }
        if (rep.getRoles() != null) {
            if (rep.getRoles().getRealm() != null) {
                for (RoleRepresentation roleRepresentation : rep.getRoles().getRealm()) {
                    this.createRole(newRealm, roleRepresentation);
                }
            }
            if (rep.getRoles().getApplication() != null) {
                for (Map.Entry entry : rep.getRoles().getApplication().entrySet()) {
                    ApplicationModel app2 = newRealm.getApplicationByName((String)entry.getKey());
                    if (app2 == null) {
                        throw new RuntimeException("App doesn't exist in role definitions: " + (String)entry.getKey());
                    }
                    for (RoleRepresentation roleRep : (List)entry.getValue()) {
                        role = app2.addRole(roleRep.getName());
                        role.setDescription(roleRep.getDescription());
                    }
                }
            }
            if (rep.getRoles().getRealm() != null) {
                for (RoleRepresentation roleRepresentation : rep.getRoles().getRealm()) {
                    RoleModel role2 = newRealm.getRole(roleRepresentation.getName());
                    this.addComposites(role2, roleRepresentation, newRealm);
                }
            }
            if (rep.getRoles().getApplication() != null) {
                for (Map.Entry entry : rep.getRoles().getApplication().entrySet()) {
                    ApplicationModel app2 = newRealm.getApplicationByName((String)entry.getKey());
                    if (app2 == null) {
                        throw new RuntimeException("App doesn't exist in role definitions: " + (String)entry.getKey());
                    }
                    for (RoleRepresentation roleRep : (List)entry.getValue()) {
                        role = app2.getRole(roleRep.getName());
                        this.addComposites(role, roleRep, newRealm);
                    }
                }
            }
        }
        if (rep.getDefaultRoles() != null) {
            for (String string : rep.getDefaultRoles()) {
                newRealm.addDefaultRole(string.trim());
            }
        }
        if (rep.getOauthClients() != null) {
            this.createOAuthClients(rep, newRealm);
        }
        appMap = newRealm.getApplicationNameMap();
        if (rep.getApplicationRoleMappings() != null) {
            ApplicationManager applicationManager = new ApplicationManager(this);
            for (Map.Entry entry : rep.getApplicationRoleMappings().entrySet()) {
                app = (ApplicationModel)appMap.get(entry.getKey());
                if (app == null) {
                    throw new RuntimeException("Unable to find application role mappings for app: " + (String)entry.getKey());
                }
                applicationManager.createRoleMappings(newRealm, app, (List)entry.getValue());
            }
        }
        if (rep.getApplicationScopeMappings() != null) {
            ApplicationManager applicationManager = new ApplicationManager(this);
            for (Map.Entry entry : rep.getApplicationScopeMappings().entrySet()) {
                app = (ApplicationModel)appMap.get(entry.getKey());
                if (app == null) {
                    throw new RuntimeException("Unable to find application role mappings for app: " + (String)entry.getKey());
                }
                applicationManager.createScopeMappings(newRealm, app, (List)entry.getValue());
            }
        }
        if (rep.getRoleMappings() != null) {
            for (UserRoleMappingRepresentation mapping : rep.getRoleMappings()) {
                user = (UserModel)userMap.get(mapping.getUsername());
                for (String roleString : mapping.getRoles()) {
                    RoleModel role3 = newRealm.getRole(roleString.trim());
                    if (role3 == null) {
                        role3 = newRealm.addRole(roleString.trim());
                    }
                    newRealm.grantRole(user, role3);
                }
            }
        }
        if (rep.getScopeMappings() != null) {
            for (ScopeMappingRepresentation scope : rep.getScopeMappings()) {
                for (String roleString : scope.getRoles()) {
                    role = newRealm.getRole(roleString.trim());
                    if (role == null) {
                        role = newRealm.addRole(roleString.trim());
                    }
                    ClientModel client = newRealm.findClient(scope.getClient());
                    newRealm.addScopeMapping(client, role);
                }
            }
        }
        if (rep.getSocialMappings() != null) {
            for (SocialMappingRepresentation socialMapping : rep.getSocialMappings()) {
                user = (UserModel)userMap.get(socialMapping.getUsername());
                for (SocialLinkRepresentation link : socialMapping.getSocialLinks()) {
                    SocialLinkModel mappingModel = new SocialLinkModel(link.getSocialProvider(), link.getSocialUserId(), link.getSocialUsername());
                    newRealm.addSocialLink(user, mappingModel);
                }
            }
        }
        if (rep.getSmtpServer() != null) {
            newRealm.setSmtpConfig(new HashMap(rep.getSmtpServer()));
        }
        if (rep.getSocialProviders() != null) {
            newRealm.setSocialConfig(new HashMap(rep.getSocialProviders()));
        }
        if (rep.getLdapServer() != null) {
            newRealm.setLdapServerConfig(new HashMap(rep.getLdapServer()));
        }
        if (rep.getAuthenticationProviders() != null) {
            List<AuthenticationProviderModel> list = this.convertAuthenticationProviders(rep.getAuthenticationProviders());
            newRealm.setAuthenticationProviders(list);
        } else {
            List<AuthenticationProviderModel> list = Arrays.asList(AuthenticationProviderModel.DEFAULT_PROVIDER);
            newRealm.setAuthenticationProviders(list);
        }
    }

    public void addComposites(RoleModel role, RoleRepresentation roleRep, RealmModel realm) {
        if (roleRep.getComposites() == null) {
            return;
        }
        if (roleRep.getComposites().getRealm() != null) {
            for (String string : roleRep.getComposites().getRealm()) {
                RoleModel realmRole = realm.getRole(string);
                if (realmRole == null) {
                    throw new RuntimeException("Unable to find composite realm role: " + string);
                }
                role.addCompositeRole(realmRole);
            }
        }
        if (roleRep.getComposites().getApplication() != null) {
            for (Map.Entry entry : roleRep.getComposites().getApplication().entrySet()) {
                ApplicationModel app = realm.getApplicationByName((String)entry.getKey());
                if (app == null) {
                    throw new RuntimeException("App doesn't exist in role definitions: " + roleRep.getName());
                }
                for (String roleStr : (List)entry.getValue()) {
                    RoleModel appRole = app.getRole(roleStr);
                    if (appRole == null) {
                        throw new RuntimeException("Unable to find composite app role: " + roleStr);
                    }
                    role.addCompositeRole(appRole);
                }
            }
        }
    }

    public void createRole(RealmModel newRealm, RoleRepresentation roleRep) {
        RoleModel role = newRealm.addRole(roleRep.getName());
        if (roleRep.getDescription() != null) {
            role.setDescription(roleRep.getDescription());
        }
    }

    public void createRole(RealmModel newRealm, ApplicationModel app, RoleRepresentation roleRep) {
        RoleModel role = app.addRole(roleRep.getName());
        if (roleRep.getDescription() != null) {
            role.setDescription(roleRep.getDescription());
        }
    }

    public UserModel createUser(RealmModel newRealm, UserRepresentation userRep) {
        UserModel user = newRealm.addUser(userRep.getUsername());
        user.setEnabled(userRep.isEnabled());
        user.setEmail(userRep.getEmail());
        user.setFirstName(userRep.getFirstName());
        user.setLastName(userRep.getLastName());
        if (userRep.getAttributes() != null) {
            for (Map.Entry entry : userRep.getAttributes().entrySet()) {
                user.setAttribute((String)entry.getKey(), (String)entry.getValue());
            }
        }
        if (userRep.getRequiredActions() != null) {
            for (String requiredAction : userRep.getRequiredActions()) {
                user.addRequiredAction(UserModel.RequiredAction.valueOf((String)requiredAction));
            }
        }
        if (userRep.getCredentials() != null) {
            for (CredentialRepresentation cred : userRep.getCredentials()) {
                UserCredentialModel credential = RealmManager.fromRepresentation(cred);
                newRealm.updateCredential(user, credential);
            }
        }
        if (userRep.getAuthenticationLink() != null) {
            AuthenticationLinkRepresentation link = userRep.getAuthenticationLink();
            AuthenticationLinkModel authLink = new AuthenticationLinkModel(link.getAuthProvider(), link.getAuthUserId());
            newRealm.setAuthenticationLink(user, authLink);
        }
        return user;
    }

    public static UserCredentialModel fromRepresentation(CredentialRepresentation cred) {
        UserCredentialModel credential = new UserCredentialModel();
        credential.setType(cred.getType());
        credential.setValue(cred.getValue());
        return credential;
    }

    public List<UserModel> searchUsers(String searchString, RealmModel realmModel) {
        if (searchString == null) {
            return Collections.emptyList();
        }
        return realmModel.searchForUser(searchString.trim());
    }

    public void addRequiredCredential(RealmModel newRealm, String requiredCred) {
        newRealm.addRequiredCredential(requiredCred);
    }

    protected Map<String, ApplicationModel> createApplications(RealmRepresentation rep, RealmModel realm) {
        HashMap<String, ApplicationModel> appMap = new HashMap<String, ApplicationModel>();
        ApplicationManager manager = new ApplicationManager(this);
        for (ApplicationRepresentation resourceRep : rep.getApplications()) {
            ApplicationModel app = manager.createApplication(realm, resourceRep);
            appMap.put(app.getName(), app);
        }
        return appMap;
    }

    protected void createOAuthClients(RealmRepresentation realmRep, RealmModel realm) {
        OAuthClientManager manager = new OAuthClientManager(realm);
        for (OAuthClientRepresentation rep : realmRep.getOauthClients()) {
            OAuthClientModel app = manager.create(rep);
        }
    }

    protected List<AuthenticationProviderModel> convertAuthenticationProviders(List<AuthenticationProviderRepresentation> authenticationProviders) {
        ArrayList<AuthenticationProviderModel> result = new ArrayList<AuthenticationProviderModel>();
        for (AuthenticationProviderRepresentation representation : authenticationProviders) {
            AuthenticationProviderModel model = new AuthenticationProviderModel(representation.getProviderName(), representation.isPasswordUpdateSupported(), representation.getConfig());
            result.add(model);
        }
        return result;
    }
}

