/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.services.resources.admin;

import org.keycloak.models.ApplicationModel;
import org.keycloak.models.ClientModel;
import org.keycloak.models.RealmModel;
import org.keycloak.models.RoleModel;
import org.keycloak.models.UserModel;
import org.keycloak.representations.AccessToken;

public class AdminAuth {
    private final RealmModel realm;
    private final AccessToken token;
    private final UserModel user;
    private final ClientModel client;

    public AdminAuth(RealmModel realm, AccessToken token, UserModel user, ClientModel client) {
        this.token = token;
        this.realm = realm;
        this.user = user;
        this.client = client;
    }

    public RealmModel getRealm() {
        return this.realm;
    }

    public UserModel getUser() {
        return this.user;
    }

    public ClientModel getClient() {
        return this.client;
    }

    public AccessToken getToken() {
        return this.token;
    }

    public boolean hasRealmRole(String role) {
        if (this.client instanceof ApplicationModel) {
            RoleModel roleModel = this.realm.getRole(role);
            return this.realm.hasRole(this.user, roleModel) && this.realm.hasScope(this.client, roleModel);
        }
        AccessToken.Access access = this.token.getRealmAccess();
        return access != null && access.isUserInRole(role);
    }

    public boolean hasOneOfRealmRole(String ... roles) {
        for (String r : roles) {
            if (!this.hasRealmRole(r)) continue;
            return true;
        }
        return false;
    }

    public boolean hasAppRole(ApplicationModel app, String role) {
        if (this.client instanceof ApplicationModel) {
            RoleModel roleModel = app.getRole(role);
            return this.realm.hasRole(this.user, roleModel) && this.realm.hasScope(this.client, roleModel);
        }
        AccessToken.Access access = this.token.getResourceAccess(app.getName());
        return access != null && access.isUserInRole(role);
    }

    public boolean hasOneOfAppRole(ApplicationModel app, String ... roles) {
        for (String r : roles) {
            if (!this.hasAppRole(app, r)) continue;
            return true;
        }
        return false;
    }
}

