/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.services.resources.admin;

import java.io.IOException;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriInfo;
import org.jboss.logging.Logger;
import org.jboss.resteasy.annotations.cache.NoCache;
import org.jboss.resteasy.spi.NotFoundException;
import org.keycloak.models.ClientModel;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.ModelDuplicateException;
import org.keycloak.models.OAuthClientModel;
import org.keycloak.models.RealmModel;
import org.keycloak.models.UserCredentialModel;
import org.keycloak.representations.idm.CredentialRepresentation;
import org.keycloak.representations.idm.OAuthClientRepresentation;
import org.keycloak.services.managers.ModelToRepresentation;
import org.keycloak.services.managers.OAuthClientManager;
import org.keycloak.services.resources.KeycloakApplication;
import org.keycloak.services.resources.admin.ClaimResource;
import org.keycloak.services.resources.admin.RealmAdminResource;
import org.keycloak.services.resources.admin.RealmAuth;
import org.keycloak.services.resources.admin.ScopeMappedResource;
import org.keycloak.services.resources.flows.Flows;
import org.keycloak.util.JsonSerialization;

public class OAuthClientResource {
    protected static final Logger logger = Logger.getLogger(RealmAdminResource.class);
    protected RealmModel realm;
    private RealmAuth auth;
    protected OAuthClientModel oauthClient;
    protected KeycloakSession session;
    @Context
    protected UriInfo uriInfo;
    @Context
    protected KeycloakApplication application;

    protected KeycloakApplication getApplication() {
        return this.application;
    }

    public OAuthClientResource(RealmModel realm, RealmAuth auth, OAuthClientModel oauthClient, KeycloakSession session) {
        this.realm = realm;
        this.auth = auth;
        this.oauthClient = oauthClient;
        this.session = session;
        auth.init(RealmAuth.Resource.CLIENT);
    }

    @Path(value="claims")
    public ClaimResource getClaimResource() {
        return new ClaimResource((ClientModel)this.oauthClient, this.auth);
    }

    @PUT
    @Consumes(value={"application/json"})
    public Response update(OAuthClientRepresentation rep) {
        this.auth.requireManage();
        OAuthClientManager manager = new OAuthClientManager(this.realm);
        try {
            manager.update(rep, this.oauthClient);
            return Response.noContent().build();
        }
        catch (ModelDuplicateException e) {
            return Flows.errors().exists("Client " + rep.getName() + " already exists");
        }
    }

    @GET
    @NoCache
    @Produces(value={"application/json"})
    public OAuthClientRepresentation getOAuthClient() {
        this.auth.requireView();
        return OAuthClientManager.toRepresentation(this.oauthClient);
    }

    @GET
    @NoCache
    @Path(value="installation")
    @Produces(value={"application/json"})
    public String getInstallation() throws IOException {
        this.auth.requireView();
        OAuthClientManager manager = new OAuthClientManager(this.realm);
        OAuthClientManager.InstallationAdapterConfig rep = manager.toInstallationRepresentation(this.realm, this.oauthClient, this.getApplication().getBaseUri(this.uriInfo));
        return JsonSerialization.mapper.writerWithDefaultPrettyPrinter().writeValueAsString((Object)rep);
    }

    @DELETE
    @NoCache
    public void deleteOAuthClient() {
        this.auth.requireManage();
        this.realm.removeOAuthClient(this.oauthClient.getId());
    }

    @Path(value="client-secret")
    @POST
    @Produces(value={"application/json"})
    @Consumes(value={"application/json"})
    public CredentialRepresentation regenerateSecret() {
        this.auth.requireManage();
        logger.debug((Object)"regenerateSecret");
        UserCredentialModel cred = UserCredentialModel.generateSecret();
        this.oauthClient.setSecret(cred.getValue());
        CredentialRepresentation rep = ModelToRepresentation.toRepresentation(cred);
        return rep;
    }

    @Path(value="client-secret")
    @GET
    @Produces(value={"application/json"})
    public CredentialRepresentation getClientSecret() {
        this.auth.requireView();
        logger.debug((Object)"getClientSecret");
        UserCredentialModel model = UserCredentialModel.secret((String)this.oauthClient.getSecret());
        if (model == null) {
            throw new NotFoundException("Application does not have a secret");
        }
        return ModelToRepresentation.toRepresentation(model);
    }

    @Path(value="scope-mappings")
    public ScopeMappedResource getScopeMappedResource() {
        return new ScopeMappedResource(this.realm, this.auth, (ClientModel)this.oauthClient, this.session);
    }
}

