/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.services.managers;

import java.net.URI;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.codehaus.jackson.annotate.JsonProperty;
import org.codehaus.jackson.annotate.JsonPropertyOrder;
import org.jboss.logging.Logger;
import org.keycloak.models.ApplicationModel;
import org.keycloak.models.ClientModel;
import org.keycloak.models.RealmModel;
import org.keycloak.models.RoleModel;
import org.keycloak.models.UserCredentialModel;
import org.keycloak.models.UserModel;
import org.keycloak.representations.adapters.config.BaseRealmConfig;
import org.keycloak.representations.idm.ApplicationRepresentation;
import org.keycloak.representations.idm.ScopeMappingRepresentation;
import org.keycloak.representations.idm.UserRoleMappingRepresentation;
import org.keycloak.services.managers.ClaimManager;
import org.keycloak.services.managers.RealmManager;

public class ApplicationManager {
    protected Logger logger = Logger.getLogger(ApplicationManager.class);
    protected RealmManager realmManager;

    public ApplicationManager(RealmManager realmManager) {
        this.realmManager = realmManager;
    }

    public ApplicationManager() {
    }

    public ApplicationModel createApplication(RealmModel realm, ApplicationRepresentation resourceRep) {
        this.logger.debug((Object)("************ CREATE APPLICATION: {0}" + resourceRep.getName()));
        ApplicationModel applicationModel = realm.addApplication(resourceRep.getName());
        if (resourceRep.isEnabled() != null) {
            applicationModel.setEnabled(resourceRep.isEnabled().booleanValue());
        }
        applicationModel.setManagementUrl(resourceRep.getAdminUrl());
        if (resourceRep.isSurrogateAuthRequired() != null) {
            applicationModel.setSurrogateAuthRequired(resourceRep.isSurrogateAuthRequired().booleanValue());
        }
        applicationModel.setBaseUrl(resourceRep.getBaseUrl());
        if (resourceRep.isBearerOnly() != null) {
            applicationModel.setBearerOnly(resourceRep.isBearerOnly().booleanValue());
        }
        if (resourceRep.isPublicClient() != null) {
            applicationModel.setPublicClient(resourceRep.isPublicClient().booleanValue());
        }
        applicationModel.updateApplication();
        if (resourceRep.getNotBefore() != null) {
            applicationModel.setNotBefore(resourceRep.getNotBefore().intValue());
        }
        applicationModel.setSecret(resourceRep.getSecret());
        if (applicationModel.getSecret() == null) {
            this.generateSecret(applicationModel);
        }
        if (resourceRep.getRedirectUris() != null) {
            for (String redirectUri : resourceRep.getRedirectUris()) {
                applicationModel.addRedirectUri(redirectUri);
            }
        }
        if (resourceRep.getWebOrigins() != null) {
            for (String webOrigin : resourceRep.getWebOrigins()) {
                this.logger.debugv("Application: {0} webOrigin: {1}", (Object)resourceRep.getName(), (Object)webOrigin);
                applicationModel.addWebOrigin(webOrigin);
            }
        } else if (resourceRep.getRedirectUris() != null) {
            HashSet<String> origins = new HashSet<String>();
            for (String redirectUri : resourceRep.getRedirectUris()) {
                this.logger.info((Object)("add redirectUri to origin: " + redirectUri));
                if (!redirectUri.startsWith("http:")) continue;
                URI uri = URI.create(redirectUri);
                String origin = uri.getScheme() + "://" + uri.getHost();
                if (uri.getPort() != -1) {
                    origin = origin + ":" + uri.getPort();
                }
                this.logger.debugv("adding default application origin: {0}", (Object)origin);
                origins.add(origin);
            }
            if (origins.size() > 0) {
                applicationModel.setWebOrigins(origins);
            }
        }
        if (resourceRep.getDefaultRoles() != null) {
            applicationModel.updateDefaultRoles(resourceRep.getDefaultRoles());
        }
        if (resourceRep.getClaims() != null) {
            ClaimManager.setClaims((ClientModel)applicationModel, resourceRep.getClaims());
        } else {
            applicationModel.setAllowedClaimsMask(2L);
        }
        return applicationModel;
    }

    public void createRoleMappings(RealmModel realm, ApplicationModel applicationModel, List<UserRoleMappingRepresentation> mappings) {
        for (UserRoleMappingRepresentation mapping : mappings) {
            UserModel user = realm.getUser(mapping.getUsername());
            if (user == null) {
                throw new RuntimeException("User not found");
            }
            for (String roleString : mapping.getRoles()) {
                RoleModel role = applicationModel.getRole(roleString.trim());
                if (role == null) {
                    role = applicationModel.addRole(roleString.trim());
                }
                user.grantRole(role);
            }
        }
    }

    public void createScopeMappings(RealmModel realm, ApplicationModel applicationModel, List<ScopeMappingRepresentation> mappings) {
        for (ScopeMappingRepresentation mapping : mappings) {
            for (String roleString : mapping.getRoles()) {
                RoleModel role = applicationModel.getRole(roleString.trim());
                if (role == null) {
                    role = applicationModel.addRole(roleString.trim());
                }
                ClientModel client = realm.findClient(mapping.getClient());
                client.addScopeMapping(role);
            }
        }
    }

    public ApplicationModel createApplication(RealmModel realm, String name) {
        ApplicationModel app = realm.addApplication(name);
        this.generateSecret(app);
        return app;
    }

    public UserCredentialModel generateSecret(ApplicationModel app) {
        UserCredentialModel secret = UserCredentialModel.generateSecret();
        app.setSecret(secret.getValue());
        return secret;
    }

    public void updateApplication(ApplicationRepresentation rep, ApplicationModel resource) {
        List webOrigins;
        List redirectUris;
        if (rep.getName() != null) {
            resource.setName(rep.getName());
        }
        if (rep.isEnabled() != null) {
            resource.setEnabled(rep.isEnabled().booleanValue());
        }
        if (rep.isBearerOnly() != null) {
            resource.setBearerOnly(rep.isBearerOnly().booleanValue());
        }
        if (rep.isPublicClient() != null) {
            resource.setPublicClient(rep.isPublicClient().booleanValue());
        }
        if (rep.getAdminUrl() != null) {
            resource.setManagementUrl(rep.getAdminUrl());
        }
        if (rep.getBaseUrl() != null) {
            resource.setBaseUrl(rep.getBaseUrl());
        }
        if (rep.isSurrogateAuthRequired() != null) {
            resource.setSurrogateAuthRequired(rep.isSurrogateAuthRequired().booleanValue());
        }
        resource.updateApplication();
        if (rep.getNotBefore() != null) {
            resource.setNotBefore(rep.getNotBefore().intValue());
        }
        if (rep.getDefaultRoles() != null) {
            resource.updateDefaultRoles(rep.getDefaultRoles());
        }
        if ((redirectUris = rep.getRedirectUris()) != null) {
            resource.setRedirectUris(new HashSet(redirectUris));
        }
        if ((webOrigins = rep.getWebOrigins()) != null) {
            resource.setWebOrigins(new HashSet(webOrigins));
        }
        if (rep.getClaims() != null) {
            ClaimManager.setClaims((ClientModel)resource, rep.getClaims());
        }
    }

    public ApplicationRepresentation toRepresentation(ApplicationModel applicationModel) {
        Set webOrigins;
        ApplicationRepresentation rep = new ApplicationRepresentation();
        rep.setId(applicationModel.getId());
        rep.setName(applicationModel.getName());
        rep.setEnabled(Boolean.valueOf(applicationModel.isEnabled()));
        rep.setAdminUrl(applicationModel.getManagementUrl());
        rep.setPublicClient(Boolean.valueOf(applicationModel.isPublicClient()));
        rep.setBearerOnly(Boolean.valueOf(applicationModel.isBearerOnly()));
        rep.setSurrogateAuthRequired(Boolean.valueOf(applicationModel.isSurrogateAuthRequired()));
        rep.setBaseUrl(applicationModel.getBaseUrl());
        rep.setNotBefore(Integer.valueOf(applicationModel.getNotBefore()));
        Set redirectUris = applicationModel.getRedirectUris();
        if (redirectUris != null) {
            rep.setRedirectUris(new LinkedList(redirectUris));
        }
        if ((webOrigins = applicationModel.getWebOrigins()) != null) {
            rep.setWebOrigins(new LinkedList(webOrigins));
        }
        if (!applicationModel.getDefaultRoles().isEmpty()) {
            rep.setDefaultRoles(applicationModel.getDefaultRoles().toArray(new String[0]));
        }
        return rep;
    }

    public InstallationAdapterConfig toInstallationRepresentation(RealmModel realmModel, ApplicationModel applicationModel, URI baseUri) {
        InstallationAdapterConfig rep = new InstallationAdapterConfig();
        rep.setRealm(realmModel.getName());
        rep.setRealmKey(realmModel.getPublicKeyPem());
        rep.setSslNotRequired(realmModel.isSslNotRequired());
        if (applicationModel.isPublicClient() && !applicationModel.isBearerOnly()) {
            rep.setPublicClient(true);
        }
        if (applicationModel.isBearerOnly()) {
            rep.setBearerOnly(true);
        }
        if (!applicationModel.isBearerOnly()) {
            rep.setAuthServerUrl(baseUri.toString());
        }
        if (applicationModel.getRoles().size() > 0) {
            rep.setUseResourceRoleMappings(true);
        }
        rep.setResource(applicationModel.getName());
        if (!applicationModel.isBearerOnly() && !applicationModel.isPublicClient()) {
            HashMap<String, String> creds = new HashMap<String, String>();
            String cred = applicationModel.getSecret();
            creds.put("secret", cred);
            rep.setCredentials(creds);
        }
        return rep;
    }

    public String toJBossSubsystemConfig(RealmModel realmModel, ApplicationModel applicationModel, URI baseUri) {
        StringBuffer buffer = new StringBuffer();
        buffer.append("<secure-deployment name=\"WAR MODULE NAME.war\">\n");
        buffer.append("    <realm>").append(realmModel.getName()).append("</realm>\n");
        buffer.append("    <realm-public-key>").append(realmModel.getPublicKeyPem()).append("</realm-public-key>\n");
        if (applicationModel.isBearerOnly()) {
            buffer.append("    <bearer-only>true</bearer-only>\n");
        } else {
            buffer.append("    <auth-server-url>").append(baseUri.toString()).append("</auth-server-url>\n");
            if (applicationModel.isPublicClient() && !applicationModel.isBearerOnly()) {
                buffer.append("    <public-client>true</public-client>\n");
            }
        }
        buffer.append("    <ssl-not-required>").append(realmModel.isSslNotRequired()).append("</ssl-not-required>\n");
        buffer.append("    <resource>").append(applicationModel.getName()).append("</resource>\n");
        String cred = applicationModel.getSecret();
        if (!applicationModel.isBearerOnly() && !applicationModel.isPublicClient()) {
            buffer.append("    <credential name=\"secret\">").append(cred).append("</credential>\n");
        }
        buffer.append("</secure-deployment>\n");
        return buffer.toString();
    }

    @JsonPropertyOrder(value={"realm", "realm-public-key", "bearer-only", "auth-server-url", "ssl-not-required", "resource", "public-client", "credentials", "use-resource-role-mappings"})
    public static class InstallationAdapterConfig
    extends BaseRealmConfig {
        @JsonProperty(value="resource")
        protected String resource;
        @JsonProperty(value="use-resource-role-mappings")
        protected Boolean useResourceRoleMappings;
        @JsonProperty(value="bearer-only")
        protected Boolean bearerOnly;
        @JsonProperty(value="public-client")
        protected Boolean publicClient;
        @JsonProperty(value="credentials")
        protected Map<String, String> credentials;

        public Boolean isUseResourceRoleMappings() {
            return this.useResourceRoleMappings;
        }

        public void setUseResourceRoleMappings(Boolean useResourceRoleMappings) {
            this.useResourceRoleMappings = useResourceRoleMappings;
        }

        public String getResource() {
            return this.resource;
        }

        public void setResource(String resource) {
            this.resource = resource;
        }

        public Map<String, String> getCredentials() {
            return this.credentials;
        }

        public void setCredentials(Map<String, String> credentials) {
            this.credentials = credentials;
        }

        public Boolean getPublicClient() {
            return this.publicClient;
        }

        public void setPublicClient(Boolean publicClient) {
            this.publicClient = publicClient;
        }

        public Boolean getBearerOnly() {
            return this.bearerOnly;
        }

        public void setBearerOnly(Boolean bearerOnly) {
            this.bearerOnly = bearerOnly;
        }
    }
}

