/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.services.resources;

import java.io.IOException;
import java.net.URISyntaxException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Cookie;
import javax.ws.rs.core.HttpHeaders;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriBuilder;
import javax.ws.rs.core.UriInfo;
import org.jboss.logging.Logger;
import org.jboss.resteasy.specimpl.MultivaluedMapImpl;
import org.jboss.resteasy.spi.HttpRequest;
import org.keycloak.ClientConnection;
import org.keycloak.audit.Audit;
import org.keycloak.audit.EventType;
import org.keycloak.jose.jws.JWSInput;
import org.keycloak.models.ClientModel;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.RealmModel;
import org.keycloak.models.SocialLinkModel;
import org.keycloak.models.UserModel;
import org.keycloak.models.UserSessionModel;
import org.keycloak.models.utils.KeycloakModelUtils;
import org.keycloak.services.managers.AuditManager;
import org.keycloak.services.managers.AuthenticationManager;
import org.keycloak.services.managers.RealmManager;
import org.keycloak.services.managers.TokenManager;
import org.keycloak.services.resources.TokenService;
import org.keycloak.services.resources.flows.Flows;
import org.keycloak.services.resources.flows.OAuthFlows;
import org.keycloak.services.resources.flows.Urls;
import org.keycloak.social.AuthCallback;
import org.keycloak.social.SocialAccessDeniedException;
import org.keycloak.social.SocialLoader;
import org.keycloak.social.SocialProvider;
import org.keycloak.social.SocialProviderConfig;
import org.keycloak.social.SocialProviderException;
import org.keycloak.social.SocialUser;

@Path(value="/social")
public class SocialResource {
    protected static Logger logger = Logger.getLogger(SocialResource.class);
    @Context
    protected UriInfo uriInfo;
    @Context
    protected HttpHeaders headers;
    @Context
    private HttpRequest request;
    @Context
    protected KeycloakSession session;
    @Context
    protected ClientConnection clientConnection;
    private TokenManager tokenManager;

    public SocialResource(TokenManager tokenManager) {
        this.tokenManager = tokenManager;
    }

    @GET
    @Path(value="callback")
    public Response callback(@QueryParam(value="state") String encodedState) throws URISyntaxException, IOException {
        SocialUser socialUser;
        State initialRequest;
        try {
            initialRequest = (State)new JWSInput(encodedState).readJsonContent(State.class);
        }
        catch (Throwable t) {
            logger.warn((Object)"Invalid social callback", t);
            return Flows.forms(this.session, null, null, this.uriInfo).setError("Unexpected callback").createErrorPage();
        }
        SocialProvider provider = SocialLoader.load((String)initialRequest.getProvider());
        String realmName = initialRequest.getRealm();
        String authMethod = "social@" + provider.getId();
        RealmManager realmManager = new RealmManager(this.session);
        RealmModel realm = realmManager.getRealmByName(realmName);
        Audit audit = new AuditManager(realm, this.session, this.clientConnection).createAudit().event(EventType.LOGIN).detail("response_type", initialRequest.get("response_type")).detail("auth_method", authMethod);
        AuthenticationManager authManager = new AuthenticationManager();
        OAuthFlows oauth = Flows.oauth(this.session, realm, this.request, this.uriInfo, this.clientConnection, authManager, this.tokenManager);
        if (!realm.isEnabled()) {
            audit.error("realm_disabled");
            return oauth.forwardToSecurityFailure("Realm not enabled.");
        }
        String clientId = initialRequest.get("client_id");
        String redirectUri = initialRequest.get("redirect_uri");
        String scope = initialRequest.get("scope");
        String state = initialRequest.get("state");
        String responseType = initialRequest.get("response_type");
        audit.client(clientId).detail("redirect_uri", redirectUri);
        ClientModel client = realm.findClient(clientId);
        if (client == null) {
            audit.error("client_not_found");
            return oauth.forwardToSecurityFailure("Unknown login requester.");
        }
        if (!client.isEnabled()) {
            audit.error("client_disabled");
            return oauth.forwardToSecurityFailure("Login requester not enabled.");
        }
        String key = (String)realm.getSocialConfig().get(provider.getId() + ".key");
        String secret = (String)realm.getSocialConfig().get(provider.getId() + ".secret");
        String callbackUri = Urls.socialCallback(this.uriInfo.getBaseUri()).toString();
        SocialProviderConfig config = new SocialProviderConfig(key, secret, callbackUri);
        Map<String, String[]> queryParams = this.getQueryParams();
        Map<String, String> attributes = this.getAttributes();
        AuthCallback callback = new AuthCallback(queryParams, attributes);
        try {
            socialUser = provider.processCallback(config, callback);
        }
        catch (SocialAccessDeniedException e) {
            MultivaluedMapImpl queryParms = new MultivaluedMapImpl();
            queryParms.putSingle((Object)"client_id", (Object)clientId);
            queryParms.putSingle((Object)"state", (Object)state);
            queryParms.putSingle((Object)"scope", (Object)scope);
            queryParms.putSingle((Object)"redirect_uri", (Object)redirectUri);
            queryParms.putSingle((Object)"response_type", (Object)responseType);
            audit.error("rejected_by_user");
            return Flows.forms(this.session, realm, client, this.uriInfo).setQueryParams((MultivaluedMap)queryParms).setWarning("Access denied").createLogin();
        }
        catch (SocialProviderException e) {
            logger.error((Object)"Failed to process social callback", (Throwable)e);
            return oauth.forwardToSecurityFailure("Failed to process social callback");
        }
        audit.detail("username", socialUser.getId() + "@" + provider.getId());
        SocialLinkModel socialLink = new SocialLinkModel(provider.getId(), socialUser.getId(), socialUser.getUsername());
        UserModel user = this.session.users().getUserBySocialLink(socialLink, realm);
        String userId = initialRequest.getUser();
        if (userId != null) {
            UserModel authenticatedUser = this.session.users().getUserById(userId, realm);
            audit.event(EventType.SOCIAL_LINK).user(userId);
            if (user != null) {
                audit.error("social_id_in_use");
                return oauth.forwardToSecurityFailure("This social account is already linked to other user");
            }
            if (!authenticatedUser.isEnabled()) {
                audit.error("user_disabled");
                return oauth.forwardToSecurityFailure("User is disabled");
            }
            if (!authenticatedUser.hasRole(realm.getApplicationByName("account").getRole("manage-account"))) {
                audit.error("not_allowed");
                return oauth.forwardToSecurityFailure("Insufficient permissions to link social account");
            }
            if (redirectUri == null) {
                audit.error("invalid_redirect_uri");
                return oauth.forwardToSecurityFailure("Unknown redirectUri");
            }
            this.session.users().addSocialLink(realm, authenticatedUser, socialLink);
            logger.debug((Object)("Social provider " + provider.getId() + " linked with user " + authenticatedUser.getUsername()));
            audit.success();
            return Response.status((int)302).location(UriBuilder.fromUri((String)redirectUri).build(new Object[0])).build();
        }
        if (user == null) {
            if (!realm.isRegistrationAllowed()) {
                audit.error("registration_disabled");
                return oauth.forwardToSecurityFailure("Registration not allowed");
            }
            user = this.session.users().addUser(realm, KeycloakModelUtils.generateId());
            user.setEnabled(true);
            user.setFirstName(socialUser.getFirstName());
            user.setLastName(socialUser.getLastName());
            user.setEmail(socialUser.getEmail());
            if (realm.isUpdateProfileOnInitialSocialLogin()) {
                user.addRequiredAction(UserModel.RequiredAction.UPDATE_PROFILE);
            }
            this.session.users().addSocialLink(realm, user, socialLink);
            audit.clone().user(user).event(EventType.REGISTER).detail("register_method", "social@" + provider.getId()).detail("email", socialUser.getEmail()).removeDetail("auth_method").success();
        }
        audit.user(user);
        if (!user.isEnabled()) {
            audit.error("user_disabled");
            return oauth.forwardToSecurityFailure("Your account is not enabled.");
        }
        String username = socialLink.getSocialUserId() + "@" + socialLink.getSocialProvider();
        UserSessionModel userSession = this.session.sessions().createUserSession(realm, user, username, this.clientConnection.getRemoteAddr(), authMethod, false);
        audit.session(userSession);
        return oauth.processAccessCode(scope, state, redirectUri, client, user, userSession, audit);
    }

    @GET
    @Path(value="{realm}/login")
    public Response redirectToProviderAuth(@PathParam(value="realm") String realmName, @QueryParam(value="provider_id") String providerId, @QueryParam(value="client_id") String clientId, @QueryParam(value="scope") String scope, @QueryParam(value="state") String state, @QueryParam(value="redirect_uri") String redirectUri, @QueryParam(value="response_type") String responseType) {
        RealmManager realmManager = new RealmManager(this.session);
        RealmModel realm = realmManager.getRealmByName(realmName);
        Audit audit = new AuditManager(realm, this.session, this.clientConnection).createAudit().event(EventType.LOGIN).client(clientId).detail("redirect_uri", redirectUri).detail("response_type", "code").detail("auth_method", "social@" + providerId);
        SocialProvider provider = SocialLoader.load((String)providerId);
        if (provider == null) {
            audit.error("social_provider_not_found");
            return Flows.forms(this.session, realm, null, this.uriInfo).setError("Social provider not found").createErrorPage();
        }
        ClientModel client = realm.findClient(clientId);
        if (client == null) {
            audit.error("client_not_found");
            logger.warn((Object)("Unknown login requester: " + clientId));
            return Flows.forms(this.session, realm, null, this.uriInfo).setError("Unknown login requester.").createErrorPage();
        }
        if (!client.isEnabled()) {
            audit.error("client_disabled");
            logger.warn((Object)"Login requester not enabled.");
            return Flows.forms(this.session, realm, null, this.uriInfo).setError("Login requester not enabled.").createErrorPage();
        }
        if ((redirectUri = TokenService.verifyRedirectUri(this.uriInfo, redirectUri, realm, client)) == null) {
            audit.error("invalid_redirect_uri");
            return Flows.forms(this.session, realm, null, this.uriInfo).setError("Invalid redirect_uri.").createErrorPage();
        }
        try {
            return Flows.social(realm, this.uriInfo, this.clientConnection, provider).putClientAttribute("client_id", clientId).putClientAttribute("scope", scope).putClientAttribute("state", state).putClientAttribute("redirect_uri", redirectUri).putClientAttribute("response_type", responseType).redirectToSocialProvider();
        }
        catch (Throwable t) {
            logger.error((Object)"Failed to redirect to social auth", t);
            return Flows.forms(this.session, realm, null, this.uriInfo).setError("Failed to redirect to social auth").createErrorPage();
        }
    }

    private Map<String, String[]> getQueryParams() {
        HashMap<String, String[]> queryParams = new HashMap<String, String[]>();
        for (Map.Entry e : this.uriInfo.getQueryParameters().entrySet()) {
            queryParams.put((String)e.getKey(), ((List)e.getValue()).toArray(new String[((List)e.getValue()).size()]));
        }
        return queryParams;
    }

    private Map<String, String> getAttributes() throws IOException {
        Cookie cookie = (Cookie)this.headers.getCookies().get("KEYCLOAK_SOCIAL");
        return cookie != null ? (HashMap)new JWSInput(cookie.getValue()).readJsonContent(HashMap.class) : null;
    }

    public static class State {
        private String realm;
        private String provider;
        private String user;
        private Map<String, String> attributes = new HashMap<String, String>();

        public String getRealm() {
            return this.realm;
        }

        public void setRealm(String realm) {
            this.realm = realm;
        }

        public String getProvider() {
            return this.provider;
        }

        public void setProvider(String provider) {
            this.provider = provider;
        }

        public String getUser() {
            return this.user;
        }

        public void setUser(String user) {
            this.user = user;
        }

        public Map<String, String> getAttributes() {
            return this.attributes;
        }

        public String get(String key) {
            return this.attributes.get(key);
        }

        public void set(String key, String value) {
            this.attributes.put(key, value);
        }
    }
}

