/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.services.resources;

import java.net.URI;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.UUID;
import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.OPTIONS;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.HttpHeaders;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriBuilder;
import javax.ws.rs.core.UriInfo;
import javax.ws.rs.core.Variant;
import org.jboss.logging.Logger;
import org.jboss.resteasy.spi.BadRequestException;
import org.jboss.resteasy.spi.HttpRequest;
import org.keycloak.ClientConnection;
import org.keycloak.account.AccountPages;
import org.keycloak.account.AccountProvider;
import org.keycloak.audit.Audit;
import org.keycloak.audit.AuditProvider;
import org.keycloak.audit.Event;
import org.keycloak.audit.EventType;
import org.keycloak.models.ApplicationModel;
import org.keycloak.models.ClientModel;
import org.keycloak.models.ClientSessionModel;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.OAuthClientModel;
import org.keycloak.models.RealmModel;
import org.keycloak.models.SocialLinkModel;
import org.keycloak.models.UserCredentialModel;
import org.keycloak.models.UserModel;
import org.keycloak.models.UserSessionModel;
import org.keycloak.models.utils.ModelToRepresentation;
import org.keycloak.models.utils.TimeBasedOTP;
import org.keycloak.representations.idm.UserRepresentation;
import org.keycloak.services.ForbiddenException;
import org.keycloak.services.managers.AppAuthManager;
import org.keycloak.services.managers.Auth;
import org.keycloak.services.managers.AuthenticationManager;
import org.keycloak.services.resources.Cors;
import org.keycloak.services.resources.RealmsResource;
import org.keycloak.services.resources.TokenService;
import org.keycloak.services.resources.flows.Flows;
import org.keycloak.services.resources.flows.OAuthRedirect;
import org.keycloak.services.resources.flows.Urls;
import org.keycloak.services.util.ResolveRelative;
import org.keycloak.services.validation.Validation;
import org.keycloak.social.SocialLoader;
import org.keycloak.social.SocialProvider;
import org.keycloak.social.SocialProviderException;

public class AccountService {
    private static final Logger logger = Logger.getLogger(AccountService.class);
    private static final EventType[] AUDIT_EVENTS = new EventType[]{EventType.LOGIN, EventType.LOGOUT, EventType.REGISTER, EventType.REMOVE_SOCIAL_LINK, EventType.REMOVE_TOTP, EventType.SEND_RESET_PASSWORD, EventType.SEND_VERIFY_EMAIL, EventType.SOCIAL_LINK, EventType.UPDATE_EMAIL, EventType.UPDATE_PASSWORD, EventType.UPDATE_PROFILE, EventType.UPDATE_TOTP, EventType.VERIFY_EMAIL};
    private static final Set<String> AUDIT_DETAILS = new HashSet<String>();
    private RealmModel realm;
    @Context
    private HttpRequest request;
    @Context
    protected HttpHeaders headers;
    @Context
    private UriInfo uriInfo;
    @Context
    private ClientConnection clientConnection;
    @Context
    private KeycloakSession session;
    private final AppAuthManager authManager;
    private final ApplicationModel application;
    private Audit audit;
    private AccountProvider account;
    private Auth auth;
    private AuditProvider auditProvider;

    public AccountService(RealmModel realm, ApplicationModel application, Audit audit) {
        this.realm = realm;
        this.application = application;
        this.audit = audit;
        this.authManager = new AppAuthManager();
    }

    public void init() {
        this.auditProvider = (AuditProvider)this.session.getProvider(AuditProvider.class);
        this.account = ((AccountProvider)this.session.getProvider(AccountProvider.class)).setRealm(this.realm).setUriInfo(this.uriInfo);
        AuthenticationManager.AuthResult authResult = this.authManager.authenticateIdentityCookie(this.session, this.realm, this.uriInfo, this.clientConnection, this.headers);
        if (authResult != null) {
            this.auth = new Auth(this.realm, authResult.getToken(), authResult.getUser(), (ClientModel)this.application, true);
        } else {
            authResult = this.authManager.authenticateBearerToken(this.session, this.realm, this.uriInfo, this.clientConnection, this.headers);
            if (authResult != null) {
                this.auth = new Auth(this.realm, authResult.getToken(), authResult.getUser(), (ClientModel)this.application, false);
            }
        }
        if (authResult != null) {
            UserSessionModel userSession = authResult.getSession();
            if (userSession != null) {
                boolean associated = false;
                for (ClientSessionModel c : userSession.getClientSessions()) {
                    if (!c.getClient().equals(this.application)) continue;
                    associated = true;
                    break;
                }
                if (!associated) {
                    this.session.sessions().createClientSession(this.realm, (ClientModel)this.application, userSession, null, null, null);
                }
            }
            this.account.setUser(this.auth.getUser());
        }
        boolean auditEnabled = this.auditProvider != null && this.realm.isAuditEnabled();
        this.account.setFeatures(this.realm.isSocial(), auditEnabled, true);
    }

    public static UriBuilder accountServiceBaseUrl(UriInfo uriInfo) {
        UriBuilder base = uriInfo.getBaseUriBuilder().path(RealmsResource.class).path(RealmsResource.class, "getAccountService");
        return base;
    }

    public static UriBuilder accountServiceBaseUrl(UriBuilder base) {
        return base.path(RealmsResource.class).path(RealmsResource.class, "getAccountService");
    }

    private Response forwardToPage(String path, AccountPages page) {
        if (this.auth != null) {
            try {
                this.require("manage-account");
            }
            catch (ForbiddenException e) {
                return Flows.forms(this.session, this.realm, null, this.uriInfo).setError("No access").createErrorPage();
            }
            this.setReferrerOnPage();
            return this.account.createResponse(page);
        }
        return this.login(path);
    }

    protected void setReferrerOnPage() {
        String[] referrer = this.getReferrer();
        if (referrer != null) {
            this.account.setReferrer(referrer);
        }
    }

    @Path(value="/")
    @OPTIONS
    public Response accountPreflight() {
        return Cors.add(this.request, Response.ok()).auth().preflight().build();
    }

    @Path(value="/")
    @GET
    public Response accountPage() {
        List types = this.headers.getAcceptableMediaTypes();
        if (types.contains(MediaType.WILDCARD_TYPE) || types.contains(MediaType.TEXT_HTML_TYPE)) {
            return this.forwardToPage(null, AccountPages.ACCOUNT);
        }
        if (types.contains(MediaType.APPLICATION_JSON_TYPE)) {
            this.requireOneOf("manage-account", "view-profile");
            UserRepresentation rep = ModelToRepresentation.toRepresentation((UserModel)this.auth.getUser());
            if (rep.getAttributes() != null) {
                Iterator itr = rep.getAttributes().keySet().iterator();
                while (itr.hasNext()) {
                    if (!((String)itr.next()).startsWith("keycloak.")) continue;
                    itr.remove();
                }
            }
            return Cors.add(this.request, Response.ok((Object)rep)).auth().allowedOrigins(this.auth.getToken()).build();
        }
        return Response.notAcceptable((List)Variant.VariantListBuilder.newInstance().mediaTypes(new MediaType[]{MediaType.TEXT_HTML_TYPE, MediaType.APPLICATION_JSON_TYPE}).build()).build();
    }

    public static UriBuilder totpUrl(UriBuilder base) {
        return RealmsResource.accountUrl(base).path(AccountService.class, "totpPage");
    }

    @Path(value="totp")
    @GET
    public Response totpPage() {
        return this.forwardToPage("totp", AccountPages.TOTP);
    }

    public static UriBuilder passwordUrl(UriBuilder base) {
        return RealmsResource.accountUrl(base).path(AccountService.class, "passwordPage");
    }

    @Path(value="password")
    @GET
    public Response passwordPage() {
        return this.forwardToPage("password", AccountPages.PASSWORD);
    }

    public static UriBuilder socialUrl(UriBuilder base) {
        return RealmsResource.accountUrl(base).path(AccountService.class, "socialPage");
    }

    @Path(value="social")
    @GET
    public Response socialPage() {
        return this.forwardToPage("social", AccountPages.SOCIAL);
    }

    @Path(value="log")
    @GET
    public Response logPage() {
        if (this.auth != null) {
            List events = this.auditProvider.createQuery().event(AUDIT_EVENTS).user(this.auth.getUser().getId()).maxResults(30).getResultList();
            for (Event e : events) {
                if (e.getDetails() == null) continue;
                Iterator itr = e.getDetails().entrySet().iterator();
                while (itr.hasNext()) {
                    if (AUDIT_DETAILS.contains(itr.next().getKey())) continue;
                    itr.remove();
                }
            }
            this.account.setEvents(events);
        }
        return this.forwardToPage("log", AccountPages.LOG);
    }

    @Path(value="sessions")
    @GET
    public Response sessionsPage() {
        if (this.auth != null) {
            this.account.setSessions(this.session.sessions().getUserSessions(this.realm, this.auth.getUser()));
        }
        return this.forwardToPage("sessions", AccountPages.SESSIONS);
    }

    @Path(value="/")
    @POST
    @Consumes(value={"application/x-www-form-urlencoded"})
    public Response processAccountUpdate(MultivaluedMap<String, String> formData) {
        if (this.auth == null) {
            return this.login(null);
        }
        this.require("manage-account");
        String action = (String)formData.getFirst((Object)"submitAction");
        if (action != null && action.equals("Cancel")) {
            this.setReferrerOnPage();
            return this.account.createResponse(AccountPages.ACCOUNT);
        }
        UserModel user = this.auth.getUser();
        String error = Validation.validateUpdateProfileForm(formData);
        if (error != null) {
            this.setReferrerOnPage();
            return this.account.setError(error).createResponse(AccountPages.ACCOUNT);
        }
        user.setFirstName((String)formData.getFirst((Object)"firstName"));
        user.setLastName((String)formData.getFirst((Object)"lastName"));
        String email = (String)formData.getFirst((Object)"email");
        String oldEmail = user.getEmail();
        boolean emailChanged = oldEmail != null ? !oldEmail.equals(email) : email != null;
        user.setEmail((String)formData.getFirst((Object)"email"));
        this.audit.event(EventType.UPDATE_PROFILE).client(this.auth.getClient()).user(this.auth.getUser()).success();
        if (emailChanged) {
            user.setEmailVerified(false);
            this.audit.clone().event(EventType.UPDATE_EMAIL).detail("previous_email", oldEmail).detail("updated_email", email).success();
        }
        this.setReferrerOnPage();
        return this.account.setSuccess("accountUpdated").createResponse(AccountPages.ACCOUNT);
    }

    @Path(value="totp-remove")
    @GET
    public Response processTotpRemove() {
        if (this.auth == null) {
            return this.login("totp");
        }
        this.require("manage-account");
        UserModel user = this.auth.getUser();
        user.setTotp(false);
        this.audit.event(EventType.REMOVE_TOTP).client(this.auth.getClient()).user(this.auth.getUser()).success();
        this.setReferrerOnPage();
        return this.account.setSuccess("successTotpRemoved").createResponse(AccountPages.TOTP);
    }

    @Path(value="sessions-logout")
    @GET
    public Response processSessionsLogout() {
        if (this.auth == null) {
            return this.login("sessions");
        }
        this.require("manage-account");
        UserModel user = this.auth.getUser();
        this.session.sessions().removeUserSessions(this.realm, user);
        UriBuilder builder = Urls.accountBase(this.uriInfo.getBaseUri()).path(AccountService.class, "sessionsPage");
        String referrer = (String)this.uriInfo.getQueryParameters().getFirst((Object)"referrer");
        if (referrer != null) {
            builder.queryParam("referrer", new Object[]{referrer});
        }
        URI location = builder.build(new Object[]{this.realm.getName()});
        return Response.seeOther((URI)location).build();
    }

    @Path(value="totp")
    @POST
    @Consumes(value={"application/x-www-form-urlencoded"})
    public Response processTotpUpdate(MultivaluedMap<String, String> formData) {
        if (this.auth == null) {
            return this.login("totp");
        }
        this.require("manage-account");
        String action = (String)formData.getFirst((Object)"submitAction");
        if (action != null && action.equals("Cancel")) {
            this.setReferrerOnPage();
            return this.account.createResponse(AccountPages.TOTP);
        }
        UserModel user = this.auth.getUser();
        String totp = (String)formData.getFirst((Object)"totp");
        String totpSecret = (String)formData.getFirst((Object)"totpSecret");
        if (Validation.isEmpty(totp)) {
            this.setReferrerOnPage();
            return this.account.setError("missingTotp").createResponse(AccountPages.TOTP);
        }
        if (!new TimeBasedOTP().validate(totp, totpSecret.getBytes())) {
            this.setReferrerOnPage();
            return this.account.setError("invalidTotp").createResponse(AccountPages.TOTP);
        }
        UserCredentialModel credentials = new UserCredentialModel();
        credentials.setType("totp");
        credentials.setValue(totpSecret);
        this.session.users().updateCredential(this.realm, user, credentials);
        user.setTotp(true);
        this.audit.event(EventType.UPDATE_TOTP).client(this.auth.getClient()).user(this.auth.getUser()).success();
        this.setReferrerOnPage();
        return this.account.setSuccess("successTotp").createResponse(AccountPages.TOTP);
    }

    @Path(value="password")
    @POST
    @Consumes(value={"application/x-www-form-urlencoded"})
    public Response processPasswordUpdate(MultivaluedMap<String, String> formData) {
        if (this.auth == null) {
            return this.login("password");
        }
        this.require("manage-account");
        String action = (String)formData.getFirst((Object)"submitAction");
        if (action != null && action.equals("Cancel")) {
            this.setReferrerOnPage();
            return this.account.createResponse(AccountPages.PASSWORD);
        }
        UserModel user = this.auth.getUser();
        String password = (String)formData.getFirst((Object)"password");
        String passwordNew = (String)formData.getFirst((Object)"password-new");
        String passwordConfirm = (String)formData.getFirst((Object)"password-confirm");
        if (Validation.isEmpty(passwordNew)) {
            this.setReferrerOnPage();
            return this.account.setError("missingPassword").createResponse(AccountPages.PASSWORD);
        }
        if (!passwordNew.equals(passwordConfirm)) {
            this.setReferrerOnPage();
            return this.account.setError("invalidPasswordConfirm").createResponse(AccountPages.PASSWORD);
        }
        UserCredentialModel cred = UserCredentialModel.password((String)password);
        if (Validation.isEmpty(password)) {
            this.setReferrerOnPage();
            return this.account.setError("missingPassword").createResponse(AccountPages.PASSWORD);
        }
        if (!this.session.users().validCredentials(this.realm, user, new UserCredentialModel[]{cred})) {
            this.setReferrerOnPage();
            return this.account.setError("invalidPasswordExisting").createResponse(AccountPages.PASSWORD);
        }
        try {
            this.session.users().updateCredential(this.realm, user, UserCredentialModel.password((String)passwordNew));
        }
        catch (Exception ape) {
            logger.error((Object)"Failed to update password", (Throwable)ape);
            this.setReferrerOnPage();
            return this.account.setError(ape.getMessage()).createResponse(AccountPages.PASSWORD);
        }
        this.audit.event(EventType.UPDATE_PASSWORD).client(this.auth.getClient()).user(this.auth.getUser()).success();
        this.setReferrerOnPage();
        return this.account.setSuccess("accountPasswordUpdated").createResponse(AccountPages.PASSWORD);
    }

    @Path(value="social-update")
    @GET
    public Response processSocialUpdate(@QueryParam(value="action") String action, @QueryParam(value="provider_id") String providerId) {
        if (this.auth == null) {
            return this.login("social");
        }
        this.require("manage-account");
        UserModel user = this.auth.getUser();
        if (Validation.isEmpty(providerId)) {
            this.setReferrerOnPage();
            return this.account.setError("missingSocialProvider").createResponse(AccountPages.SOCIAL);
        }
        AccountSocialAction accountSocialAction = AccountSocialAction.getAction(action);
        if (accountSocialAction == null) {
            this.setReferrerOnPage();
            return this.account.setError("invalidSocialAction").createResponse(AccountPages.SOCIAL);
        }
        SocialProvider provider = SocialLoader.load((String)providerId);
        if (provider == null) {
            this.setReferrerOnPage();
            return this.account.setError("socialProviderNotFound").createResponse(AccountPages.SOCIAL);
        }
        if (!user.isEnabled()) {
            this.setReferrerOnPage();
            return this.account.setError("accountDisabled").createResponse(AccountPages.SOCIAL);
        }
        switch (accountSocialAction) {
            case ADD: {
                String redirectUri = UriBuilder.fromUri((URI)Urls.accountSocialPage(this.uriInfo.getBaseUri(), this.realm.getName())).build(new Object[0]).toString();
                try {
                    return Flows.social(this.realm, this.uriInfo, this.clientConnection, provider).user(user).putClientAttribute("client_id", "account").putClientAttribute("state", UUID.randomUUID().toString()).putClientAttribute("redirect_uri", redirectUri).redirectToSocialProvider();
                }
                catch (SocialProviderException spe) {
                    this.setReferrerOnPage();
                    return this.account.setError("socialRedirectError").createResponse(AccountPages.SOCIAL);
                }
            }
            case REMOVE: {
                SocialLinkModel link = this.session.users().getSocialLink(user, providerId, this.realm);
                if (link != null) {
                    if (this.session.users().getSocialLinks(user, this.realm).size() > 1 || user.getFederationLink() != null) {
                        this.session.users().removeSocialLink(this.realm, user, providerId);
                        logger.debug((Object)("Social provider " + providerId + " removed successfully from user " + user.getUsername()));
                        this.audit.event(EventType.REMOVE_SOCIAL_LINK).client(this.auth.getClient()).user(this.auth.getUser()).detail("username", link.getSocialUserId() + "@" + link.getSocialProvider()).success();
                        this.setReferrerOnPage();
                        return this.account.setSuccess("socialProviderRemoved").createResponse(AccountPages.SOCIAL);
                    }
                    this.setReferrerOnPage();
                    return this.account.setError("socialRemovingLastProvider").createResponse(AccountPages.SOCIAL);
                }
                this.setReferrerOnPage();
                return this.account.setError("socialLinkNotActive").createResponse(AccountPages.SOCIAL);
            }
        }
        logger.warn((Object)"Action is null!");
        return null;
    }

    public static UriBuilder loginRedirectUrl(UriBuilder base) {
        return RealmsResource.accountUrl(base).path(AccountService.class, "loginRedirect");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Path(value="login-redirect")
    @GET
    public Response loginRedirect(@QueryParam(value="code") String code, @QueryParam(value="state") String state, @QueryParam(value="error") String error, @QueryParam(value="path") String path, @QueryParam(value="referrer") String referrer, @Context HttpHeaders headers) {
        URI redirectUri;
        if (error != null) {
            logger.debug((Object)"error from oauth");
            throw new ForbiddenException("error");
        }
        if (!this.realm.isEnabled()) {
            logger.debug((Object)"realm not enabled");
            throw new ForbiddenException();
        }
        if (!this.application.isEnabled()) {
            logger.debug((Object)"account management app not enabled");
            throw new ForbiddenException();
        }
        if (code == null) {
            logger.debug((Object)"code not specified");
            throw new BadRequestException("code not specified");
        }
        if (state == null) {
            logger.debug((Object)"state not specified");
            throw new BadRequestException("state not specified");
        }
        URI accountUri = Urls.accountBase(this.uriInfo.getBaseUri()).path("/").build(new Object[]{this.realm.getName()});
        URI uRI = redirectUri = path != null ? accountUri.resolve(path) : accountUri;
        if (referrer != null) {
            redirectUri = redirectUri.resolve("?referrer=" + referrer);
        }
        Response response = Response.status((int)302).location(redirectUri).build();
        return response;
    }

    private Response login(String path) {
        String referrerUri;
        String referrer;
        OAuthRedirect oauth = new OAuthRedirect();
        String authUrl = Urls.realmLoginPage(this.uriInfo.getBaseUri(), this.realm.getName()).toString();
        oauth.setAuthUrl(authUrl);
        oauth.setClientId("account");
        UriBuilder uriBuilder = Urls.accountPageBuilder(this.uriInfo.getBaseUri()).path(AccountService.class, "loginRedirect");
        if (path != null) {
            uriBuilder.queryParam("path", new Object[]{path});
        }
        if ((referrer = (String)this.uriInfo.getQueryParameters().getFirst((Object)"referrer")) != null) {
            uriBuilder.queryParam("referrer", new Object[]{referrer});
        }
        if ((referrerUri = (String)this.uriInfo.getQueryParameters().getFirst((Object)"referrer_uri")) != null) {
            uriBuilder.queryParam("referrer_uri", new Object[]{referrerUri});
        }
        URI accountUri = uriBuilder.build(new Object[]{this.realm.getName()});
        oauth.setStateCookiePath(accountUri.getRawPath());
        return oauth.redirect(this.uriInfo, accountUri.toString());
    }

    private String[] getReferrer() {
        OAuthClientModel client;
        String referrer = (String)this.uriInfo.getQueryParameters().getFirst((Object)"referrer");
        if (referrer == null) {
            return null;
        }
        String referrerUri = (String)this.uriInfo.getQueryParameters().getFirst((Object)"referrer_uri");
        ApplicationModel application = this.realm.getApplicationByName(referrer);
        if (application != null ? (referrerUri = referrerUri != null ? TokenService.verifyRedirectUri(this.uriInfo, referrerUri, this.realm, (ClientModel)application) : ResolveRelative.resolveRelativeUri(this.uriInfo.getRequestUri(), application.getBaseUrl())) != null : referrerUri != null && (client = this.realm.getOAuthClient(referrer)) != null && (referrerUri = TokenService.verifyRedirectUri(this.uriInfo, referrerUri, this.realm, (ClientModel)application)) != null) {
            return new String[]{referrer, referrerUri};
        }
        return null;
    }

    public void require(String role) {
        if (this.auth == null) {
            throw new ForbiddenException();
        }
        if (!this.auth.hasAppRole(this.application, role)) {
            throw new ForbiddenException();
        }
    }

    public void requireOneOf(String ... roles) {
        if (this.auth == null) {
            throw new ForbiddenException();
        }
        if (!this.auth.hasOneOfAppRole(this.application, roles)) {
            throw new ForbiddenException();
        }
    }

    static {
        AUDIT_DETAILS.add("updated_email");
        AUDIT_DETAILS.add("email");
        AUDIT_DETAILS.add("previous_email");
        AUDIT_DETAILS.add("username");
        AUDIT_DETAILS.add("remember_me");
        AUDIT_DETAILS.add("register_method");
        AUDIT_DETAILS.add("auth_method");
    }

    public static enum AccountSocialAction {
        ADD,
        REMOVE;


        public static AccountSocialAction getAction(String action) {
            if ("add".equalsIgnoreCase(action)) {
                return ADD;
            }
            if ("remove".equalsIgnoreCase(action)) {
                return REMOVE;
            }
            return null;
        }
    }
}

