/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.services.resources.admin;

import java.net.URI;
import java.util.LinkedList;
import java.util.List;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriInfo;
import org.jboss.logging.Logger;
import org.jboss.resteasy.annotations.cache.NoCache;
import org.jboss.resteasy.spi.NotFoundException;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.RealmModel;
import org.keycloak.models.UserFederationProvider;
import org.keycloak.models.UserFederationProviderFactory;
import org.keycloak.models.UserFederationProviderModel;
import org.keycloak.models.utils.ModelToRepresentation;
import org.keycloak.provider.ProviderFactory;
import org.keycloak.representations.idm.UserFederationProviderFactoryRepresentation;
import org.keycloak.representations.idm.UserFederationProviderRepresentation;
import org.keycloak.services.managers.UsersSyncManager;
import org.keycloak.services.resources.admin.RealmAuth;
import org.keycloak.timer.TimerProvider;

public class UserFederationResource {
    protected static final Logger logger = Logger.getLogger(UserFederationResource.class);
    protected RealmModel realm;
    protected RealmAuth auth;
    @Context
    protected UriInfo uriInfo;
    @Context
    protected KeycloakSession session;

    public UserFederationResource(RealmModel realm, RealmAuth auth) {
        this.auth = auth;
        this.realm = realm;
        auth.init(RealmAuth.Resource.USER);
    }

    @GET
    @NoCache
    @Path(value="providers")
    @Produces(value={"application/json"})
    public List<UserFederationProviderFactoryRepresentation> getProviders() {
        logger.info((Object)"get provider list");
        this.auth.requireView();
        LinkedList<UserFederationProviderFactoryRepresentation> providers = new LinkedList<UserFederationProviderFactoryRepresentation>();
        for (ProviderFactory factory : this.session.getKeycloakSessionFactory().getProviderFactories(UserFederationProvider.class)) {
            UserFederationProviderFactoryRepresentation rep = new UserFederationProviderFactoryRepresentation();
            rep.setId(factory.getId());
            rep.setOptions(((UserFederationProviderFactory)factory).getConfigurationOptions());
            providers.add(rep);
        }
        logger.info((Object)("provider list.size() " + providers.size()));
        return providers;
    }

    @GET
    @NoCache
    @Path(value="providers/{id}")
    @Produces(value={"application/json"})
    public UserFederationProviderFactoryRepresentation getProvider(@PathParam(value="id") String id) {
        logger.info((Object)"get provider list");
        this.auth.requireView();
        for (ProviderFactory factory : this.session.getKeycloakSessionFactory().getProviderFactories(UserFederationProvider.class)) {
            if (!factory.getId().equals(id)) continue;
            UserFederationProviderFactoryRepresentation rep = new UserFederationProviderFactoryRepresentation();
            rep.setId(factory.getId());
            rep.setOptions(((UserFederationProviderFactory)factory).getConfigurationOptions());
            return rep;
        }
        throw new NotFoundException("Could not find provider");
    }

    @POST
    @Path(value="instances")
    @Consumes(value={"application/json"})
    public Response createProviderInstance(UserFederationProviderRepresentation rep) {
        logger.info((Object)"createProvider");
        this.auth.requireManage();
        String displayName = rep.getDisplayName();
        if (displayName != null && displayName.trim().equals("")) {
            displayName = null;
        }
        UserFederationProviderModel model = this.realm.addUserFederationProvider(rep.getProviderName(), rep.getConfig(), rep.getPriority(), displayName, rep.getFullSyncPeriod(), rep.getChangedSyncPeriod(), rep.getLastSync());
        new UsersSyncManager().refreshPeriodicSyncForProvider(this.session.getKeycloakSessionFactory(), (TimerProvider)this.session.getProvider(TimerProvider.class), model, this.realm.getId());
        return Response.created((URI)this.uriInfo.getAbsolutePathBuilder().path(model.getId()).build(new Object[0])).build();
    }

    @PUT
    @Path(value="instances/{id}")
    @Consumes(value={"application/json"})
    public void updateProviderInstance(@PathParam(value="id") String id, UserFederationProviderRepresentation rep) {
        logger.info((Object)"updateProvider");
        this.auth.requireManage();
        String displayName = rep.getDisplayName();
        if (displayName != null && displayName.trim().equals("")) {
            displayName = null;
        }
        UserFederationProviderModel model = new UserFederationProviderModel(id, rep.getProviderName(), rep.getConfig(), rep.getPriority(), displayName, rep.getFullSyncPeriod(), rep.getChangedSyncPeriod(), rep.getLastSync());
        this.realm.updateUserFederationProvider(model);
        new UsersSyncManager().refreshPeriodicSyncForProvider(this.session.getKeycloakSessionFactory(), (TimerProvider)this.session.getProvider(TimerProvider.class), model, this.realm.getId());
    }

    @GET
    @NoCache
    @Path(value="instances/{id}")
    @Produces(value={"application/json"})
    public UserFederationProviderRepresentation getProviderInstance(@PathParam(value="id") String id) {
        logger.info((Object)"getProvider");
        this.auth.requireView();
        for (UserFederationProviderModel model : this.realm.getUserFederationProviders()) {
            if (!model.getId().equals(id)) continue;
            return ModelToRepresentation.toRepresentation((UserFederationProviderModel)model);
        }
        throw new NotFoundException("could not find provider");
    }

    @DELETE
    @Path(value="instances/{id}")
    public void deleteProviderInstance(@PathParam(value="id") String id) {
        logger.info((Object)"deleteProvider");
        this.auth.requireManage();
        UserFederationProviderModel model = new UserFederationProviderModel(id, null, null, -1, null, -1, -1, 0);
        this.realm.removeUserFederationProvider(model);
        new UsersSyncManager().removePeriodicSyncForProvider((TimerProvider)this.session.getProvider(TimerProvider.class), model);
    }

    @GET
    @Path(value="instances")
    @Produces(value={"application/json"})
    @NoCache
    public List<UserFederationProviderRepresentation> getUserFederationInstances() {
        logger.info((Object)"getUserFederationInstances");
        this.auth.requireManage();
        LinkedList<UserFederationProviderRepresentation> reps = new LinkedList<UserFederationProviderRepresentation>();
        for (UserFederationProviderModel model : this.realm.getUserFederationProviders()) {
            UserFederationProviderRepresentation rep = ModelToRepresentation.toRepresentation((UserFederationProviderModel)model);
            reps.add(rep);
        }
        return reps;
    }

    @GET
    @Path(value="sync/{id}")
    @NoCache
    public Response syncUsers(@PathParam(value="id") String providerId, @QueryParam(value="action") String action) {
        logger.info((Object)"triggerSync");
        this.auth.requireManage();
        for (UserFederationProviderModel model : this.realm.getUserFederationProviders()) {
            if (!model.getId().equals(providerId)) continue;
            UsersSyncManager syncManager = new UsersSyncManager();
            if ("triggerFullSync".equals(action)) {
                syncManager.syncAllUsers(this.session.getKeycloakSessionFactory(), this.realm.getId(), model);
            } else if ("triggerChangedUsersSync".equals(action)) {
                syncManager.syncChangedUsers(this.session.getKeycloakSessionFactory(), this.realm.getId(), model);
            }
            return Response.noContent().build();
        }
        throw new NotFoundException("could not find provider");
    }
}

