/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.services.resources.flows;

import java.net.URI;
import javax.ws.rs.core.Cookie;
import javax.ws.rs.core.HttpHeaders;
import javax.ws.rs.core.NewCookie;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriBuilder;
import javax.ws.rs.core.UriInfo;
import org.jboss.logging.Logger;
import org.jboss.resteasy.spi.BadRequestException;
import org.keycloak.AbstractOAuthClient;

public class OAuthRedirect
extends AbstractOAuthClient {
    protected static final Logger logger = Logger.getLogger(OAuthRedirect.class);

    public void stop() {
    }

    public Response redirect(UriInfo uriInfo, String redirectUri) {
        String state = this.getStateCode();
        UriBuilder uriBuilder = UriBuilder.fromUri((String)this.authUrl).queryParam("client_id", new Object[]{this.clientId}).queryParam("redirect_uri", new Object[]{redirectUri}).queryParam("state", new Object[]{state});
        if (this.scope != null) {
            uriBuilder.queryParam("scope", new Object[]{this.scope});
        }
        URI url = uriBuilder.build(new Object[0]);
        NewCookie cookie = new NewCookie(this.getStateCookieName(), state, this.getStateCookiePath(uriInfo), null, null, -1, this.isSecure);
        logger.debug((Object)("NewCookie: " + cookie.toString()));
        logger.debug((Object)("Oauth Redirect to: " + url));
        return Response.status((int)302).location(url).cookie(new NewCookie[]{cookie}).build();
    }

    public String getStateCookiePath(UriInfo uriInfo) {
        if (this.stateCookiePath != null) {
            return this.stateCookiePath;
        }
        return uriInfo.getBaseUri().getRawPath();
    }

    public String getError(UriInfo uriInfo) {
        return (String)uriInfo.getQueryParameters().getFirst((Object)"error");
    }

    public String getAccessCode(UriInfo uriInfo) {
        return (String)uriInfo.getQueryParameters().getFirst((Object)"code");
    }

    public void checkStateCookie(UriInfo uriInfo, HttpHeaders headers) {
        Cookie stateCookie = (Cookie)headers.getCookies().get(this.stateCookieName);
        if (stateCookie == null) {
            throw new BadRequestException("state cookie not set");
        }
        String state = (String)uriInfo.getQueryParameters().getFirst((Object)"state");
        if (state == null) {
            throw new BadRequestException("state parameter was null");
        }
        if (!state.equals(stateCookie.getValue())) {
            throw new BadRequestException("state parameter invalid");
        }
    }
}

