/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.services.managers;

import javax.ws.rs.core.HttpHeaders;
import javax.ws.rs.core.UriInfo;
import org.jboss.logging.Logger;
import org.jboss.resteasy.spi.UnauthorizedException;
import org.keycloak.ClientConnection;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.RealmModel;
import org.keycloak.services.managers.AuthenticationManager;

public class AppAuthManager
extends AuthenticationManager {
    protected static Logger logger = Logger.getLogger(AppAuthManager.class);

    @Override
    public AuthenticationManager.AuthResult authenticateIdentityCookie(KeycloakSession session, RealmModel realm, UriInfo uriInfo, ClientConnection connection, HttpHeaders headers) {
        AuthenticationManager.AuthResult authResult = super.authenticateIdentityCookie(session, realm, uriInfo, connection, headers);
        if (authResult == null) {
            return null;
        }
        this.createLoginCookie(realm, authResult.getUser(), authResult.getSession(), uriInfo, connection);
        if (authResult.getSession().isRememberMe()) {
            this.createRememberMeCookie(realm, authResult.getUser().getUsername(), uriInfo, connection);
        }
        return authResult;
    }

    public String extractAuthorizationHeaderToken(HttpHeaders headers) {
        String tokenString = null;
        String authHeader = (String)headers.getRequestHeaders().getFirst((Object)"Authorization");
        if (authHeader != null) {
            String[] split = authHeader.trim().split("\\s+");
            if (split == null || split.length != 2) {
                throw new UnauthorizedException("Bearer");
            }
            if (!split[0].equalsIgnoreCase("Bearer")) {
                throw new UnauthorizedException("Bearer");
            }
            tokenString = split[1];
        }
        return tokenString;
    }

    public AuthenticationManager.AuthResult authenticateBearerToken(KeycloakSession session, RealmModel realm, UriInfo uriInfo, ClientConnection connection, HttpHeaders headers) {
        String tokenString = this.extractAuthorizationHeaderToken(headers);
        if (tokenString == null) {
            return null;
        }
        AuthenticationManager.AuthResult authResult = this.verifyIdentityToken(session, realm, uriInfo, connection, true, tokenString);
        return authResult;
    }
}

