/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.services.managers;

import org.jboss.logging.Logger;
import org.keycloak.Config;
import org.keycloak.enums.SslRequired;
import org.keycloak.models.AdminRoles;
import org.keycloak.models.ApplicationModel;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.KeycloakSessionFactory;
import org.keycloak.models.RealmModel;
import org.keycloak.models.RoleModel;
import org.keycloak.models.UserCredentialModel;
import org.keycloak.models.UserModel;
import org.keycloak.models.utils.KeycloakModelUtils;
import org.keycloak.services.managers.RealmManager;

public class ApplianceBootstrap {
    private static final Logger logger = Logger.getLogger(ApplianceBootstrap.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void bootstrap(KeycloakSessionFactory sessionFactory, String contextPath) {
        KeycloakSession session = sessionFactory.create();
        session.getTransaction().begin();
        try {
            this.bootstrap(session, contextPath);
            session.getTransaction().commit();
        }
        finally {
            session.close();
        }
    }

    public void bootstrap(KeycloakSession session, String contextPath) {
        String adminRealmName = Config.getAdminRealm();
        if (session.realms().getRealm(adminRealmName) != null) {
            return;
        }
        logger.info((Object)("Initializing " + adminRealmName + " realm"));
        RealmManager manager = new RealmManager(session);
        manager.setContextPath(contextPath);
        RealmModel realm = manager.createRealm(adminRealmName, adminRealmName);
        realm.setName(adminRealmName);
        realm.setEnabled(true);
        realm.addRequiredCredential("password");
        realm.setSsoSessionIdleTimeout(300);
        realm.setAccessTokenLifespan(60);
        realm.setSsoSessionMaxLifespan(36000);
        realm.setAccessCodeLifespan(60);
        realm.setAccessCodeLifespanUserAction(300);
        realm.setSslRequired(SslRequired.EXTERNAL);
        realm.setRegistrationAllowed(false);
        KeycloakModelUtils.generateRealmKeys((RealmModel)realm);
        UserModel adminUser = session.users().addUser(realm, "admin");
        adminUser.setEnabled(true);
        UserCredentialModel password = new UserCredentialModel();
        password.setType("password");
        password.setValue("admin");
        session.users().updateCredential(realm, adminUser, password);
        adminUser.addRequiredAction(UserModel.RequiredAction.UPDATE_PASSWORD);
        RoleModel adminRole = realm.getRole(AdminRoles.ADMIN);
        adminUser.grantRole(adminRole);
        ApplicationModel accountApp = (ApplicationModel)realm.getApplicationNameMap().get("account");
        for (String r : accountApp.getDefaultRoles()) {
            adminUser.grantRole(accountApp.getRole(r));
        }
    }
}

