/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.services.resources;

import java.io.InputStream;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.core.CacheControl;
import javax.ws.rs.core.Response;
import org.keycloak.Config;

@Path(value="/js")
public class JsResource {
    @GET
    @Path(value="/keycloak.js")
    @Produces(value={"text/javascript"})
    public Response getJs() {
        InputStream inputStream = this.getClass().getClassLoader().getResourceAsStream("keycloak.js");
        if (inputStream != null) {
            CacheControl cacheControl = new CacheControl();
            cacheControl.setNoTransform(false);
            cacheControl.setMaxAge(Config.scope((String[])new String[]{"theme"}).getInt("staticMaxAge", Integer.valueOf(-1)).intValue());
            return Response.ok((Object)inputStream).type("text/javascript").cacheControl(cacheControl).build();
        }
        return Response.status((Response.Status)Response.Status.NOT_FOUND).build();
    }

    @GET
    @Path(value="/keycloak.min.js")
    @Produces(value={"text/javascript"})
    public Response getMinJs() {
        InputStream inputStream = this.getClass().getClassLoader().getResourceAsStream("keycloak.min.js");
        if (inputStream != null) {
            CacheControl cacheControl = new CacheControl();
            cacheControl.setNoTransform(false);
            cacheControl.setMaxAge(Config.scope((String[])new String[]{"theme"}).getInt("staticMaxAge", Integer.valueOf(-1)).intValue());
            return Response.ok((Object)inputStream).type("text/javascript").cacheControl(cacheControl).build();
        }
        return Response.status((Response.Status)Response.Status.NOT_FOUND).build();
    }
}

