/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.services.resources.admin;

import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriInfo;
import org.jboss.logging.Logger;
import org.jboss.resteasy.annotations.cache.NoCache;
import org.jboss.resteasy.spi.NotFoundException;
import org.jboss.resteasy.spi.ResteasyProviderFactory;
import org.keycloak.events.Event;
import org.keycloak.events.EventQuery;
import org.keycloak.events.EventStoreProvider;
import org.keycloak.events.EventType;
import org.keycloak.exportimport.ApplicationImporter;
import org.keycloak.models.ApplicationModel;
import org.keycloak.models.ClientModel;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.ModelDuplicateException;
import org.keycloak.models.RealmModel;
import org.keycloak.models.RoleContainerModel;
import org.keycloak.models.UserFederationProviderModel;
import org.keycloak.models.UserSessionModel;
import org.keycloak.models.cache.CacheRealmProvider;
import org.keycloak.models.cache.CacheUserProvider;
import org.keycloak.models.utils.ModelToRepresentation;
import org.keycloak.models.utils.RepresentationToModel;
import org.keycloak.protocol.oidc.TokenManager;
import org.keycloak.representations.adapters.action.GlobalRequestResult;
import org.keycloak.representations.idm.RealmEventsConfigRepresentation;
import org.keycloak.representations.idm.RealmRepresentation;
import org.keycloak.services.managers.LDAPConnectionTestManager;
import org.keycloak.services.managers.RealmManager;
import org.keycloak.services.managers.ResourceAdminManager;
import org.keycloak.services.managers.UsersSyncManager;
import org.keycloak.services.resources.admin.ApplicationsByIdResource;
import org.keycloak.services.resources.admin.ApplicationsResource;
import org.keycloak.services.resources.admin.OAuthClientsByIdResource;
import org.keycloak.services.resources.admin.OAuthClientsResource;
import org.keycloak.services.resources.admin.RealmAuth;
import org.keycloak.services.resources.admin.RoleByIdResource;
import org.keycloak.services.resources.admin.RoleContainerResource;
import org.keycloak.services.resources.admin.UserFederationResource;
import org.keycloak.services.resources.admin.UsersResource;
import org.keycloak.services.resources.flows.Flows;
import org.keycloak.timer.TimerProvider;

public class RealmAdminResource {
    protected static final Logger logger = Logger.getLogger(RealmAdminResource.class);
    protected RealmAuth auth;
    protected RealmModel realm;
    private TokenManager tokenManager;
    @Context
    protected KeycloakSession session;
    @Context
    protected UriInfo uriInfo;

    public RealmAdminResource(RealmAuth auth, RealmModel realm, TokenManager tokenManager) {
        this.auth = auth;
        this.realm = realm;
        this.tokenManager = tokenManager;
        auth.init(RealmAuth.Resource.REALM);
    }

    @Path(value="application-importers/{formatId}")
    public Object getApplicationImporter(@PathParam(value="formatId") String formatId) {
        ApplicationImporter importer = (ApplicationImporter)this.session.getProvider(ApplicationImporter.class, formatId);
        return importer.createJaxrsService(this.realm, this.auth);
    }

    @Path(value="applications")
    public ApplicationsResource getApplications() {
        ApplicationsResource applicationsResource = new ApplicationsResource(this.realm, this.auth);
        ResteasyProviderFactory.getInstance().injectProperties((Object)applicationsResource);
        return applicationsResource;
    }

    @Path(value="applications-by-id")
    public ApplicationsByIdResource getApplicationsById() {
        ApplicationsByIdResource applicationsResource = new ApplicationsByIdResource(this.realm, this.auth);
        ResteasyProviderFactory.getInstance().injectProperties((Object)applicationsResource);
        return applicationsResource;
    }

    @Path(value="oauth-clients")
    public OAuthClientsResource getOAuthClients() {
        OAuthClientsResource oauth = new OAuthClientsResource(this.realm, this.auth, this.session);
        ResteasyProviderFactory.getInstance().injectProperties((Object)oauth);
        return oauth;
    }

    @Path(value="oauth-clients-by-id")
    public OAuthClientsByIdResource getOAuthClientsById() {
        OAuthClientsByIdResource oauth = new OAuthClientsByIdResource(this.realm, this.auth, this.session);
        ResteasyProviderFactory.getInstance().injectProperties((Object)oauth);
        return oauth;
    }

    @Path(value="roles")
    public RoleContainerResource getRoleContainerResource() {
        return new RoleContainerResource(this.realm, this.auth, (RoleContainerModel)this.realm);
    }

    @GET
    @NoCache
    @Produces(value={"application/json"})
    public RealmRepresentation getRealm() {
        if (this.auth.hasView()) {
            RealmRepresentation rep = ModelToRepresentation.toRepresentation((RealmModel)this.realm, (boolean)false);
            if (this.session.realms() instanceof CacheRealmProvider) {
                CacheRealmProvider cacheRealmProvider = (CacheRealmProvider)this.session.realms();
                rep.setRealmCacheEnabled(Boolean.valueOf(cacheRealmProvider.isEnabled()));
            }
            if (this.session.userStorage() instanceof CacheUserProvider) {
                CacheUserProvider cache = (CacheUserProvider)this.session.userStorage();
                rep.setUserCacheEnabled(Boolean.valueOf(cache.isEnabled()));
            }
            return rep;
        }
        this.auth.requireAny();
        RealmRepresentation rep = new RealmRepresentation();
        rep.setRealm(this.realm.getName());
        return rep;
    }

    @PUT
    @Consumes(value={"application/json"})
    public Response updateRealm(RealmRepresentation rep) {
        this.auth.requireManage();
        logger.debug((Object)("updating realm: " + this.realm.getName()));
        try {
            RepresentationToModel.updateRealm((RealmRepresentation)rep, (RealmModel)this.realm);
            if (rep.isRealmCacheEnabled() != null && this.session.realms() instanceof CacheRealmProvider) {
                CacheRealmProvider cacheRealmProvider = (CacheRealmProvider)this.session.realms();
                cacheRealmProvider.setEnabled(rep.isRealmCacheEnabled().booleanValue());
            }
            if (rep.isUserCacheEnabled() != null && this.session.userStorage() instanceof CacheUserProvider) {
                CacheUserProvider cache = (CacheUserProvider)this.session.userStorage();
                cache.setEnabled(rep.isUserCacheEnabled().booleanValue());
            }
            List federationProviders = this.realm.getUserFederationProviders();
            UsersSyncManager usersSyncManager = new UsersSyncManager();
            for (UserFederationProviderModel fedProvider : federationProviders) {
                usersSyncManager.refreshPeriodicSyncForProvider(this.session.getKeycloakSessionFactory(), (TimerProvider)this.session.getProvider(TimerProvider.class), fedProvider, this.realm.getId());
            }
            return Response.noContent().build();
        }
        catch (ModelDuplicateException e) {
            return Flows.errors().exists("Realm " + rep.getRealm() + " already exists");
        }
    }

    @DELETE
    public void deleteRealm() {
        this.auth.requireManage();
        if (!new RealmManager(this.session).removeRealm(this.realm)) {
            throw new NotFoundException("Realm doesn't exist");
        }
    }

    @Path(value="users")
    public UsersResource users() {
        UsersResource users = new UsersResource(this.realm, this.auth, this.tokenManager);
        ResteasyProviderFactory.getInstance().injectProperties((Object)users);
        return users;
    }

    @Path(value="user-federation")
    public UserFederationResource userFederation() {
        UserFederationResource fed = new UserFederationResource(this.realm, this.auth);
        ResteasyProviderFactory.getInstance().injectProperties((Object)fed);
        return fed;
    }

    @Path(value="roles-by-id")
    public RoleByIdResource rolesById() {
        RoleByIdResource resource = new RoleByIdResource(this.realm, this.auth);
        ResteasyProviderFactory.getInstance().injectProperties((Object)resource);
        return resource;
    }

    @Path(value="push-revocation")
    @POST
    public GlobalRequestResult pushRevocation() {
        this.auth.requireManage();
        return new ResourceAdminManager().pushRealmRevocationPolicy(this.uriInfo.getRequestUri(), this.realm);
    }

    @Path(value="logout-all")
    @POST
    public GlobalRequestResult logoutAll() {
        this.auth.requireManage();
        this.session.sessions().removeUserSessions(this.realm);
        return new ResourceAdminManager().logoutAll(this.uriInfo.getRequestUri(), this.realm);
    }

    @Path(value="sessions/{session}")
    @DELETE
    public void deleteSession(@PathParam(value="session") String sessionId) {
        UserSessionModel userSession = this.session.sessions().getUserSession(this.realm, sessionId);
        if (userSession == null) {
            throw new NotFoundException("Sesssion not found");
        }
        this.session.sessions().removeUserSession(this.realm, userSession);
        new ResourceAdminManager().logoutSession(this.uriInfo.getRequestUri(), this.realm, userSession);
    }

    @Path(value="application-session-stats")
    @GET
    @NoCache
    @Produces(value={"application/json"})
    @Deprecated
    public Map<String, Integer> getApplicationSessionStats() {
        this.auth.requireView();
        HashMap<String, Integer> stats = new HashMap<String, Integer>();
        for (ApplicationModel application : this.realm.getApplications()) {
            int size = this.session.sessions().getActiveUserSessions(application.getRealm(), (ClientModel)application);
            if (size == 0) continue;
            stats.put(application.getName(), size);
        }
        return stats;
    }

    @Path(value="application-by-id-session-stats")
    @GET
    @NoCache
    @Produces(value={"application/json"})
    public List<Map<String, String>> getApplicationByIdSessionStats() {
        this.auth.requireView();
        LinkedList<Map<String, String>> data = new LinkedList<Map<String, String>>();
        for (ApplicationModel application : this.realm.getApplications()) {
            int size = this.session.sessions().getActiveUserSessions(application.getRealm(), (ClientModel)application);
            if (size == 0) continue;
            HashMap<String, String> map = new HashMap<String, String>();
            map.put("id", application.getId());
            map.put("name", application.getName());
            map.put("active", size + "");
            data.add(map);
        }
        return data;
    }

    @GET
    @NoCache
    @Path(value="events/config")
    @Produces(value={"application/json"})
    public RealmEventsConfigRepresentation getRealmEventsConfig() {
        this.auth.init(RealmAuth.Resource.EVENTS).requireView();
        return ModelToRepresentation.toEventsConfigReprensetation((RealmModel)this.realm);
    }

    @PUT
    @Path(value="events/config")
    @Consumes(value={"application/json"})
    public void updateRealmEventsConfig(RealmEventsConfigRepresentation rep) {
        this.auth.init(RealmAuth.Resource.EVENTS).requireManage();
        logger.debug((Object)("updating realm events config: " + this.realm.getName()));
        new RealmManager(this.session).updateRealmEventsConfig(rep, this.realm);
    }

    @Path(value="events")
    @GET
    @NoCache
    @Produces(value={"application/json"})
    public List<Event> getEvents(@QueryParam(value="client") String client, @QueryParam(value="type") String type, @QueryParam(value="user") String user, @QueryParam(value="ipAddress") String ipAddress, @QueryParam(value="first") Integer firstResult, @QueryParam(value="max") Integer maxResults) {
        this.auth.init(RealmAuth.Resource.EVENTS).requireView();
        EventStoreProvider eventStore = (EventStoreProvider)this.session.getProvider(EventStoreProvider.class);
        EventQuery query = eventStore.createQuery().realm(this.realm.getId());
        if (client != null) {
            query.client(client);
        }
        if (type != null) {
            query.type(new EventType[]{EventType.valueOf((String)type)});
        }
        if (user != null) {
            query.user(user);
        }
        if (ipAddress != null) {
            query.ipAddress(ipAddress);
        }
        if (firstResult != null) {
            query.firstResult(firstResult.intValue());
        }
        if (maxResults != null) {
            query.maxResults(maxResults.intValue());
        }
        return query.getResultList();
    }

    @Path(value="events")
    @DELETE
    public void clearEvents() {
        this.auth.init(RealmAuth.Resource.EVENTS).requireManage();
        EventStoreProvider eventStore = (EventStoreProvider)this.session.getProvider(EventStoreProvider.class);
        eventStore.clear(this.realm.getId());
    }

    @Path(value="testLDAPConnection")
    @GET
    @NoCache
    public Response testLDAPConnection(@QueryParam(value="action") String action, @QueryParam(value="connectionUrl") String connectionUrl, @QueryParam(value="bindDn") String bindDn, @QueryParam(value="bindCredential") String bindCredential) {
        this.auth.init(RealmAuth.Resource.REALM).requireManage();
        boolean result = new LDAPConnectionTestManager().testLDAP(action, connectionUrl, bindDn, bindCredential);
        return result ? Response.noContent().build() : Flows.errors().error("LDAP test error", Response.Status.BAD_REQUEST);
    }
}

