/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.services.resources.flows;

import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriInfo;
import org.keycloak.ClientConnection;
import org.keycloak.models.ClientSessionModel;
import org.keycloak.models.RealmModel;
import org.keycloak.services.managers.ClientSessionCode;
import org.keycloak.services.resources.flows.Urls;
import org.keycloak.social.AuthRequest;
import org.keycloak.social.SocialProvider;
import org.keycloak.social.SocialProviderConfig;
import org.keycloak.social.SocialProviderException;

public class SocialRedirectFlows {
    private final RealmModel realm;
    private final UriInfo uriInfo;
    private ClientConnection clientConnection;
    private final SocialProvider socialProvider;

    SocialRedirectFlows(RealmModel realm, UriInfo uriInfo, ClientConnection clientConnection, SocialProvider provider) {
        this.realm = realm;
        this.uriInfo = uriInfo;
        this.clientConnection = clientConnection;
        this.socialProvider = provider;
    }

    public Response redirectToSocialProvider(ClientSessionCode code) throws SocialProviderException {
        code.setAction(ClientSessionModel.Action.SOCIAL_CALLBACK);
        code.getClientSession().setNote("social_provider", this.socialProvider.getId());
        String socialProviderId = this.socialProvider.getId();
        String key = (String)this.realm.getSocialConfig().get(socialProviderId + ".key");
        String secret = (String)this.realm.getSocialConfig().get(socialProviderId + ".secret");
        String callbackUri = Urls.socialCallback(this.uriInfo.getBaseUri()).toString();
        SocialProviderConfig config = new SocialProviderConfig(key, secret, callbackUri);
        AuthRequest authRequest = this.socialProvider.getAuthUrl(code.getClientSession(), config, code.getCode());
        return Response.status((int)302).location(authRequest.getAuthUri()).build();
    }
}

