/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.protocol.oidc;

import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.security.PublicKey;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Set;
import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.HeaderParam;
import javax.ws.rs.OPTIONS;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.CacheControl;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.HttpHeaders;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.SecurityContext;
import javax.ws.rs.core.UriBuilder;
import javax.ws.rs.core.UriInfo;
import javax.ws.rs.ext.Providers;
import org.jboss.logging.Logger;
import org.jboss.resteasy.annotations.cache.NoCache;
import org.jboss.resteasy.specimpl.MultivaluedMapImpl;
import org.jboss.resteasy.spi.BadRequestException;
import org.jboss.resteasy.spi.HttpRequest;
import org.jboss.resteasy.spi.HttpResponse;
import org.jboss.resteasy.spi.NotAcceptableException;
import org.jboss.resteasy.spi.NotFoundException;
import org.jboss.resteasy.spi.UnauthorizedException;
import org.keycloak.ClientConnection;
import org.keycloak.Config;
import org.keycloak.OAuthErrorException;
import org.keycloak.RSATokenVerifier;
import org.keycloak.events.EventBuilder;
import org.keycloak.events.EventType;
import org.keycloak.login.LoginFormsProvider;
import org.keycloak.models.ApplicationModel;
import org.keycloak.models.ClientModel;
import org.keycloak.models.ClientSessionModel;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.RealmModel;
import org.keycloak.models.UserModel;
import org.keycloak.models.UserSessionModel;
import org.keycloak.models.UserSessionProvider;
import org.keycloak.models.utils.KeycloakModelUtils;
import org.keycloak.protocol.oidc.OpenIDConnect;
import org.keycloak.protocol.oidc.TokenManager;
import org.keycloak.representations.AccessToken;
import org.keycloak.representations.AccessTokenResponse;
import org.keycloak.representations.RefreshToken;
import org.keycloak.services.ForbiddenException;
import org.keycloak.services.managers.AuthenticationManager;
import org.keycloak.services.managers.ClientSessionCode;
import org.keycloak.services.resources.Cors;
import org.keycloak.services.resources.RealmsResource;
import org.keycloak.services.resources.flows.Flows;
import org.keycloak.services.resources.flows.Urls;
import org.keycloak.util.BasicAuthHelper;
import org.keycloak.util.StreamUtil;
import org.keycloak.util.UriUtils;

public class OpenIDConnectService {
    protected static final Logger logger = Logger.getLogger(OpenIDConnectService.class);
    protected RealmModel realm;
    protected TokenManager tokenManager;
    private EventBuilder event;
    protected AuthenticationManager authManager;
    @Context
    protected Providers providers;
    @Context
    protected SecurityContext securityContext;
    @Context
    protected UriInfo uriInfo;
    @Context
    protected HttpHeaders headers;
    @Context
    protected HttpRequest request;
    @Context
    protected HttpResponse response;
    @Context
    protected KeycloakSession session;
    @Context
    protected ClientConnection clientConnection;

    public OpenIDConnectService(RealmModel realm, EventBuilder event, AuthenticationManager authManager) {
        this.realm = realm;
        this.tokenManager = new TokenManager();
        this.event = event;
        this.authManager = authManager;
    }

    public static UriBuilder tokenServiceBaseUrl(UriInfo uriInfo) {
        UriBuilder baseUriBuilder = uriInfo.getBaseUriBuilder();
        return OpenIDConnectService.tokenServiceBaseUrl(baseUriBuilder);
    }

    public static UriBuilder tokenServiceBaseUrl(UriBuilder baseUriBuilder) {
        return baseUriBuilder.path(RealmsResource.class).path("{realm}/protocol/openid-connect");
    }

    public static UriBuilder accessCodeToTokenUrl(UriInfo uriInfo) {
        UriBuilder baseUriBuilder = uriInfo.getBaseUriBuilder();
        return OpenIDConnectService.accessCodeToTokenUrl(baseUriBuilder);
    }

    public static UriBuilder accessCodeToTokenUrl(UriBuilder baseUriBuilder) {
        UriBuilder uriBuilder = OpenIDConnectService.tokenServiceBaseUrl(baseUriBuilder);
        return uriBuilder.path(OpenIDConnectService.class, "accessCodeToToken");
    }

    public static UriBuilder validateAccessTokenUrl(UriBuilder baseUriBuilder) {
        UriBuilder uriBuilder = OpenIDConnectService.tokenServiceBaseUrl(baseUriBuilder);
        return uriBuilder.path(OpenIDConnectService.class, "validateAccessToken");
    }

    public static UriBuilder grantAccessTokenUrl(UriInfo uriInfo) {
        UriBuilder baseUriBuilder = uriInfo.getBaseUriBuilder();
        return OpenIDConnectService.grantAccessTokenUrl(baseUriBuilder);
    }

    public static UriBuilder grantAccessTokenUrl(UriBuilder baseUriBuilder) {
        UriBuilder uriBuilder = OpenIDConnectService.tokenServiceBaseUrl(baseUriBuilder);
        return uriBuilder.path(OpenIDConnectService.class, "grantAccessToken");
    }

    public static UriBuilder loginPageUrl(UriInfo uriInfo) {
        UriBuilder baseUriBuilder = uriInfo.getBaseUriBuilder();
        return OpenIDConnectService.loginPageUrl(baseUriBuilder);
    }

    public static UriBuilder loginPageUrl(UriBuilder baseUriBuilder) {
        UriBuilder uriBuilder = OpenIDConnectService.tokenServiceBaseUrl(baseUriBuilder);
        return uriBuilder.path(OpenIDConnectService.class, "loginPage");
    }

    public static UriBuilder logoutUrl(UriInfo uriInfo) {
        UriBuilder baseUriBuilder = uriInfo.getBaseUriBuilder();
        return OpenIDConnectService.logoutUrl(baseUriBuilder);
    }

    public static UriBuilder logoutUrl(UriBuilder baseUriBuilder) {
        UriBuilder uriBuilder = OpenIDConnectService.tokenServiceBaseUrl(baseUriBuilder);
        return uriBuilder.path(OpenIDConnectService.class, "logout");
    }

    public static UriBuilder refreshUrl(UriBuilder baseUriBuilder) {
        UriBuilder uriBuilder = OpenIDConnectService.tokenServiceBaseUrl(baseUriBuilder);
        return uriBuilder.path(OpenIDConnectService.class, "refreshAccessToken");
    }

    @Path(value="login-status-iframe.html")
    @GET
    @Produces(value={"text/html"})
    public Response getLoginStatusIframe(@QueryParam(value="client_id") String client_id, @QueryParam(value="origin") String origin) {
        if (!UriUtils.isOrigin((String)origin)) {
            throw new BadRequestException("Invalid origin");
        }
        ClientModel client = this.realm.findClient(client_id);
        if (client == null) {
            throw new NotFoundException("could not find client: " + client_id);
        }
        InputStream is = this.getClass().getClassLoader().getResourceAsStream("login-status-iframe.html");
        if (is == null) {
            throw new NotFoundException("Could not find login-status-iframe.html ");
        }
        boolean valid = false;
        for (String o : client.getWebOrigins()) {
            if (!o.equals("*") && !o.equals(origin)) continue;
            valid = true;
            break;
        }
        for (String r : OpenIDConnectService.resolveValidRedirects(this.uriInfo, client.getRedirectUris())) {
            int i = r.indexOf(47, 8);
            if (i != -1) {
                r = r.substring(0, i);
            }
            if (!r.equals(origin)) continue;
            valid = true;
            break;
        }
        if (!valid) {
            throw new BadRequestException("Invalid origin");
        }
        try {
            String file = StreamUtil.readString((InputStream)is);
            file = file.replace("ORIGIN", origin);
            CacheControl cacheControl = new CacheControl();
            cacheControl.setNoTransform(false);
            cacheControl.setMaxAge(Config.scope((String[])new String[]{"theme"}).getInt("staticMaxAge", Integer.valueOf(-1)).intValue());
            return Response.ok((Object)file).cacheControl(cacheControl).build();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Path(value="grants/access")
    @POST
    @Consumes(value={"application/x-www-form-urlencoded"})
    @Produces(value={"application/json"})
    public Response grantAccessToken(@HeaderParam(value="Authorization") String authorizationHeader, MultivaluedMap<String, String> form) {
        if (!this.checkSsl()) {
            return this.createError("https_required", "HTTPS required", Response.Status.FORBIDDEN);
        }
        if (!this.realm.isPasswordCredentialGrantAllowed()) {
            return this.createError("not_enabled", "Direct Grant REST API not enabled", Response.Status.FORBIDDEN);
        }
        this.event.event(EventType.LOGIN).detail("auth_method", "oauth_credentials").detail("response_type", "token");
        String username = (String)form.getFirst((Object)"username");
        if (username == null) {
            this.event.error("username_missing");
            throw new UnauthorizedException("No username");
        }
        this.event.detail("username", username);
        UserModel user = KeycloakModelUtils.findUserByNameOrEmail((KeycloakSession)this.session, (RealmModel)this.realm, (String)username);
        if (user != null) {
            this.event.user(user);
        }
        ClientModel client = this.authorizeClient(authorizationHeader, form, this.event);
        if (!this.realm.isEnabled()) {
            this.event.error("realm_disabled");
            return this.createError("realm_disabled", "Realm is disabled", Response.Status.UNAUTHORIZED);
        }
        AuthenticationManager.AuthenticationStatus authenticationStatus = this.authManager.authenticateForm(this.session, this.clientConnection, this.realm, form);
        switch (authenticationStatus) {
            case SUCCESS: {
                break;
            }
            case ACCOUNT_TEMPORARILY_DISABLED: 
            case ACTIONS_REQUIRED: {
                HashMap<String, String> err = new HashMap<String, String>();
                err.put("error", "invalid_grant");
                err.put("error_description", "AccountProvider temporarily disabled");
                this.event.error("user_temporarily_disabled");
                return Response.status((Response.Status)Response.Status.BAD_REQUEST).type(MediaType.APPLICATION_JSON_TYPE).entity(err).build();
            }
            case ACCOUNT_DISABLED: {
                HashMap<String, String> err = new HashMap<String, String>();
                err.put("error", "invalid_grant");
                err.put("error_description", "AccountProvider disabled");
                this.event.error("user_disabled");
                return Response.status((Response.Status)Response.Status.BAD_REQUEST).type(MediaType.APPLICATION_JSON_TYPE).entity(err).build();
            }
            default: {
                HashMap<String, String> err = new HashMap<String, String>();
                err.put("error", "invalid_grant");
                err.put("error_description", "Invalid user credentials");
                this.event.error("invalid_user_credentials");
                return Response.status((Response.Status)Response.Status.BAD_REQUEST).type(MediaType.APPLICATION_JSON_TYPE).entity(err).build();
            }
        }
        String scope = (String)form.getFirst((Object)"scope");
        UserSessionProvider sessions = this.session.sessions();
        UserSessionModel userSession = sessions.createUserSession(this.realm, user, username, this.clientConnection.getRemoteAddr(), "oauth_credentials", false);
        this.event.session(userSession);
        ClientSessionModel clientSession = sessions.createClientSession(this.realm, client);
        clientSession.setAuthMethod("openid-connect");
        TokenManager.attachClientSession(userSession, clientSession);
        AccessTokenResponse res = this.tokenManager.responseBuilder(this.realm, client, this.event).generateAccessToken(scope, client, user, userSession).generateRefreshToken().generateIDToken().build();
        this.event.success();
        return Response.ok((Object)res, (MediaType)MediaType.APPLICATION_JSON_TYPE).build();
    }

    @Path(value="validate")
    @GET
    @NoCache
    @Produces(value={"application/json"})
    public Response validateAccessToken(@QueryParam(value="access_token") String tokenString) {
        if (!this.checkSsl()) {
            return this.createError("https_required", "HTTPS required", Response.Status.FORBIDDEN);
        }
        this.event.event(EventType.VALIDATE_ACCESS_TOKEN);
        AccessToken token = null;
        try {
            token = RSATokenVerifier.verifyToken((String)tokenString, (PublicKey)this.realm.getPublicKey(), (String)this.realm.getName());
        }
        catch (Exception e) {
            HashMap<String, String> err = new HashMap<String, String>();
            err.put("error", "invalid_grant");
            err.put("error_description", "Token invalid");
            this.event.error("invalid_token");
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).type(MediaType.APPLICATION_JSON_TYPE).entity(err).build();
        }
        this.event.user(token.getSubject()).session(token.getSessionState()).detail("validate_access_token", token.getId());
        if (token.isExpired() || token.getIssuedAt() < this.realm.getNotBefore()) {
            HashMap<String, String> err = new HashMap<String, String>();
            err.put("error", "invalid_grant");
            err.put("error_description", "Token expired");
            this.event.error("invalid_token");
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).type(MediaType.APPLICATION_JSON_TYPE).entity(err).build();
        }
        UserModel user = this.session.users().getUserById(token.getSubject(), this.realm);
        if (user == null) {
            HashMap<String, String> err = new HashMap<String, String>();
            err.put("error", "invalid_grant");
            err.put("error_description", "User does not exist");
            this.event.error("user_not_found");
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).type(MediaType.APPLICATION_JSON_TYPE).entity(err).build();
        }
        if (!user.isEnabled()) {
            HashMap<String, String> err = new HashMap<String, String>();
            err.put("error", "invalid_grant");
            err.put("error_description", "User disabled");
            this.event.error("user_disabled");
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).type(MediaType.APPLICATION_JSON_TYPE).entity(err).build();
        }
        UserSessionModel userSession = this.session.sessions().getUserSession(this.realm, token.getSessionState());
        if (!AuthenticationManager.isSessionValid(this.realm, userSession)) {
            HashMap<String, String> err = new HashMap<String, String>();
            err.put("error", "invalid_grant");
            err.put("error_description", "Expired session");
            this.event.error("user_session_not_found");
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).type(MediaType.APPLICATION_JSON_TYPE).entity(err).build();
        }
        ClientModel client = this.realm.findClient(token.getIssuedFor());
        if (client == null) {
            HashMap<String, String> err = new HashMap<String, String>();
            err.put("error", "invalid_client");
            err.put("error_description", "Issued for client no longer exists");
            this.event.error("client_not_found");
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).type(MediaType.APPLICATION_JSON_TYPE).entity(err).build();
        }
        if (token.getIssuedAt() < client.getNotBefore()) {
            HashMap<String, String> err = new HashMap<String, String>();
            err.put("error", "invalid_client");
            err.put("error_description", "Issued for client no longer exists");
            this.event.error("invalid_token");
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).type(MediaType.APPLICATION_JSON_TYPE).entity(err).build();
        }
        try {
            this.tokenManager.verifyAccess(token, this.realm, client, user);
        }
        catch (OAuthErrorException e) {
            HashMap<String, String> err = new HashMap<String, String>();
            err.put("error", "invalid_grant");
            err.put("error_description", "Role mappings have changed");
            this.event.error("invalid_token");
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).type(MediaType.APPLICATION_JSON_TYPE).entity(err).build();
        }
        this.event.success();
        return Response.ok((Object)token, (MediaType)MediaType.APPLICATION_JSON_TYPE).build();
    }

    @Path(value="refresh")
    @OPTIONS
    @Produces(value={"application/json"})
    public Response refreshAccessTokenPreflight() {
        if (logger.isDebugEnabled()) {
            logger.debugv("cors request from: {0}", this.request.getHttpHeaders().getRequestHeaders().getFirst((Object)"Origin"));
        }
        return Cors.add(this.request, Response.ok()).auth().preflight().build();
    }

    @Path(value="refresh")
    @POST
    @Consumes(value={"application/x-www-form-urlencoded"})
    @Produces(value={"application/json"})
    public Response refreshAccessToken(@HeaderParam(value="Authorization") String authorizationHeader, MultivaluedMap<String, String> form) {
        AccessToken accessToken;
        if (!this.checkSsl()) {
            return this.createError("https_required", "HTTPS required", Response.Status.FORBIDDEN);
        }
        this.event.event(EventType.REFRESH_TOKEN);
        ClientModel client = this.authorizeClient(authorizationHeader, form, this.event);
        String refreshToken = (String)form.getFirst((Object)"refresh_token");
        if (refreshToken == null) {
            HashMap<String, String> error = new HashMap<String, String>();
            error.put("error", "invalid_request");
            error.put("error_description", "No refresh token");
            this.event.error("invalid_token");
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity(error).type("application/json").build();
        }
        try {
            accessToken = this.tokenManager.refreshAccessToken(this.session, this.uriInfo, this.clientConnection, this.realm, client, refreshToken, this.event);
        }
        catch (OAuthErrorException e) {
            HashMap<String, String> error = new HashMap<String, String>();
            error.put("error", e.getError());
            if (e.getDescription() != null) {
                error.put("error_description", e.getDescription());
            }
            this.event.error("invalid_token");
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity(error).type("application/json").build();
        }
        AccessTokenResponse res = this.tokenManager.responseBuilder(this.realm, client, this.event).accessToken(accessToken).generateIDToken().generateRefreshToken().build();
        this.event.success();
        return Cors.add(this.request, Response.ok((Object)res, (MediaType)MediaType.APPLICATION_JSON_TYPE)).auth().allowedOrigins(client).allowedMethods("POST").exposedHeaders("Access-Control-Allow-Methods").build();
    }

    @Path(value="access/codes")
    @OPTIONS
    @Produces(value={"application/json"})
    public Response accessCodeToTokenPreflight() {
        if (logger.isDebugEnabled()) {
            logger.debugv("cors request from: {0}", this.request.getHttpHeaders().getRequestHeaders().getFirst((Object)"Origin"));
        }
        return Cors.add(this.request, Response.ok()).auth().preflight().build();
    }

    @Path(value="access/codes")
    @POST
    @Produces(value={"application/json"})
    public Response accessCodeToToken(@HeaderParam(value="Authorization") String authorizationHeader, MultivaluedMap<String, String> formData) {
        if (!this.checkSsl()) {
            throw new ForbiddenException("HTTPS required");
        }
        this.event.event(EventType.CODE_TO_TOKEN);
        if (!this.realm.isEnabled()) {
            this.event.error("realm_disabled");
            throw new UnauthorizedException("Realm not enabled");
        }
        String code = (String)formData.getFirst((Object)"code");
        if (code == null) {
            HashMap<String, String> error = new HashMap<String, String>();
            error.put("error", "invalid_request");
            error.put("error_description", "code not specified");
            this.event.error("invalid_code");
            throw new BadRequestException("Code not specified", Response.status((Response.Status)Response.Status.BAD_REQUEST).entity(error).type("application/json").build());
        }
        ClientSessionCode accessCode = ClientSessionCode.parse(code, this.session, this.realm);
        if (accessCode == null) {
            String[] parts = code.split("\\.");
            if (parts.length == 2) {
                try {
                    this.event.detail("code_id", new String(parts[1]));
                }
                catch (Throwable t) {
                    // empty catch block
                }
            }
            HashMap<String, String> res = new HashMap<String, String>();
            res.put("error", "invalid_grant");
            res.put("error_description", "Code not found");
            this.event.error("invalid_code");
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).type(MediaType.APPLICATION_JSON_TYPE).entity(res).build();
        }
        ClientSessionModel clientSession = accessCode.getClientSession();
        this.event.detail("code_id", clientSession.getId());
        if (!accessCode.isValid(ClientSessionModel.Action.CODE_TO_TOKEN)) {
            HashMap<String, String> res = new HashMap<String, String>();
            res.put("error", "invalid_grant");
            res.put("error_description", "Code is expired");
            this.event.error("invalid_code");
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).type(MediaType.APPLICATION_JSON_TYPE).entity(res).build();
        }
        accessCode.setAction(null);
        UserSessionModel userSession = clientSession.getUserSession();
        this.event.user(userSession.getUser());
        this.event.session(userSession.getId());
        ClientModel client = this.authorizeClient(authorizationHeader, formData, this.event);
        String redirectUri = clientSession.getNote("redirect_uri");
        if (redirectUri != null && !redirectUri.equals(formData.getFirst((Object)"redirect_uri"))) {
            HashMap<String, String> res = new HashMap<String, String>();
            res.put("error", "invalid_grant");
            res.put("error_description", "Incorrect redirect_uri");
            this.event.error("invalid_code");
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).type(MediaType.APPLICATION_JSON_TYPE).entity(res).build();
        }
        if (!client.getClientId().equals(clientSession.getClient().getClientId())) {
            HashMap<String, String> res = new HashMap<String, String>();
            res.put("error", "invalid_grant");
            res.put("error_description", "Auth error");
            this.event.error("invalid_code");
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).type(MediaType.APPLICATION_JSON_TYPE).entity(res).build();
        }
        UserModel user = this.session.users().getUserById(userSession.getUser().getId(), this.realm);
        if (user == null) {
            HashMap<String, String> res = new HashMap<String, String>();
            res.put("error", "invalid_grant");
            res.put("error_description", "User not found");
            this.event.error("invalid_code");
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).type(MediaType.APPLICATION_JSON_TYPE).entity(res).build();
        }
        if (!user.isEnabled()) {
            HashMap<String, String> res = new HashMap<String, String>();
            res.put("error", "invalid_grant");
            res.put("error_description", "User disabled");
            this.event.error("invalid_code");
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).type(MediaType.APPLICATION_JSON_TYPE).entity(res).build();
        }
        if (!AuthenticationManager.isSessionValid(this.realm, userSession)) {
            AuthenticationManager.logout(this.session, this.realm, userSession, this.uriInfo, this.clientConnection);
            HashMap<String, String> res = new HashMap<String, String>();
            res.put("error", "invalid_grant");
            res.put("error_description", "Session not active");
            this.event.error("invalid_code");
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).type(MediaType.APPLICATION_JSON_TYPE).entity(res).build();
        }
        String adapterSessionId = (String)formData.getFirst((Object)"application_session_state");
        if (adapterSessionId != null) {
            String adapterSessionHost = (String)formData.getFirst((Object)"application_session_host");
            logger.debugf("Adapter Session '%s' saved in ClientSession for client '%s'. Host is '%s'", (Object)adapterSessionId, (Object)client.getClientId(), (Object)adapterSessionHost);
            this.event.detail("application_session_state", adapterSessionId);
            clientSession.setNote("application_session_state", adapterSessionId);
            this.event.detail("application_session_host", adapterSessionHost);
            clientSession.setNote("application_session_host", adapterSessionHost);
        }
        AccessToken token = this.tokenManager.createClientAccessToken(accessCode.getRequestedRoles(), this.realm, client, user, userSession);
        try {
            this.tokenManager.verifyAccess(token, this.realm, client, user);
        }
        catch (OAuthErrorException e) {
            HashMap<String, String> error = new HashMap<String, String>();
            error.put("error", e.getError());
            if (e.getDescription() != null) {
                error.put("error_description", e.getDescription());
            }
            this.event.error("invalid_code");
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity(error).type("application/json").build();
        }
        AccessTokenResponse res = this.tokenManager.responseBuilder(this.realm, client, this.event).accessToken(token).generateIDToken().generateRefreshToken().build();
        this.event.success();
        return Cors.add(this.request, Response.ok((Object)res)).auth().allowedOrigins(client).allowedMethods("POST").exposedHeaders("Access-Control-Allow-Methods").build();
    }

    protected ClientModel authorizeClient(String authorizationHeader, MultivaluedMap<String, String> formData, EventBuilder event) {
        ClientModel client = OpenIDConnectService.authorizeClientBase(authorizationHeader, formData, event, this.realm);
        if (client instanceof ApplicationModel && ((ApplicationModel)client).isBearerOnly()) {
            HashMap<String, String> error = new HashMap<String, String>();
            error.put("error", "invalid_client");
            error.put("error_description", "Bearer-only not allowed");
            event.error("invalid_client");
            throw new BadRequestException("Bearer-only not allowed", Response.status((Response.Status)Response.Status.BAD_REQUEST).entity(error).type("application/json").build());
        }
        return client;
    }

    public static ClientModel authorizeClientBase(String authorizationHeader, MultivaluedMap<String, String> formData, EventBuilder event, RealmModel realm) {
        String clientSecret;
        String client_id;
        if (authorizationHeader != null) {
            String[] usernameSecret = BasicAuthHelper.parseHeader((String)authorizationHeader);
            if (usernameSecret == null) {
                throw new UnauthorizedException("Bad Authorization header", Response.status((int)401).header("WWW-Authenticate", (Object)("Basic realm=\"" + realm.getName() + "\"")).build());
            }
            client_id = usernameSecret[0];
            clientSecret = usernameSecret[1];
        } else {
            client_id = (String)formData.getFirst((Object)"client_id");
            clientSecret = (String)formData.getFirst((Object)"client_secret");
        }
        if (client_id == null) {
            HashMap<String, String> error = new HashMap<String, String>();
            error.put("error", "invalid_client");
            error.put("error_description", "Could not find client");
            throw new BadRequestException("Could not find client", Response.status((Response.Status)Response.Status.BAD_REQUEST).entity(error).type("application/json").build());
        }
        event.client(client_id);
        ClientModel client = realm.findClient(client_id);
        if (client == null) {
            HashMap<String, String> error = new HashMap<String, String>();
            error.put("error", "invalid_client");
            error.put("error_description", "Could not find client");
            event.error("client_not_found");
            throw new BadRequestException("Could not find client", Response.status((Response.Status)Response.Status.BAD_REQUEST).entity(error).type("application/json").build());
        }
        if (!client.isEnabled()) {
            HashMap<String, String> error = new HashMap<String, String>();
            error.put("error", "invalid_client");
            error.put("error_description", "Client is not enabled");
            event.error("client_disabled");
            throw new BadRequestException("Client is not enabled", Response.status((Response.Status)Response.Status.BAD_REQUEST).entity(error).type("application/json").build());
        }
        if (!(client.isPublicClient() || clientSecret != null && client.validateSecret(clientSecret))) {
            HashMap<String, String> error = new HashMap<String, String>();
            error.put("error", "unauthorized_client");
            event.error("invalid_client_credentials");
            throw new BadRequestException("Unauthorized Client", Response.status((Response.Status)Response.Status.BAD_REQUEST).entity(error).type("application/json").build());
        }
        return client;
    }

    @Path(value="login")
    @GET
    public Response loginPage(@QueryParam(value="response_type") String responseType, @QueryParam(value="redirect_uri") String redirect, @QueryParam(value="client_id") String clientId, @QueryParam(value="scope") String scopeParam, @QueryParam(value="state") String state, @QueryParam(value="prompt") String prompt, @QueryParam(value="login_hint") String loginHint) {
        this.event.event(EventType.LOGIN);
        FrontPageInitializer pageInitializer = new FrontPageInitializer();
        pageInitializer.responseType = responseType;
        pageInitializer.redirect = redirect;
        pageInitializer.clientId = clientId;
        pageInitializer.scopeParam = scopeParam;
        pageInitializer.state = state;
        pageInitializer.prompt = prompt;
        pageInitializer.loginHint = loginHint;
        Response response = pageInitializer.processInput();
        if (response != null) {
            return response;
        }
        ClientSessionModel clientSession = pageInitializer.clientSession;
        response = this.authManager.checkNonFormAuthentication(this.session, clientSession, this.realm, this.uriInfo, this.request, this.clientConnection, this.headers, this.event);
        if (response != null) {
            return response;
        }
        if (prompt != null && prompt.equals("none")) {
            OpenIDConnect oauth = new OpenIDConnect(this.session, this.realm, this.uriInfo);
            return oauth.cancelLogin(clientSession);
        }
        LoginFormsProvider forms = Flows.forms(this.session, this.realm, clientSession.getClient(), this.uriInfo).setClientSessionCode(new ClientSessionCode(this.realm, clientSession).getCode());
        String rememberMeUsername = AuthenticationManager.getRememberMeUsername(this.realm, this.headers);
        if (loginHint != null || rememberMeUsername != null) {
            MultivaluedMapImpl formData = new MultivaluedMapImpl();
            if (loginHint != null) {
                formData.add((Object)"username", (Object)loginHint);
            } else {
                formData.add((Object)"username", (Object)rememberMeUsername);
                formData.add((Object)"rememberMe", (Object)"on");
            }
            forms.setFormData((MultivaluedMap)formData);
        }
        return forms.createLogin();
    }

    @Path(value="registrations")
    @GET
    public Response registerPage(@QueryParam(value="response_type") String responseType, @QueryParam(value="redirect_uri") String redirect, @QueryParam(value="client_id") String clientId, @QueryParam(value="scope") String scopeParam, @QueryParam(value="state") String state) {
        this.event.event(EventType.REGISTER);
        if (!this.realm.isRegistrationAllowed()) {
            this.event.error("registration_disabled");
            return Flows.forwardToSecurityFailurePage(this.session, this.realm, this.uriInfo, "Registration not allowed");
        }
        FrontPageInitializer pageInitializer = new FrontPageInitializer();
        pageInitializer.responseType = responseType;
        pageInitializer.redirect = redirect;
        pageInitializer.clientId = clientId;
        pageInitializer.scopeParam = scopeParam;
        pageInitializer.state = state;
        Response response = pageInitializer.processInput();
        if (response != null) {
            return response;
        }
        ClientSessionModel clientSession = pageInitializer.clientSession;
        AuthenticationManager.expireIdentityCookie(this.realm, this.uriInfo, this.clientConnection);
        return Flows.forms(this.session, this.realm, clientSession.getClient(), this.uriInfo).setClientSessionCode(new ClientSessionCode(this.realm, clientSession).getCode()).createRegistration();
    }

    @Path(value="logout")
    @GET
    @NoCache
    public Response logout(@QueryParam(value="redirect_uri") String redirectUri) {
        AuthenticationManager.AuthResult authResult;
        this.event.event(EventType.LOGOUT);
        if (redirectUri != null) {
            this.event.detail("redirect_uri", redirectUri);
        }
        if ((authResult = this.authManager.authenticateIdentityCookie(this.session, this.realm, this.uriInfo, this.clientConnection, this.headers, false)) != null) {
            this.logout(authResult.getSession());
        }
        if (redirectUri != null) {
            String validatedRedirect = OpenIDConnectService.verifyRealmRedirectUri(this.uriInfo, redirectUri, this.realm);
            if (validatedRedirect == null) {
                return Flows.forwardToSecurityFailurePage(this.session, this.realm, this.uriInfo, "Invalid redirect uri.");
            }
            return Response.status((int)302).location(UriBuilder.fromUri((String)validatedRedirect).build(new Object[0])).build();
        }
        return Response.ok().build();
    }

    @Path(value="logout")
    @POST
    @Consumes(value={"application/x-www-form-urlencoded"})
    public Response logoutToken(@HeaderParam(value="Authorization") String authorizationHeader, MultivaluedMap<String, String> form) {
        if (!this.checkSsl()) {
            throw new NotAcceptableException("HTTPS required");
        }
        this.event.event(EventType.LOGOUT);
        ClientModel client = this.authorizeClient(authorizationHeader, form, this.event);
        String refreshToken = (String)form.getFirst((Object)"refresh_token");
        if (refreshToken == null) {
            HashMap<String, String> error = new HashMap<String, String>();
            error.put("error", "invalid_request");
            error.put("error_description", "No refresh token");
            this.event.error("invalid_token");
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity(error).type("application/json").build();
        }
        try {
            RefreshToken token = this.tokenManager.verifyRefreshToken(this.realm, refreshToken);
            UserSessionModel userSessionModel = this.session.sessions().getUserSession(this.realm, token.getSessionState());
            if (userSessionModel != null) {
                this.logout(userSessionModel);
            }
        }
        catch (OAuthErrorException e) {
            HashMap<String, String> error = new HashMap<String, String>();
            error.put("error", e.getError());
            if (e.getDescription() != null) {
                error.put("error_description", e.getDescription());
            }
            this.event.error("invalid_token");
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity(error).type("application/json").build();
        }
        return Cors.add(this.request, Response.noContent()).auth().allowedOrigins(client).allowedMethods("POST").exposedHeaders("Access-Control-Allow-Methods").build();
    }

    private void logout(UserSessionModel userSession) {
        AuthenticationManager.logout(this.session, this.realm, userSession, this.uriInfo, this.clientConnection);
        this.event.user(userSession.getUser()).session(userSession).success();
    }

    @Path(value="oauth/oob")
    @GET
    public Response installedAppUrnCallback(@QueryParam(value="code") String code, @QueryParam(value="error") String error, @QueryParam(value="error_description") String errorDescription) {
        LoginFormsProvider forms = Flows.forms(this.session, this.realm, null, this.uriInfo);
        if (code != null) {
            return forms.setClientSessionCode(code).createCode();
        }
        return forms.setError(error).createCode();
    }

    public static boolean matchesRedirects(Set<String> validRedirects, String redirect) {
        for (String validRedirect : validRedirects) {
            if (validRedirect.endsWith("*")) {
                int length = validRedirect.length() - 1;
                if (redirect.startsWith(validRedirect = validRedirect.substring(0, length))) {
                    return true;
                }
                if (length - 1 > 0 && validRedirect.charAt(length - 1) == '/') {
                    --length;
                }
                if (!(validRedirect = validRedirect.substring(0, length)).equals(redirect)) continue;
                return true;
            }
            if (!validRedirect.equals(redirect)) continue;
            return true;
        }
        return false;
    }

    public static Set<String> getValidateRedirectUris(RealmModel realm) {
        HashSet<String> redirects = new HashSet<String>();
        for (ApplicationModel client : realm.getApplications()) {
            for (String redirect : client.getRedirectUris()) {
                redirects.add(redirect);
            }
        }
        for (ApplicationModel client : realm.getOAuthClients()) {
            for (String redirect : client.getRedirectUris()) {
                redirects.add(redirect);
            }
        }
        return redirects;
    }

    public static String verifyRealmRedirectUri(UriInfo uriInfo, String redirectUri, RealmModel realm) {
        Set<String> validRedirects = OpenIDConnectService.getValidateRedirectUris(realm);
        return OpenIDConnectService.verifyRedirectUri(uriInfo, redirectUri, realm, validRedirects);
    }

    public static String verifyRedirectUri(UriInfo uriInfo, String redirectUri, RealmModel realm, ClientModel client) {
        Set validRedirects = client.getRedirectUris();
        return OpenIDConnectService.verifyRedirectUri(uriInfo, redirectUri, realm, validRedirects);
    }

    public static String verifyRedirectUri(UriInfo uriInfo, String redirectUri, RealmModel realm, Set<String> validRedirects) {
        if (redirectUri == null) {
            if (validRedirects.size() != 1) {
                return null;
            }
            String validRedirect = validRedirects.iterator().next();
            int idx = validRedirect.indexOf("/*");
            if (idx > -1) {
                validRedirect = validRedirect.substring(0, idx);
            }
            redirectUri = validRedirect;
        } else if (validRedirects.isEmpty()) {
            logger.debug((Object)"No Redirect URIs supplied");
            redirectUri = null;
        } else {
            String r = redirectUri.indexOf(63) != -1 ? redirectUri.substring(0, redirectUri.indexOf(63)) : redirectUri;
            Set<String> resolveValidRedirects = OpenIDConnectService.resolveValidRedirects(uriInfo, validRedirects);
            boolean valid = OpenIDConnectService.matchesRedirects(resolveValidRedirects, r);
            if (!valid && r.startsWith("http://localhost") && r.indexOf(58, "http://localhost".length()) >= 0) {
                int i = r.indexOf(58, "http://localhost".length());
                StringBuilder sb = new StringBuilder();
                sb.append(r.substring(0, i));
                i = r.indexOf(47, i);
                if (i >= 0) {
                    sb.append(r.substring(i));
                }
                r = sb.toString();
                valid = OpenIDConnectService.matchesRedirects(resolveValidRedirects, r);
            }
            if (valid && redirectUri.startsWith("/")) {
                redirectUri = OpenIDConnectService.relativeToAbsoluteURI(uriInfo, redirectUri);
            }
            String string = redirectUri = valid ? redirectUri : null;
        }
        if ("urn:ietf:wg:oauth:2.0:oob".equals(redirectUri)) {
            return Urls.realmInstalledAppUrnCallback(uriInfo.getBaseUri(), realm.getName()).toString();
        }
        return redirectUri;
    }

    public static Set<String> resolveValidRedirects(UriInfo uriInfo, Set<String> validRedirects) {
        HashSet<String> resolveValidRedirects = new HashSet<String>();
        for (String validRedirect : validRedirects) {
            resolveValidRedirects.add(validRedirect);
            if (!validRedirect.startsWith("/")) continue;
            validRedirect = OpenIDConnectService.relativeToAbsoluteURI(uriInfo, validRedirect);
            logger.debugv("replacing relative valid redirect with: {0}", (Object)validRedirect);
            resolveValidRedirects.add(validRedirect);
        }
        return resolveValidRedirects;
    }

    public static String relativeToAbsoluteURI(UriInfo uriInfo, String relative) {
        URI baseUri = uriInfo.getBaseUri();
        String uri = baseUri.getScheme() + "://" + baseUri.getHost();
        if (baseUri.getPort() != -1) {
            uri = uri + ":" + baseUri.getPort();
        }
        relative = uri + relative;
        return relative;
    }

    private boolean checkSsl() {
        if (this.uriInfo.getBaseUri().getScheme().equals("https")) {
            return true;
        }
        return !this.realm.getSslRequired().isRequired(this.clientConnection);
    }

    private Response createError(String error, String errorDescription, Response.Status status) {
        HashMap<String, String> e = new HashMap<String, String>();
        e.put("error", error);
        if (errorDescription != null) {
            e.put("error_description", errorDescription);
        }
        return Response.status((Response.Status)status).entity(e).type("application/json").build();
    }

    private class FrontPageInitializer {
        protected String clientId;
        protected String redirect;
        protected String state;
        protected String scopeParam;
        protected String responseType;
        protected String loginHint;
        protected String prompt;
        protected ClientSessionModel clientSession;

        private FrontPageInitializer() {
        }

        public Response processInput() {
            OpenIDConnectService.this.event.client(this.clientId).detail("redirect_uri", this.redirect).detail("response_type", "code");
            if (!OpenIDConnectService.this.checkSsl()) {
                OpenIDConnectService.this.event.error("ssl_required");
                return Flows.forwardToSecurityFailurePage(OpenIDConnectService.this.session, OpenIDConnectService.this.realm, OpenIDConnectService.this.uriInfo, "HTTPS required");
            }
            if (!OpenIDConnectService.this.realm.isEnabled()) {
                OpenIDConnectService.this.event.error("realm_disabled");
                return Flows.forwardToSecurityFailurePage(OpenIDConnectService.this.session, OpenIDConnectService.this.realm, OpenIDConnectService.this.uriInfo, "Realm not enabled");
            }
            this.clientSession = null;
            ClientModel client = OpenIDConnectService.this.realm.findClient(this.clientId);
            if (client == null) {
                OpenIDConnectService.this.event.error("client_not_found");
                return Flows.forwardToSecurityFailurePage(OpenIDConnectService.this.session, OpenIDConnectService.this.realm, OpenIDConnectService.this.uriInfo, "Unknown login requester.");
            }
            if (!client.isEnabled()) {
                OpenIDConnectService.this.event.error("client_disabled");
                return Flows.forwardToSecurityFailurePage(OpenIDConnectService.this.session, OpenIDConnectService.this.realm, OpenIDConnectService.this.uriInfo, "Login requester not enabled.");
            }
            if (client instanceof ApplicationModel && ((ApplicationModel)client).isBearerOnly()) {
                OpenIDConnectService.this.event.error("not_allowed");
                return Flows.forwardToSecurityFailurePage(OpenIDConnectService.this.session, OpenIDConnectService.this.realm, OpenIDConnectService.this.uriInfo, "Bearer-only applications are not allowed to initiate browser login");
            }
            if (client.isDirectGrantsOnly()) {
                OpenIDConnectService.this.event.error("not_allowed");
                return Flows.forwardToSecurityFailurePage(OpenIDConnectService.this.session, OpenIDConnectService.this.realm, OpenIDConnectService.this.uriInfo, "direct-grants-only clients are not allowed to initiate browser login");
            }
            String redirectUriParam = this.redirect;
            this.redirect = OpenIDConnectService.verifyRedirectUri(OpenIDConnectService.this.uriInfo, this.redirect, OpenIDConnectService.this.realm, client);
            if (this.redirect == null) {
                OpenIDConnectService.this.event.error("invalid_redirect_uri");
                return Flows.forwardToSecurityFailurePage(OpenIDConnectService.this.session, OpenIDConnectService.this.realm, OpenIDConnectService.this.uriInfo, "Invalid redirect_uri.");
            }
            this.clientSession = OpenIDConnectService.this.session.sessions().createClientSession(OpenIDConnectService.this.realm, client);
            this.clientSession.setAuthMethod("openid-connect");
            this.clientSession.setRedirectUri(this.redirect);
            this.clientSession.setAction(ClientSessionModel.Action.AUTHENTICATE);
            this.clientSession.setNote("action_key", KeycloakModelUtils.generateCodeSecret());
            this.clientSession.setNote("state", this.state);
            this.clientSession.setNote("redirect_uri", redirectUriParam);
            if (this.scopeParam != null) {
                this.clientSession.setNote("scope", this.scopeParam);
            }
            if (this.responseType != null) {
                this.clientSession.setNote("response_type", this.responseType);
            }
            if (this.loginHint != null) {
                this.clientSession.setNote("login_hint", this.loginHint);
            }
            if (this.prompt != null) {
                this.clientSession.setNote("prompt", this.prompt);
            }
            return null;
        }
    }
}

