/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.services.managers;

import java.util.LinkedList;
import org.jboss.logging.Logger;
import org.keycloak.ClientConnection;
import org.keycloak.events.EventBuilder;
import org.keycloak.events.EventListenerProvider;
import org.keycloak.events.EventStoreProvider;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.RealmModel;

public class EventsManager {
    private Logger log = Logger.getLogger(EventsManager.class);
    private RealmModel realm;
    private KeycloakSession session;
    private ClientConnection clientConnection;

    public EventsManager(RealmModel realm, KeycloakSession session, ClientConnection clientConnection) {
        this.realm = realm;
        this.session = session;
        this.clientConnection = clientConnection;
    }

    public EventBuilder createEventBuilder() {
        LinkedList<Object> listeners = new LinkedList<Object>();
        if (this.realm.isEventsEnabled()) {
            EventStoreProvider eventStore = (EventStoreProvider)this.session.getProvider(EventStoreProvider.class);
            if (eventStore != null) {
                listeners.add(eventStore);
            } else {
                this.log.error((Object)"Events enabled, but no event store provider configured");
            }
        }
        if (this.realm.getEventsListeners() != null) {
            for (String id : this.realm.getEventsListeners()) {
                EventListenerProvider listener = (EventListenerProvider)this.session.getProvider(EventListenerProvider.class, id);
                if (listener != null) {
                    listeners.add(listener);
                    continue;
                }
                this.log.error((Object)("Event listener '" + id + "' registered, but provider not found"));
            }
        }
        return new EventBuilder(listeners, this.realm, this.clientConnection.getRemoteAddr());
    }
}

