/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.services.resources.admin;

import java.net.URI;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriBuilder;
import javax.ws.rs.core.UriInfo;
import org.jboss.logging.Logger;
import org.jboss.resteasy.annotations.cache.NoCache;
import org.jboss.resteasy.spi.BadRequestException;
import org.jboss.resteasy.spi.NotFoundException;
import org.keycloak.ClientConnection;
import org.keycloak.email.EmailException;
import org.keycloak.email.EmailProvider;
import org.keycloak.models.ApplicationModel;
import org.keycloak.models.ClientModel;
import org.keycloak.models.ClientSessionModel;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.ModelDuplicateException;
import org.keycloak.models.ModelReadOnlyException;
import org.keycloak.models.RealmModel;
import org.keycloak.models.RoleModel;
import org.keycloak.models.SocialLinkModel;
import org.keycloak.models.UserCredentialModel;
import org.keycloak.models.UserModel;
import org.keycloak.models.UserSessionModel;
import org.keycloak.models.utils.ModelToRepresentation;
import org.keycloak.models.utils.RepresentationToModel;
import org.keycloak.protocol.oidc.OpenIDConnectService;
import org.keycloak.protocol.oidc.TokenManager;
import org.keycloak.representations.idm.ApplicationMappingsRepresentation;
import org.keycloak.representations.idm.CredentialRepresentation;
import org.keycloak.representations.idm.MappingsRepresentation;
import org.keycloak.representations.idm.RoleRepresentation;
import org.keycloak.representations.idm.SocialLinkRepresentation;
import org.keycloak.representations.idm.UserRepresentation;
import org.keycloak.representations.idm.UserSessionRepresentation;
import org.keycloak.services.managers.ClientSessionCode;
import org.keycloak.services.managers.RealmManager;
import org.keycloak.services.managers.ResourceAdminManager;
import org.keycloak.services.managers.UserManager;
import org.keycloak.services.resources.admin.RealmAuth;
import org.keycloak.services.resources.admin.UserApplicationRoleMappingsResource;
import org.keycloak.services.resources.flows.Flows;
import org.keycloak.services.resources.flows.Urls;

public class UsersResource {
    protected static final Logger logger = Logger.getLogger(UsersResource.class);
    protected RealmModel realm;
    private RealmAuth auth;
    private TokenManager tokenManager;
    @Context
    protected ClientConnection clientConnection;
    @Context
    protected UriInfo uriInfo;
    @Context
    protected KeycloakSession session;

    public UsersResource(RealmModel realm, RealmAuth auth, TokenManager tokenManager) {
        this.auth = auth;
        this.realm = realm;
        this.tokenManager = tokenManager;
        auth.init(RealmAuth.Resource.USER);
    }

    @Path(value="{username}")
    @PUT
    @Consumes(value={"application/json"})
    public Response updateUser(@PathParam(value="username") String username, UserRepresentation rep) {
        this.auth.requireManage();
        try {
            UserModel user = this.session.users().getUserByUsername(username, this.realm);
            if (user == null) {
                throw new NotFoundException("User not found");
            }
            this.updateUserFromRep(user, rep);
            if (this.session.getTransaction().isActive()) {
                this.session.getTransaction().commit();
            }
            return Response.noContent().build();
        }
        catch (ModelDuplicateException e) {
            return Flows.errors().exists("User exists with same username or email");
        }
        catch (ModelReadOnlyException re) {
            return Flows.errors().exists("User is read only!");
        }
    }

    @POST
    @Consumes(value={"application/json"})
    public Response createUser(@Context UriInfo uriInfo, UserRepresentation rep) {
        this.auth.requireManage();
        if (this.session.users().getUserByUsername(rep.getUsername(), this.realm) != null) {
            return Flows.errors().exists("User exists with same username");
        }
        if (rep.getEmail() != null && this.session.users().getUserByEmail(rep.getEmail(), this.realm) != null) {
            return Flows.errors().exists("User exists with same email");
        }
        try {
            UserModel user = this.session.users().addUser(this.realm, rep.getUsername());
            this.updateUserFromRep(user, rep);
            if (this.session.getTransaction().isActive()) {
                this.session.getTransaction().commit();
            }
            return Response.created((URI)uriInfo.getAbsolutePathBuilder().path(user.getUsername()).build(new Object[0])).build();
        }
        catch (ModelDuplicateException e) {
            if (this.session.getTransaction().isActive()) {
                this.session.getTransaction().setRollbackOnly();
            }
            return Flows.errors().exists("User exists with same username or email");
        }
    }

    private void updateUserFromRep(UserModel user, UserRepresentation rep) {
        user.setEmail(rep.getEmail());
        user.setFirstName(rep.getFirstName());
        user.setLastName(rep.getLastName());
        user.setEnabled(rep.isEnabled());
        user.setTotp(rep.isTotp());
        user.setEmailVerified(rep.isEmailVerified());
        List reqActions = rep.getRequiredActions();
        if (reqActions != null) {
            for (UserModel.RequiredAction ra : UserModel.RequiredAction.values()) {
                if (reqActions.contains(ra.name())) {
                    user.addRequiredAction(ra);
                    continue;
                }
                user.removeRequiredAction(ra);
            }
        }
        if (rep.getAttributes() != null) {
            for (Map.Entry entry : rep.getAttributes().entrySet()) {
                user.setAttribute((String)entry.getKey(), (String)entry.getValue());
            }
            HashSet attrToRemove = new HashSet(user.getAttributes().keySet());
            attrToRemove.removeAll(rep.getAttributes().keySet());
            for (String attr : attrToRemove) {
                user.removeAttribute(attr);
            }
        }
    }

    @Path(value="{username}")
    @GET
    @NoCache
    @Produces(value={"application/json"})
    public UserRepresentation getUser(@PathParam(value="username") String username) {
        this.auth.requireView();
        UserModel user = this.session.users().getUserByUsername(username, this.realm);
        if (user == null) {
            throw new NotFoundException("User not found");
        }
        return ModelToRepresentation.toRepresentation((UserModel)user);
    }

    @Path(value="{username}/sessions")
    @GET
    @NoCache
    @Produces(value={"application/json"})
    public List<UserSessionRepresentation> getSessions(@PathParam(value="username") String username) {
        this.auth.requireView();
        UserModel user = this.session.users().getUserByUsername(username, this.realm);
        if (user == null) {
            throw new NotFoundException("User not found");
        }
        List sessions = this.session.sessions().getUserSessions(this.realm, user);
        ArrayList<UserSessionRepresentation> reps = new ArrayList<UserSessionRepresentation>();
        for (UserSessionModel session : sessions) {
            UserSessionRepresentation rep = ModelToRepresentation.toRepresentation((UserSessionModel)session);
            reps.add(rep);
        }
        return reps;
    }

    @Path(value="{username}/social-links")
    @GET
    @NoCache
    @Produces(value={"application/json"})
    public List<SocialLinkRepresentation> getSocialLinks(@PathParam(value="username") String username) {
        this.auth.requireView();
        UserModel user = this.session.users().getUserByUsername(username, this.realm);
        if (user == null) {
            throw new NotFoundException("User not found");
        }
        Set socialLinks = this.session.users().getSocialLinks(user, this.realm);
        ArrayList<SocialLinkRepresentation> result = new ArrayList<SocialLinkRepresentation>();
        for (SocialLinkModel socialLink : socialLinks) {
            SocialLinkRepresentation rep = ModelToRepresentation.toRepresentation((SocialLinkModel)socialLink);
            result.add(rep);
        }
        return result;
    }

    @Path(value="{username}/social-links/{provider}")
    @POST
    @NoCache
    public Response addSocialLink(@PathParam(value="username") String username, @PathParam(value="provider") String provider, SocialLinkRepresentation rep) {
        this.auth.requireManage();
        UserModel user = this.session.users().getUserByUsername(username, this.realm);
        if (user == null) {
            throw new NotFoundException("User not found");
        }
        if (this.session.users().getSocialLink(user, provider, this.realm) != null) {
            return Flows.errors().exists("User is already linked with provider");
        }
        SocialLinkModel socialLink = new SocialLinkModel(provider, rep.getSocialUserId(), rep.getSocialUsername());
        this.session.users().addSocialLink(this.realm, user, socialLink);
        return Response.noContent().build();
    }

    @Path(value="{username}/social-links/{provider}")
    @DELETE
    @NoCache
    public void removeSocialLink(@PathParam(value="username") String username, @PathParam(value="provider") String provider) {
        this.auth.requireManage();
        UserModel user = this.session.users().getUserByUsername(username, this.realm);
        if (user == null) {
            throw new NotFoundException("User not found");
        }
        if (!this.session.users().removeSocialLink(this.realm, user, provider)) {
            throw new NotFoundException("Link not found");
        }
    }

    @Path(value="{username}/logout")
    @POST
    public void logout(@PathParam(value="username") String username) {
        this.auth.requireManage();
        UserModel user = this.session.users().getUserByUsername(username, this.realm);
        if (user == null) {
            throw new NotFoundException("User not found");
        }
        new ResourceAdminManager().logoutUser(this.uriInfo.getRequestUri(), this.realm, user, this.session);
        this.session.sessions().removeUserSessions(this.realm, user);
    }

    @Path(value="{username}")
    @DELETE
    @NoCache
    public Response deleteUser(@PathParam(value="username") String username) {
        this.auth.requireManage();
        UserModel user = this.session.users().getUserByUsername(username, this.realm);
        if (user == null) {
            throw new NotFoundException("User not found");
        }
        boolean removed = new UserManager(this.session).removeUser(this.realm, user);
        if (removed) {
            return Response.noContent().build();
        }
        return Flows.errors().error("User couldn't be deleted", Response.Status.BAD_REQUEST);
    }

    @GET
    @NoCache
    @Produces(value={"application/json"})
    public List<UserRepresentation> getUsers(@QueryParam(value="search") String search, @QueryParam(value="lastName") String last, @QueryParam(value="firstName") String first, @QueryParam(value="email") String email, @QueryParam(value="username") String username, @QueryParam(value="first") Integer firstResult, @QueryParam(value="max") Integer maxResults) {
        List userModels;
        this.auth.requireView();
        firstResult = firstResult != null ? firstResult : -1;
        maxResults = maxResults != null ? maxResults : -1;
        ArrayList<UserRepresentation> results = new ArrayList<UserRepresentation>();
        if (search != null) {
            userModels = this.session.users().searchForUser(search.trim(), this.realm, firstResult.intValue(), maxResults.intValue());
        } else if (last != null || first != null || email != null || username != null) {
            HashMap<String, String> attributes = new HashMap<String, String>();
            if (last != null) {
                attributes.put("lastName", last);
            }
            if (first != null) {
                attributes.put("firstName", first);
            }
            if (email != null) {
                attributes.put("email", email);
            }
            if (username != null) {
                attributes.put("username", username);
            }
            userModels = this.session.users().searchForUserByAttributes(attributes, this.realm, firstResult.intValue(), maxResults.intValue());
        } else {
            userModels = this.session.users().getUsers(this.realm, firstResult.intValue(), maxResults.intValue());
        }
        for (UserModel user : userModels) {
            results.add(ModelToRepresentation.toRepresentation((UserModel)user));
        }
        return results;
    }

    @Path(value="{username}/role-mappings")
    @GET
    @Produces(value={"application/json"})
    @NoCache
    public MappingsRepresentation getRoleMappings(@PathParam(value="username") String username) {
        List applications;
        this.auth.requireView();
        UserModel user = this.session.users().getUserByUsername(username, this.realm);
        if (user == null) {
            throw new NotFoundException("User not found");
        }
        MappingsRepresentation all = new MappingsRepresentation();
        Set realmMappings = user.getRoleMappings();
        RealmManager manager = new RealmManager(this.session);
        if (realmMappings.size() > 0) {
            ArrayList<RoleRepresentation> realmRep = new ArrayList<RoleRepresentation>();
            for (RoleModel roleModel : realmMappings) {
                realmRep.add(ModelToRepresentation.toRepresentation((RoleModel)roleModel));
            }
            all.setRealmMappings(realmRep);
        }
        if ((applications = this.realm.getApplications()).size() > 0) {
            HashMap<String, ApplicationMappingsRepresentation> appMappings = new HashMap<String, ApplicationMappingsRepresentation>();
            for (ApplicationModel application : applications) {
                Set roleMappings = user.getApplicationRoleMappings(application);
                if (roleMappings.size() <= 0) continue;
                ApplicationMappingsRepresentation mappings = new ApplicationMappingsRepresentation();
                mappings.setApplicationId(application.getId());
                mappings.setApplication(application.getName());
                ArrayList<RoleRepresentation> roles = new ArrayList<RoleRepresentation>();
                mappings.setMappings(roles);
                for (RoleModel role : roleMappings) {
                    roles.add(ModelToRepresentation.toRepresentation((RoleModel)role));
                }
                appMappings.put(application.getName(), mappings);
                all.setApplicationMappings(appMappings);
            }
        }
        return all;
    }

    @Path(value="{username}/role-mappings/realm")
    @GET
    @Produces(value={"application/json"})
    @NoCache
    public List<RoleRepresentation> getRealmRoleMappings(@PathParam(value="username") String username) {
        this.auth.requireView();
        UserModel user = this.session.users().getUserByUsername(username, this.realm);
        if (user == null) {
            throw new NotFoundException("User not found");
        }
        Set realmMappings = user.getRealmRoleMappings();
        ArrayList<RoleRepresentation> realmMappingsRep = new ArrayList<RoleRepresentation>();
        for (RoleModel roleModel : realmMappings) {
            realmMappingsRep.add(ModelToRepresentation.toRepresentation((RoleModel)roleModel));
        }
        return realmMappingsRep;
    }

    @Path(value="{username}/role-mappings/realm/composite")
    @GET
    @Produces(value={"application/json"})
    @NoCache
    public List<RoleRepresentation> getCompositeRealmRoleMappings(@PathParam(value="username") String username) {
        this.auth.requireView();
        UserModel user = this.session.users().getUserByUsername(username, this.realm);
        if (user == null) {
            throw new NotFoundException("User not found");
        }
        Set roles = this.realm.getRoles();
        ArrayList<RoleRepresentation> realmMappingsRep = new ArrayList<RoleRepresentation>();
        for (RoleModel roleModel : roles) {
            if (!user.hasRole(roleModel)) continue;
            realmMappingsRep.add(ModelToRepresentation.toRepresentation((RoleModel)roleModel));
        }
        return realmMappingsRep;
    }

    @Path(value="{username}/role-mappings/realm/available")
    @GET
    @Produces(value={"application/json"})
    @NoCache
    public List<RoleRepresentation> getAvailableRealmRoleMappings(@PathParam(value="username") String username) {
        this.auth.requireView();
        UserModel user = this.session.users().getUserByUsername(username, this.realm);
        if (user == null) {
            throw new NotFoundException("User not found");
        }
        Set available = this.realm.getRoles();
        return UserApplicationRoleMappingsResource.getAvailableRoles(user, available);
    }

    @Path(value="{username}/role-mappings/realm")
    @POST
    @Consumes(value={"application/json"})
    public void addRealmRoleMappings(@PathParam(value="username") String username, List<RoleRepresentation> roles) {
        this.auth.requireManage();
        logger.debugv("** addRealmRoleMappings: {0}", roles);
        UserModel user = this.session.users().getUserByUsername(username, this.realm);
        if (user == null) {
            throw new NotFoundException("User not found");
        }
        for (RoleRepresentation role : roles) {
            RoleModel roleModel = this.realm.getRole(role.getName());
            if (roleModel == null || !roleModel.getId().equals(role.getId())) {
                throw new NotFoundException("Role not found");
            }
            user.grantRole(roleModel);
        }
    }

    @Path(value="{username}/role-mappings/realm")
    @DELETE
    @Consumes(value={"application/json"})
    public void deleteRealmRoleMappings(@PathParam(value="username") String username, List<RoleRepresentation> roles) {
        this.auth.requireManage();
        logger.debug((Object)"deleteRealmRoleMappings");
        UserModel user = this.session.users().getUserByUsername(username, this.realm);
        if (user == null) {
            throw new NotFoundException("User not found");
        }
        if (roles == null) {
            Set roleModels = user.getRealmRoleMappings();
            for (RoleModel roleModel : roleModels) {
                user.deleteRoleMapping(roleModel);
            }
        } else {
            for (RoleRepresentation role : roles) {
                RoleModel roleModel = this.realm.getRole(role.getName());
                if (roleModel == null || !roleModel.getId().equals(role.getId())) {
                    throw new NotFoundException("Role not found");
                }
                user.deleteRoleMapping(roleModel);
            }
        }
    }

    @Path(value="{username}/role-mappings/applications/{app}")
    public UserApplicationRoleMappingsResource getUserApplicationRoleMappingsResource(@PathParam(value="username") String username, @PathParam(value="app") String appName) {
        UserModel user = this.session.users().getUserByUsername(username, this.realm);
        if (user == null) {
            throw new NotFoundException("User not found");
        }
        ApplicationModel application = this.realm.getApplicationByName(appName);
        if (application == null) {
            throw new NotFoundException("Application not found");
        }
        return new UserApplicationRoleMappingsResource(this.realm, this.auth, user, application);
    }

    @Path(value="{username}/role-mappings/applications-by-id/{appId}")
    public UserApplicationRoleMappingsResource getUserApplicationRoleMappingsResourceById(@PathParam(value="username") String username, @PathParam(value="appId") String appId) {
        UserModel user = this.session.users().getUserByUsername(username, this.realm);
        if (user == null) {
            throw new NotFoundException("User not found");
        }
        ApplicationModel application = this.realm.getApplicationById(appId);
        if (application == null) {
            throw new NotFoundException("Application not found");
        }
        return new UserApplicationRoleMappingsResource(this.realm, this.auth, user, application);
    }

    @Path(value="{username}/reset-password")
    @PUT
    @Consumes(value={"application/json"})
    public void resetPassword(@PathParam(value="username") String username, CredentialRepresentation pass) {
        this.auth.requireManage();
        UserModel user = this.session.users().getUserByUsername(username, this.realm);
        if (user == null) {
            throw new NotFoundException("User not found");
        }
        if (pass == null || pass.getValue() == null || !"password".equals(pass.getType())) {
            throw new BadRequestException("No password provided");
        }
        UserCredentialModel cred = RepresentationToModel.convertCredential((CredentialRepresentation)pass);
        try {
            this.session.users().updateCredential(this.realm, user, cred);
        }
        catch (ModelReadOnlyException mre) {
            throw new BadRequestException("Can't reset password as account is read only");
        }
        if (pass.isTemporary()) {
            user.addRequiredAction(UserModel.RequiredAction.UPDATE_PASSWORD);
        }
    }

    @Path(value="{username}/remove-totp")
    @PUT
    @Consumes(value={"application/json"})
    public void removeTotp(@PathParam(value="username") String username) {
        this.auth.requireManage();
        UserModel user = this.session.users().getUserByUsername(username, this.realm);
        if (user == null) {
            throw new NotFoundException("User not found");
        }
        user.setTotp(false);
    }

    @Path(value="{username}/reset-password-email")
    @PUT
    @Consumes(value={"application/json"})
    public Response resetPasswordEmail(@PathParam(value="username") String username, @QueryParam(value="redirect_uri") String redirectUri, @QueryParam(value="client_id") String clientId) {
        String redirect;
        ClientModel client;
        this.auth.requireManage();
        UserModel user = this.session.users().getUserByUsername(username, this.realm);
        if (user == null) {
            return Flows.errors().error("User not found", Response.Status.NOT_FOUND);
        }
        if (!user.isEnabled()) {
            return Flows.errors().error("User is disabled", Response.Status.BAD_REQUEST);
        }
        if (user.getEmail() == null) {
            return Flows.errors().error("User email missing", Response.Status.BAD_REQUEST);
        }
        if (redirectUri != null && clientId == null) {
            return Flows.errors().error("Client id missing", Response.Status.BAD_REQUEST);
        }
        if (clientId == null) {
            clientId = "account";
        }
        if ((client = this.realm.findClient(clientId)) == null || !client.isEnabled()) {
            return Flows.errors().error(clientId + " not enabled", Response.Status.INTERNAL_SERVER_ERROR);
        }
        if (redirectUri != null) {
            redirect = OpenIDConnectService.verifyRedirectUri(this.uriInfo, redirectUri, this.realm, client);
            if (redirect == null) {
                return Flows.errors().error("Invalid redirect uri.", Response.Status.BAD_REQUEST);
            }
        } else {
            redirect = Urls.accountBase(this.uriInfo.getBaseUri()).path("/").build(new Object[]{this.realm.getName()}).toString();
        }
        UserSessionModel userSession = this.session.sessions().createUserSession(this.realm, user, username, this.clientConnection.getRemoteAddr(), "form", false);
        ClientSessionModel clientSession = this.session.sessions().createClientSession(this.realm, client);
        clientSession.setAuthMethod("openid-connect");
        clientSession.setRedirectUri(redirect);
        clientSession.setUserSession(userSession);
        ClientSessionCode accessCode = new ClientSessionCode(this.realm, clientSession);
        accessCode.setAction(ClientSessionModel.Action.RECOVER_PASSWORD);
        try {
            UriBuilder builder = Urls.loginPasswordResetBuilder(this.uriInfo.getBaseUri());
            builder.queryParam("key", new Object[]{accessCode.getCode()});
            String link = builder.build(new Object[]{this.realm.getName()}).toString();
            long expiration = TimeUnit.SECONDS.toMinutes(this.realm.getAccessCodeLifespanUserAction());
            ((EmailProvider)this.session.getProvider(EmailProvider.class)).setRealm(this.realm).setUser(user).sendPasswordReset(link, expiration);
            return Response.ok().build();
        }
        catch (EmailException e) {
            logger.error((Object)"Failed to send password reset email", (Throwable)e);
            return Flows.errors().error("Failed to send email", Response.Status.INTERNAL_SERVER_ERROR);
        }
    }
}

