/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.protocol.oidc.endpoints;

import java.util.List;
import javax.ws.rs.OPTIONS;
import javax.ws.rs.POST;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.HttpHeaders;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriInfo;
import org.jboss.logging.Logger;
import org.jboss.resteasy.spi.HttpRequest;
import org.keycloak.ClientConnection;
import org.keycloak.OAuthErrorException;
import org.keycloak.events.EventBuilder;
import org.keycloak.events.EventType;
import org.keycloak.models.ClientModel;
import org.keycloak.models.ClientSessionModel;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.RealmModel;
import org.keycloak.models.UserModel;
import org.keycloak.models.UserSessionModel;
import org.keycloak.models.UserSessionProvider;
import org.keycloak.models.utils.KeycloakModelUtils;
import org.keycloak.protocol.oidc.TokenManager;
import org.keycloak.protocol.oidc.utils.AuthorizeClientUtil;
import org.keycloak.representations.AccessToken;
import org.keycloak.representations.AccessTokenResponse;
import org.keycloak.services.ErrorResponseException;
import org.keycloak.services.Urls;
import org.keycloak.services.managers.AuthenticationManager;
import org.keycloak.services.managers.ClientSessionCode;
import org.keycloak.services.resources.Cors;

public class TokenEndpoint {
    private static final Logger logger = Logger.getLogger(TokenEndpoint.class);
    private MultivaluedMap<String, String> formParams;
    private ClientModel client;
    @Context
    private KeycloakSession session;
    @Context
    private HttpRequest request;
    @Context
    private HttpHeaders headers;
    @Context
    private UriInfo uriInfo;
    @Context
    private ClientConnection clientConnection;
    private final TokenManager tokenManager;
    private final AuthenticationManager authManager;
    private final RealmModel realm;
    private final EventBuilder event;
    private Action action;
    private String grantType;
    private String legacyGrantType;

    public TokenEndpoint(TokenManager tokenManager, AuthenticationManager authManager, RealmModel realm, EventBuilder event) {
        this.tokenManager = tokenManager;
        this.authManager = authManager;
        this.realm = realm;
        this.event = event;
    }

    @POST
    public Response build() {
        this.formParams = this.request.getDecodedFormParameters();
        this.grantType = (String)this.formParams.getFirst((Object)"grant_type");
        this.checkSsl();
        this.checkRealm();
        this.checkGrantType();
        this.checkClient();
        switch (this.action) {
            case AUTHORIZATION_CODE: {
                return this.buildAuthorizationCodeAccessTokenResponse();
            }
            case REFRESH_TOKEN: {
                return this.buildRefreshToken();
            }
            case PASSWORD: {
                return this.buildResourceOwnerPasswordCredentialsGrant();
            }
        }
        throw new RuntimeException("Unknown action " + (Object)((Object)this.action));
    }

    @OPTIONS
    public Response preflight() {
        if (logger.isDebugEnabled()) {
            logger.debugv("CORS preflight from: {0}", this.headers.getRequestHeaders().getFirst((Object)"Origin"));
        }
        return Cors.add(this.request, Response.ok()).auth().preflight().build();
    }

    public TokenEndpoint legacy(String legacyGrantType) {
        logger.warnv("Invoking deprecated endpoint {0}", (Object)this.uriInfo.getRequestUri());
        this.legacyGrantType = legacyGrantType;
        return this;
    }

    private void checkSsl() {
        if (!this.uriInfo.getBaseUri().getScheme().equals("https") && this.realm.getSslRequired().isRequired(this.clientConnection)) {
            throw new ErrorResponseException("invalid_request", "HTTPS required", Response.Status.FORBIDDEN);
        }
    }

    private void checkRealm() {
        if (!this.realm.isEnabled()) {
            throw new ErrorResponseException("access_denied", "Realm not enabled", Response.Status.FORBIDDEN);
        }
    }

    private void checkClient() {
        String authorizationHeader = (String)this.headers.getRequestHeaders().getFirst((Object)"Authorization");
        this.client = AuthorizeClientUtil.authorizeClient(authorizationHeader, this.formParams, this.event, this.realm);
        if (this.client instanceof ClientModel && this.client.isBearerOnly()) {
            throw new ErrorResponseException("invalid_client", "Bearer-only not allowed", Response.Status.BAD_REQUEST);
        }
    }

    private void checkGrantType() {
        if (this.grantType == null) {
            if (this.legacyGrantType != null) {
                this.grantType = this.legacyGrantType;
            } else {
                throw new ErrorResponseException("invalid_request", "Missing form parameter: grant_type", Response.Status.BAD_REQUEST);
            }
        }
        if (this.grantType.equals("authorization_code")) {
            this.event.event(EventType.CODE_TO_TOKEN);
            this.action = Action.AUTHORIZATION_CODE;
        } else if (this.grantType.equals("refresh_token")) {
            this.event.event(EventType.REFRESH_TOKEN);
            this.action = Action.REFRESH_TOKEN;
        } else if (this.grantType.equals("password")) {
            this.event.event(EventType.LOGIN);
            this.action = Action.PASSWORD;
        } else {
            throw new ErrorResponseException("invalid_request", "Invalid grant_type", Response.Status.BAD_REQUEST);
        }
    }

    public Response buildAuthorizationCodeAccessTokenResponse() {
        String code = (String)this.formParams.getFirst((Object)"code");
        if (code == null) {
            this.event.error("invalid_code");
            throw new ErrorResponseException("invalid_request", "Missing parameter: code", Response.Status.BAD_REQUEST);
        }
        ClientSessionCode accessCode = ClientSessionCode.parse(code, this.session, this.realm);
        if (accessCode == null) {
            String[] parts = code.split("\\.");
            if (parts.length == 2) {
                try {
                    this.event.detail("code_id", new String(parts[1]));
                }
                catch (Throwable t) {
                    // empty catch block
                }
            }
            this.event.error("invalid_code");
            throw new ErrorResponseException("invalid_grant", "Code not found", Response.Status.BAD_REQUEST);
        }
        ClientSessionModel clientSession = accessCode.getClientSession();
        this.event.detail("code_id", clientSession.getId());
        if (!accessCode.isValid(ClientSessionModel.Action.CODE_TO_TOKEN)) {
            this.event.error("invalid_code");
            throw new ErrorResponseException("invalid_grant", "Code is expired", Response.Status.BAD_REQUEST);
        }
        accessCode.setAction(null);
        UserSessionModel userSession = clientSession.getUserSession();
        this.event.user(userSession.getUser());
        this.event.session(userSession.getId());
        String redirectUri = clientSession.getNote("redirect_uri");
        if (redirectUri != null && !redirectUri.equals(this.formParams.getFirst((Object)"redirect_uri"))) {
            this.event.error("invalid_code");
            throw new ErrorResponseException("invalid_grant", "Incorrect redirect_uri", Response.Status.BAD_REQUEST);
        }
        if (!this.client.getClientId().equals(clientSession.getClient().getClientId())) {
            this.event.error("invalid_code");
            throw new ErrorResponseException("invalid_grant", "Auth error", Response.Status.BAD_REQUEST);
        }
        UserModel user = this.session.users().getUserById(userSession.getUser().getId(), this.realm);
        if (user == null) {
            this.event.error("user_not_found");
            throw new ErrorResponseException("invalid_grant", "User not found", Response.Status.BAD_REQUEST);
        }
        if (!user.isEnabled()) {
            this.event.error("user_disabled");
            throw new ErrorResponseException("invalid_grant", "User disabled", Response.Status.BAD_REQUEST);
        }
        if (!AuthenticationManager.isSessionValid(this.realm, userSession)) {
            this.event.error("user_session_not_found");
            throw new ErrorResponseException("invalid_grant", "Session not active", Response.Status.BAD_REQUEST);
        }
        this.updateClientSession(clientSession);
        AccessToken token = this.tokenManager.createClientAccessToken(this.session, accessCode.getRequestedRoles(), this.realm, this.client, user, userSession, clientSession);
        AccessTokenResponse res = this.tokenManager.responseBuilder(this.realm, this.client, this.event, this.session, userSession, clientSession).accessToken(token).generateIDToken().generateRefreshToken().build();
        this.event.success();
        return Cors.add(this.request, Response.ok((Object)res).type(MediaType.APPLICATION_JSON_TYPE)).auth().allowedOrigins(this.client).allowedMethods("POST").exposedHeaders("Access-Control-Allow-Methods").build();
    }

    public Response buildRefreshToken() {
        AccessTokenResponse res;
        String refreshToken = (String)this.formParams.getFirst((Object)"refresh_token");
        if (refreshToken == null) {
            throw new ErrorResponseException("invalid_request", "No refresh token", Response.Status.BAD_REQUEST);
        }
        try {
            res = this.tokenManager.refreshAccessToken(this.session, this.uriInfo, this.clientConnection, this.realm, this.client, refreshToken, this.event, this.headers);
            UserSessionModel userSession = this.session.sessions().getUserSession(this.realm, res.getSessionState());
            this.updateClientSessions(userSession.getClientSessions());
        }
        catch (OAuthErrorException e) {
            this.event.error("invalid_token");
            throw new ErrorResponseException(e.getError(), e.getDescription(), Response.Status.BAD_REQUEST);
        }
        this.event.success();
        return Cors.add(this.request, Response.ok((Object)res, (MediaType)MediaType.APPLICATION_JSON_TYPE)).auth().allowedOrigins(this.client).allowedMethods("POST").exposedHeaders("Access-Control-Allow-Methods").build();
    }

    private void updateClientSession(ClientSessionModel clientSession) {
        if (clientSession == null) {
            logger.error((Object)"client session is null");
            return;
        }
        String adapterSessionId = (String)this.formParams.getFirst((Object)"client_session_state");
        if (adapterSessionId != null) {
            String adapterSessionHost = (String)this.formParams.getFirst((Object)"client_session_host");
            logger.debugf("Adapter Session '%s' saved in ClientSession for client '%s'. Host is '%s'", (Object)adapterSessionId, (Object)this.client.getClientId(), (Object)adapterSessionHost);
            this.event.detail("client_session_state", adapterSessionId);
            clientSession.setNote("client_session_state", adapterSessionId);
            this.event.detail("client_session_host", adapterSessionHost);
            clientSession.setNote("client_session_host", adapterSessionHost);
        }
    }

    private void updateClientSessions(List<ClientSessionModel> clientSessions) {
        if (clientSessions == null) {
            logger.error((Object)"client sessions is null");
            return;
        }
        for (ClientSessionModel clientSession : clientSessions) {
            if (clientSession == null) {
                logger.error((Object)"client session is null");
                continue;
            }
            if (clientSession.getClient() == null) {
                logger.error((Object)"client model in client session is null");
                continue;
            }
            if (!this.client.getId().equals(clientSession.getClient().getId())) continue;
            this.updateClientSession(clientSession);
        }
    }

    public Response buildResourceOwnerPasswordCredentialsGrant() {
        this.event.detail("auth_method", "oauth_credentials").detail("response_type", "token");
        String username = (String)this.formParams.getFirst((Object)"username");
        if (username == null) {
            this.event.error("username_missing");
            throw new ErrorResponseException("invalid_request", "Missing parameter: username", Response.Status.UNAUTHORIZED);
        }
        this.event.detail("username", username);
        UserModel user = KeycloakModelUtils.findUserByNameOrEmail((KeycloakSession)this.session, (RealmModel)this.realm, (String)username);
        if (user != null) {
            this.event.user(user);
        }
        AuthenticationManager.AuthenticationStatus authenticationStatus = this.authManager.authenticateForm(this.session, this.clientConnection, this.realm, this.formParams);
        switch (authenticationStatus) {
            case SUCCESS: {
                break;
            }
            case ACCOUNT_TEMPORARILY_DISABLED: 
            case ACTIONS_REQUIRED: {
                this.event.error("user_temporarily_disabled");
                throw new ErrorResponseException("invalid_grant", "Account temporarily disabled", Response.Status.BAD_REQUEST);
            }
            case ACCOUNT_DISABLED: {
                this.event.error("user_disabled");
                throw new ErrorResponseException("invalid_grant", "Account disabled", Response.Status.BAD_REQUEST);
            }
            default: {
                this.event.error("invalid_user_credentials");
                throw new ErrorResponseException("invalid_grant", "Invalid user credentials", Response.Status.UNAUTHORIZED);
            }
        }
        String scope = (String)this.formParams.getFirst((Object)"scope");
        UserSessionProvider sessions = this.session.sessions();
        UserSessionModel userSession = sessions.createUserSession(this.realm, user, username, this.clientConnection.getRemoteAddr(), "oauth_credentials", false, null, null);
        this.event.session(userSession);
        ClientSessionModel clientSession = sessions.createClientSession(this.realm, this.client);
        clientSession.setAuthMethod("openid-connect");
        clientSession.setNote("iss", Urls.realmIssuer(this.uriInfo.getBaseUri(), this.realm.getName()));
        TokenManager.attachClientSession(userSession, clientSession);
        AccessTokenResponse res = this.tokenManager.responseBuilder(this.realm, this.client, this.event, this.session, userSession, clientSession).generateAccessToken(this.session, scope, this.client, user, userSession, clientSession).generateRefreshToken().generateIDToken().build();
        this.event.success();
        return Response.ok((Object)res, (MediaType)MediaType.APPLICATION_JSON_TYPE).build();
    }

    private static enum Action {
        AUTHORIZATION_CODE,
        REFRESH_TOKEN,
        PASSWORD;

    }
}

