/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.protocol.oidc.utils;

import java.util.HashMap;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.core.Response;
import org.jboss.resteasy.spi.BadRequestException;
import org.jboss.resteasy.spi.UnauthorizedException;
import org.keycloak.events.EventBuilder;
import org.keycloak.models.ClientModel;
import org.keycloak.models.RealmModel;
import org.keycloak.util.BasicAuthHelper;

public class AuthorizeClientUtil {
    public static ClientModel authorizeClient(String authorizationHeader, MultivaluedMap<String, String> formData, EventBuilder event, RealmModel realm) {
        String clientSecret;
        String client_id;
        if (authorizationHeader != null) {
            String[] usernameSecret = BasicAuthHelper.parseHeader((String)authorizationHeader);
            if (usernameSecret == null) {
                throw new UnauthorizedException("Bad Authorization header", Response.status((int)401).header("WWW-Authenticate", (Object)("Basic realm=\"" + realm.getName() + "\"")).build());
            }
            client_id = usernameSecret[0];
            clientSecret = usernameSecret[1];
        } else {
            client_id = (String)formData.getFirst((Object)"client_id");
            clientSecret = (String)formData.getFirst((Object)"client_secret");
        }
        if (client_id == null) {
            HashMap<String, String> error = new HashMap<String, String>();
            error.put("error", "invalid_client");
            error.put("error_description", "Missing client_id parameter");
            throw new BadRequestException("Could not find client", Response.status((Response.Status)Response.Status.BAD_REQUEST).entity(error).type(MediaType.APPLICATION_JSON_TYPE).build());
        }
        event.client(client_id);
        ClientModel client = realm.getClientByClientId(client_id);
        if (client == null) {
            HashMap<String, String> error = new HashMap<String, String>();
            error.put("error", "invalid_client");
            error.put("error_description", "Could not find client");
            event.error("client_not_found");
            throw new BadRequestException("Could not find client", Response.status((Response.Status)Response.Status.BAD_REQUEST).entity(error).type(MediaType.APPLICATION_JSON_TYPE).build());
        }
        if (!client.isEnabled()) {
            HashMap<String, String> error = new HashMap<String, String>();
            error.put("error", "invalid_client");
            error.put("error_description", "Client is not enabled");
            event.error("client_disabled");
            throw new BadRequestException("Client is not enabled", Response.status((Response.Status)Response.Status.BAD_REQUEST).entity(error).type(MediaType.APPLICATION_JSON_TYPE).build());
        }
        if (!(client.isPublicClient() || clientSecret != null && client.validateSecret(clientSecret))) {
            HashMap<String, String> error = new HashMap<String, String>();
            error.put("error", "unauthorized_client");
            event.error("invalid_client_credentials");
            throw new BadRequestException("Unauthorized Client", Response.status((Response.Status)Response.Status.BAD_REQUEST).entity(error).type(MediaType.APPLICATION_JSON_TYPE).build());
        }
        return client;
    }
}

