/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.authentication;

import java.net.URI;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriInfo;
import org.jboss.resteasy.spi.HttpRequest;
import org.keycloak.ClientConnection;
import org.keycloak.authentication.AuthenticationFlow;
import org.keycloak.authentication.AuthenticationProcessor;
import org.keycloak.authentication.FormAction;
import org.keycloak.authentication.FormAuthenticator;
import org.keycloak.authentication.FormContext;
import org.keycloak.authentication.ValidationContext;
import org.keycloak.events.EventBuilder;
import org.keycloak.login.LoginFormsProvider;
import org.keycloak.models.AuthenticationExecutionModel;
import org.keycloak.models.AuthenticatorConfigModel;
import org.keycloak.models.ClientSessionModel;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.RealmModel;
import org.keycloak.models.UserModel;
import org.keycloak.models.utils.FormMessage;
import org.keycloak.services.resources.LoginActionsService;

public class FormAuthenticationFlow
implements AuthenticationFlow {
    AuthenticationProcessor processor;
    AuthenticationExecutionModel formExecution;
    private final List<AuthenticationExecutionModel> formActionExecutions;
    private final FormAuthenticator formAuthenticator;

    public FormAuthenticationFlow(AuthenticationProcessor processor, AuthenticationExecutionModel execution) {
        this.processor = processor;
        this.formExecution = execution;
        this.formActionExecutions = processor.getRealm().getAuthenticationExecutions(execution.getFlowId());
        this.formAuthenticator = (FormAuthenticator)processor.getSession().getProvider(FormAuthenticator.class, execution.getAuthenticator());
    }

    @Override
    public Response processAction(String actionExecution) {
        if (!actionExecution.equals(this.formExecution.getId())) {
            throw new AuthenticationProcessor.AuthException("action is not current execution", AuthenticationProcessor.Error.INTERNAL_ERROR);
        }
        HashMap<String, ClientSessionModel.ExecutionStatus> executionStatus = new HashMap<String, ClientSessionModel.ExecutionStatus>();
        LinkedList<FormAction> requiredActions = new LinkedList<FormAction>();
        LinkedList<ValidationContextImpl> successes = new LinkedList<ValidationContextImpl>();
        for (AuthenticationExecutionModel authenticationExecutionModel : this.formActionExecutions) {
            if (!authenticationExecutionModel.isEnabled()) {
                executionStatus.put(authenticationExecutionModel.getId(), ClientSessionModel.ExecutionStatus.SKIPPED);
                continue;
            }
            FormAction action = (FormAction)this.processor.getSession().getProvider(FormAction.class, authenticationExecutionModel.getAuthenticator());
            UserModel authUser = this.processor.getClientSession().getAuthenticatedUser();
            if (action.requiresUser() && authUser == null) {
                throw new AuthenticationProcessor.AuthException("form action: " + this.formExecution.getAuthenticator() + " requires user", AuthenticationProcessor.Error.UNKNOWN_USER);
            }
            boolean configuredFor = false;
            if (action.requiresUser() && authUser != null && !(configuredFor = action.configuredFor(this.processor.getSession(), this.processor.getRealm(), authUser))) {
                if (authenticationExecutionModel.isRequired()) {
                    if (authenticationExecutionModel.isUserSetupAllowed()) {
                        AuthenticationProcessor.logger.debugv("authenticator SETUP_REQUIRED: {0}", (Object)this.formExecution.getAuthenticator());
                        executionStatus.put(authenticationExecutionModel.getId(), ClientSessionModel.ExecutionStatus.SETUP_REQUIRED);
                        requiredActions.add(action);
                        continue;
                    }
                    throw new AuthenticationProcessor.AuthException(AuthenticationProcessor.Error.CREDENTIAL_SETUP_REQUIRED);
                }
                if (authenticationExecutionModel.isOptional()) {
                    executionStatus.put(authenticationExecutionModel.getId(), ClientSessionModel.ExecutionStatus.SKIPPED);
                    continue;
                }
            }
            ValidationContextImpl result = new ValidationContextImpl(authenticationExecutionModel, action);
            action.validate(result);
            if (result.success) {
                executionStatus.put(authenticationExecutionModel.getId(), ClientSessionModel.ExecutionStatus.SUCCESS);
                successes.add(result);
                continue;
            }
            this.processor.logFailure();
            executionStatus.put(authenticationExecutionModel.getId(), ClientSessionModel.ExecutionStatus.CHALLENGED);
            return this.renderForm(result.formData, result.errors);
        }
        for (ValidationContextImpl validationContextImpl : successes) {
            validationContextImpl.action.success(validationContextImpl);
        }
        for (Map.Entry entry : executionStatus.entrySet()) {
            this.processor.getClientSession().setExecutionStatus((String)entry.getKey(), (ClientSessionModel.ExecutionStatus)entry.getValue());
        }
        for (FormAction formAction : requiredActions) {
            formAction.setRequiredActions(this.processor.getSession(), this.processor.getRealm(), this.processor.getClientSession().getAuthenticatedUser());
        }
        return null;
    }

    public URI getActionUrl(String executionId, String code) {
        return LoginActionsService.registrationFormProcessor(this.processor.getUriInfo()).queryParam("code", new Object[]{code}).queryParam("execution", new Object[]{executionId}).build(new Object[]{this.processor.getRealm().getName()});
    }

    @Override
    public Response processFlow() {
        return this.renderForm(null, null);
    }

    public Response renderForm(MultivaluedMap<String, String> formData, List<FormMessage> errors) {
        String executionId = this.formExecution.getId();
        this.processor.getClientSession().setNote("current.authentication.execution", executionId);
        String code = this.processor.generateCode();
        URI actionUrl = this.getActionUrl(executionId, code);
        LoginFormsProvider form = ((LoginFormsProvider)this.processor.getSession().getProvider(LoginFormsProvider.class)).setActionUri(actionUrl).setClientSessionCode(code).setFormData(formData).setErrors(errors);
        for (AuthenticationExecutionModel formActionExecution : this.formActionExecutions) {
            if (!formActionExecution.isEnabled()) continue;
            FormAction action = (FormAction)this.processor.getSession().getProvider(FormAction.class, formActionExecution.getAuthenticator());
            FormContextImpl result = new FormContextImpl(formActionExecution);
            action.buildPage(result, form);
        }
        FormContextImpl context = new FormContextImpl(this.formExecution);
        return this.formAuthenticator.render(context, form);
    }

    private class ValidationContextImpl
    extends FormContextImpl
    implements ValidationContext {
        FormAction action;
        boolean success;
        List<FormMessage> errors;
        MultivaluedMap<String, String> formData;

        private ValidationContextImpl(AuthenticationExecutionModel executionModel, FormAction action) {
            super(executionModel);
            this.errors = null;
            this.formData = null;
            this.action = action;
        }

        @Override
        public void validationError(MultivaluedMap<String, String> formData, List<FormMessage> errors) {
            this.errors = errors;
            this.formData = formData;
        }

        @Override
        public void success() {
            this.success = true;
        }
    }

    private class FormContextImpl
    implements FormContext {
        AuthenticationExecutionModel executionModel;
        AuthenticatorConfigModel authenticatorConfig;

        private FormContextImpl(AuthenticationExecutionModel executionModel) {
            this.executionModel = executionModel;
        }

        @Override
        public EventBuilder newEvent() {
            return FormAuthenticationFlow.this.processor.newEvent();
        }

        @Override
        public EventBuilder getEvent() {
            return FormAuthenticationFlow.this.processor.getEvent();
        }

        @Override
        public AuthenticationExecutionModel getExecution() {
            return this.executionModel;
        }

        @Override
        public AuthenticatorConfigModel getAuthenticatorConfig() {
            if (this.executionModel.getAuthenticatorConfig() == null) {
                return null;
            }
            if (this.authenticatorConfig != null) {
                return this.authenticatorConfig;
            }
            this.authenticatorConfig = this.getRealm().getAuthenticatorConfigById(this.executionModel.getAuthenticatorConfig());
            return this.authenticatorConfig;
        }

        @Override
        public UserModel getUser() {
            return this.getClientSession().getAuthenticatedUser();
        }

        @Override
        public void setUser(UserModel user) {
            FormAuthenticationFlow.this.processor.setAutheticatedUser(user);
        }

        @Override
        public RealmModel getRealm() {
            return FormAuthenticationFlow.this.processor.getRealm();
        }

        @Override
        public ClientSessionModel getClientSession() {
            return FormAuthenticationFlow.this.processor.getClientSession();
        }

        @Override
        public ClientConnection getConnection() {
            return FormAuthenticationFlow.this.processor.getConnection();
        }

        @Override
        public UriInfo getUriInfo() {
            return FormAuthenticationFlow.this.processor.getUriInfo();
        }

        @Override
        public KeycloakSession getSession() {
            return FormAuthenticationFlow.this.processor.getSession();
        }

        @Override
        public HttpRequest getHttpRequest() {
            return FormAuthenticationFlow.this.processor.getRequest();
        }
    }
}

