/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.authentication.authenticators.browser;

import java.net.URI;
import java.util.LinkedList;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.core.Response;
import org.jboss.logging.Logger;
import org.keycloak.authentication.AuthenticationProcessor;
import org.keycloak.authentication.Authenticator;
import org.keycloak.authentication.AuthenticatorContext;
import org.keycloak.login.LoginFormsProvider;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.ModelDuplicateException;
import org.keycloak.models.RealmModel;
import org.keycloak.models.UserCredentialModel;
import org.keycloak.models.UserModel;
import org.keycloak.models.utils.KeycloakModelUtils;
import org.keycloak.services.resources.LoginActionsService;

public abstract class AbstractFormAuthenticator
implements Authenticator {
    private static final Logger logger = Logger.getLogger(AbstractFormAuthenticator.class);
    public static final String REGISTRATION_FORM_ACTION = "registration_form";
    public static final String EXECUTION = "execution";
    public static final String ATTEMPTED_USERNAME = "ATTEMPTED_USERNAME";

    @Override
    public void action(AuthenticatorContext context) {
    }

    public void close() {
    }

    protected LoginFormsProvider loginForm(AuthenticatorContext context) {
        String accessCode = context.generateAccessCode();
        URI action = this.getActionUrl(context, accessCode);
        LoginFormsProvider provider = ((LoginFormsProvider)context.getSession().getProvider(LoginFormsProvider.class)).setUser(context.getUser()).setActionUri(action).setClientSessionCode(accessCode);
        if (context.getForwardedErrorMessage() != null) {
            provider.setError(context.getForwardedErrorMessage(), new Object[0]);
        }
        return provider;
    }

    public URI getActionUrl(AuthenticatorContext context, String code) {
        return LoginActionsService.authenticationFormProcessor(context.getUriInfo()).queryParam("code", new Object[]{code}).queryParam(EXECUTION, new Object[]{context.getExecution().getId()}).build(new Object[]{context.getRealm().getName()});
    }

    protected Response invalidUser(AuthenticatorContext context) {
        return this.loginForm(context).setError("invalidUserMessage", new Object[0]).createLogin();
    }

    protected Response disabledUser(AuthenticatorContext context) {
        return this.loginForm(context).setError("accountDisabledMessage", new Object[0]).createLogin();
    }

    protected Response temporarilyDisabledUser(AuthenticatorContext context) {
        return this.loginForm(context).setError("accountTemporarilyDisabledMessage", new Object[0]).createLogin();
    }

    protected Response invalidCredentials(AuthenticatorContext context) {
        return this.loginForm(context).setError("invalidUserMessage", new Object[0]).createLogin();
    }

    protected Response setDuplicateUserChallenge(AuthenticatorContext context, String eventError, String loginFormError, AuthenticationProcessor.Error authenticatorError) {
        context.getEvent().error(eventError);
        Response challengeResponse = this.loginForm(context).setError(loginFormError, new Object[0]).createLogin();
        context.failureChallenge(authenticatorError, challengeResponse);
        return challengeResponse;
    }

    public boolean invalidUser(AuthenticatorContext context, UserModel user) {
        if (user == null) {
            context.getEvent().error("user_not_found");
            Response challengeResponse = this.invalidUser(context);
            context.failureChallenge(AuthenticationProcessor.Error.INVALID_USER, challengeResponse);
            return true;
        }
        if (!user.isEnabled()) {
            context.getEvent().user(user);
            context.getEvent().error("user_disabled");
            Response challengeResponse = this.disabledUser(context);
            context.failureChallenge(AuthenticationProcessor.Error.USER_DISABLED, challengeResponse);
            return true;
        }
        if (context.getRealm().isBruteForceProtected() && context.getProtector().isTemporarilyDisabled(context.getSession(), context.getRealm(), user.getUsername())) {
            context.getEvent().user(user);
            context.getEvent().error("user_temporarily_disabled");
            Response challengeResponse = this.temporarilyDisabledUser(context);
            context.failureChallenge(AuthenticationProcessor.Error.USER_TEMPORARILY_DISABLED, challengeResponse);
            return true;
        }
        return false;
    }

    public boolean validateUser(AuthenticatorContext context, MultivaluedMap<String, String> inputData) {
        boolean remember;
        String username = (String)inputData.getFirst((Object)"username");
        if (username == null) {
            context.getEvent().error("user_not_found");
            Response challengeResponse = this.invalidUser(context);
            context.failureChallenge(AuthenticationProcessor.Error.INVALID_USER, challengeResponse);
            return false;
        }
        context.getEvent().detail("username", username);
        context.getClientSession().setNote(ATTEMPTED_USERNAME, username);
        UserModel user = null;
        try {
            user = KeycloakModelUtils.findUserByNameOrEmail((KeycloakSession)context.getSession(), (RealmModel)context.getRealm(), (String)username);
        }
        catch (ModelDuplicateException mde) {
            logger.error((Object)mde.getMessage(), (Throwable)mde);
            if (mde.getDuplicateFieldName() != null && mde.getDuplicateFieldName().equals("email")) {
                this.setDuplicateUserChallenge(context, "email_in_use", "emailExistsMessage", AuthenticationProcessor.Error.INVALID_USER);
            } else {
                this.setDuplicateUserChallenge(context, "username_in_use", "usernameExistsMessage", AuthenticationProcessor.Error.INVALID_USER);
            }
            return false;
        }
        if (this.invalidUser(context, user)) {
            return false;
        }
        String rememberMe = (String)inputData.getFirst((Object)"rememberMe");
        boolean bl = remember = rememberMe != null && rememberMe.equalsIgnoreCase("on");
        if (remember) {
            context.getClientSession().setNote("remember_me", "true");
            context.getEvent().detail("remember_me", "true");
        } else {
            context.getClientSession().removeNote("remember_me");
        }
        context.setUser(user);
        return true;
    }

    public boolean validatePassword(AuthenticatorContext context, MultivaluedMap<String, String> inputData) {
        LinkedList<UserCredentialModel> credentials = new LinkedList<UserCredentialModel>();
        String password = (String)inputData.getFirst((Object)"password");
        if (password == null || password.isEmpty()) {
            if (context.getUser() != null) {
                context.getEvent().user(context.getUser());
            }
            context.getEvent().error("invalid_user_credentials");
            Response challengeResponse = this.invalidCredentials(context);
            context.failureChallenge(AuthenticationProcessor.Error.INVALID_CREDENTIALS, challengeResponse);
            return false;
        }
        credentials.add(UserCredentialModel.password((String)password));
        boolean valid = context.getSession().users().validCredentials(context.getRealm(), context.getUser(), credentials);
        if (!valid) {
            context.getEvent().user(context.getUser());
            context.getEvent().error("invalid_user_credentials");
            Response challengeResponse = this.invalidCredentials(context);
            context.failureChallenge(AuthenticationProcessor.Error.INVALID_CREDENTIALS, challengeResponse);
            return false;
        }
        return true;
    }
}

