/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.authentication.authenticators.browser;

import java.net.URI;
import java.util.LinkedList;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.core.Response;
import org.keycloak.authentication.AuthenticationProcessor;
import org.keycloak.authentication.Authenticator;
import org.keycloak.authentication.AuthenticatorContext;
import org.keycloak.authentication.authenticators.browser.AbstractFormAuthenticator;
import org.keycloak.login.LoginFormsProvider;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.RealmModel;
import org.keycloak.models.UserCredentialModel;
import org.keycloak.models.UserModel;

public class OTPFormAuthenticator
extends AbstractFormAuthenticator
implements Authenticator {
    public static final String TOTP_FORM_ACTION = "totp";

    @Override
    public void action(AuthenticatorContext context) {
        this.validateOTP(context);
    }

    @Override
    public void authenticate(AuthenticatorContext context) {
        Response challengeResponse = this.challenge(context, null);
        context.challenge(challengeResponse);
    }

    public void validateOTP(AuthenticatorContext context) {
        MultivaluedMap inputData = context.getHttpRequest().getDecodedFormParameters();
        LinkedList<UserCredentialModel> credentials = new LinkedList<UserCredentialModel>();
        String password = (String)inputData.getFirst((Object)TOTP_FORM_ACTION);
        if (password == null) {
            Response challengeResponse = this.challenge(context, null);
            context.challenge(challengeResponse);
            return;
        }
        credentials.add(UserCredentialModel.totp((String)password));
        boolean valid = context.getSession().users().validCredentials(context.getRealm(), context.getUser(), credentials);
        if (!valid) {
            context.getEvent().user(context.getUser()).error("invalid_user_credentials");
            Response challengeResponse = this.challenge(context, "invalidTotpMessage");
            context.failureChallenge(AuthenticationProcessor.Error.INVALID_CREDENTIALS, challengeResponse);
            return;
        }
        context.success();
    }

    @Override
    public boolean requiresUser() {
        return true;
    }

    protected Response challenge(AuthenticatorContext context, String error) {
        String accessCode = context.generateAccessCode();
        URI action = this.getActionUrl(context, accessCode);
        LoginFormsProvider forms = ((LoginFormsProvider)context.getSession().getProvider(LoginFormsProvider.class)).setActionUri(action).setClientSessionCode(accessCode);
        if (error != null) {
            forms.setError(error, new Object[0]);
        }
        return forms.createLoginTotp();
    }

    @Override
    public boolean configuredFor(KeycloakSession session, RealmModel realm, UserModel user) {
        return session.users().configuredForCredentialType(TOTP_FORM_ACTION, realm, user) && user.isTotp();
    }

    @Override
    public void setRequiredActions(KeycloakSession session, RealmModel realm, UserModel user) {
        if (!user.getRequiredActions().contains(UserModel.RequiredAction.CONFIGURE_TOTP.name())) {
            user.addRequiredAction(UserModel.RequiredAction.CONFIGURE_TOTP.name());
        }
    }

    @Override
    public void close() {
    }
}

