/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.protocol.oidc;

import java.io.IOException;
import java.security.PublicKey;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.ws.rs.core.HttpHeaders;
import javax.ws.rs.core.UriInfo;
import org.jboss.logging.Logger;
import org.keycloak.ClientConnection;
import org.keycloak.OAuthErrorException;
import org.keycloak.events.EventBuilder;
import org.keycloak.jose.jws.JWSBuilder;
import org.keycloak.jose.jws.JWSInput;
import org.keycloak.jose.jws.crypto.RSAProvider;
import org.keycloak.models.ClientModel;
import org.keycloak.models.ClientSessionModel;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.KeycloakSessionFactory;
import org.keycloak.models.ProtocolMapperModel;
import org.keycloak.models.RealmModel;
import org.keycloak.models.RoleModel;
import org.keycloak.models.UserModel;
import org.keycloak.models.UserSessionModel;
import org.keycloak.models.UserSessionProvider;
import org.keycloak.models.utils.KeycloakModelUtils;
import org.keycloak.protocol.ProtocolMapper;
import org.keycloak.protocol.oidc.mappers.OIDCAccessTokenMapper;
import org.keycloak.protocol.oidc.mappers.OIDCIDTokenMapper;
import org.keycloak.representations.AccessToken;
import org.keycloak.representations.AccessTokenResponse;
import org.keycloak.representations.IDToken;
import org.keycloak.representations.RefreshToken;
import org.keycloak.services.managers.AuthenticationManager;
import org.keycloak.services.managers.ClientSessionCode;
import org.keycloak.util.Time;

public class TokenManager {
    protected static final Logger logger = Logger.getLogger(TokenManager.class);

    public static void applyScope(RoleModel role, RoleModel scope, Set<RoleModel> visited, Set<RoleModel> requested) {
        if (visited.contains(scope)) {
            return;
        }
        visited.add(scope);
        if (role.hasRole(scope)) {
            requested.add(scope);
            return;
        }
        if (!scope.isComposite()) {
            return;
        }
        for (RoleModel contained : scope.getComposites()) {
            TokenManager.applyScope(role, contained, visited, requested);
        }
    }

    public TokenValidation validateToken(KeycloakSession session, UriInfo uriInfo, ClientConnection connection, RealmModel realm, AccessToken oldToken, HttpHeaders headers) throws OAuthErrorException {
        UserModel user = session.users().getUserById(oldToken.getSubject(), realm);
        if (user == null) {
            throw new OAuthErrorException("invalid_grant", "Invalid refresh token", "Unknown user");
        }
        if (!user.isEnabled()) {
            throw new OAuthErrorException("invalid_grant", "User disabled", "User disabled");
        }
        UserSessionModel userSession = session.sessions().getUserSession(realm, oldToken.getSessionState());
        if (!AuthenticationManager.isSessionValid(realm, userSession)) {
            AuthenticationManager.backchannelLogout(session, realm, userSession, uriInfo, connection, headers, true);
            throw new OAuthErrorException("invalid_grant", "Session not active", "Session not active");
        }
        ClientSessionModel clientSession = null;
        for (ClientSessionModel clientSessionModel : userSession.getClientSessions()) {
            if (!clientSessionModel.getId().equals(oldToken.getClientSession())) continue;
            clientSession = clientSessionModel;
            break;
        }
        if (clientSession == null) {
            throw new OAuthErrorException("invalid_grant", "Client session not active", "Client session not active");
        }
        ClientModel client = clientSession.getClient();
        if (!client.getClientId().equals(oldToken.getIssuedFor())) {
            throw new OAuthErrorException("invalid_grant", "Unmatching clients", "Unmatching clients");
        }
        if (oldToken.getIssuedAt() < client.getNotBefore()) {
            throw new OAuthErrorException("invalid_grant", "Stale token");
        }
        if (oldToken.getIssuedAt() < realm.getNotBefore()) {
            throw new OAuthErrorException("invalid_grant", "Stale token");
        }
        Set<RoleModel> requestedRoles = TokenManager.getAccess(null, clientSession.getClient(), user);
        AccessToken newToken = this.createClientAccessToken(session, requestedRoles, realm, client, user, userSession, clientSession);
        this.verifyAccess(oldToken, newToken);
        return new TokenValidation(user, userSession, clientSession, newToken);
    }

    public AccessTokenResponse refreshAccessToken(KeycloakSession session, UriInfo uriInfo, ClientConnection connection, RealmModel realm, ClientModel authorizedClient, String encodedRefreshToken, EventBuilder event, HttpHeaders headers) throws OAuthErrorException {
        RefreshToken refreshToken = this.verifyRefreshToken(realm, encodedRefreshToken);
        event.user(refreshToken.getSubject()).session(refreshToken.getSessionState()).detail("refresh_token_id", refreshToken.getId());
        TokenValidation validation = this.validateToken(session, uriInfo, connection, realm, (AccessToken)refreshToken, headers);
        if (!validation.clientSession.getClient().getId().equals(authorizedClient.getId())) {
            throw new OAuthErrorException("invalid_grant", "Invalid refresh token. Token client and authorized client don't match");
        }
        int currentTime = Time.currentTime();
        validation.userSession.setLastSessionRefresh(currentTime);
        AccessTokenResponse res = this.responseBuilder(realm, authorizedClient, event, session, validation.userSession, validation.clientSession).accessToken(validation.newToken).generateIDToken().generateRefreshToken().build();
        return res;
    }

    public RefreshToken verifyRefreshToken(RealmModel realm, String encodedRefreshToken) throws OAuthErrorException {
        JWSInput jws = new JWSInput(encodedRefreshToken);
        RefreshToken refreshToken = null;
        try {
            if (!RSAProvider.verify((JWSInput)jws, (PublicKey)realm.getPublicKey())) {
                throw new OAuthErrorException("invalid_grant", "Invalid refresh token");
            }
            refreshToken = (RefreshToken)jws.readJsonContent(RefreshToken.class);
        }
        catch (Exception e) {
            throw new OAuthErrorException("invalid_grant", "Invalid refresh token", (Throwable)e);
        }
        if (refreshToken.isExpired()) {
            throw new OAuthErrorException("invalid_grant", "Refresh token expired");
        }
        if (refreshToken.getIssuedAt() < realm.getNotBefore()) {
            throw new OAuthErrorException("invalid_grant", "Stale refresh token");
        }
        return refreshToken;
    }

    public IDToken verifyIDToken(RealmModel realm, String encodedIDToken) throws OAuthErrorException {
        JWSInput jws = new JWSInput(encodedIDToken);
        IDToken idToken = null;
        try {
            if (!RSAProvider.verify((JWSInput)jws, (PublicKey)realm.getPublicKey())) {
                throw new OAuthErrorException("invalid_grant", "Invalid refresh token");
            }
            idToken = (IDToken)jws.readJsonContent(IDToken.class);
        }
        catch (IOException e) {
            throw new OAuthErrorException("invalid_grant", "Invalid refresh token", (Throwable)e);
        }
        if (idToken.isExpired()) {
            throw new OAuthErrorException("invalid_grant", "Refresh token expired");
        }
        if (idToken.getIssuedAt() < realm.getNotBefore()) {
            throw new OAuthErrorException("invalid_grant", "Stale refresh token");
        }
        return idToken;
    }

    public AccessToken createClientAccessToken(KeycloakSession session, Set<RoleModel> requestedRoles, RealmModel realm, ClientModel client, UserModel user, UserSessionModel userSession, ClientSessionModel clientSession) {
        AccessToken token = this.initToken(realm, client, user, userSession, clientSession);
        for (RoleModel role : requestedRoles) {
            this.addComposites(token, role);
        }
        token = this.transformAccessToken(session, token, realm, client, user, userSession, clientSession);
        return token;
    }

    public static void attachClientSession(UserSessionModel session, ClientSessionModel clientSession) {
        if (clientSession.getUserSession() != null) {
            return;
        }
        UserModel user = session.getUser();
        clientSession.setUserSession(session);
        HashSet<String> requestedRoles = new HashSet<String>();
        for (RoleModel r : TokenManager.getAccess(null, clientSession.getClient(), user)) {
            requestedRoles.add(r.getId());
        }
        clientSession.setRoles(requestedRoles);
        HashSet<String> requestedProtocolMappers = new HashSet<String>();
        for (ProtocolMapperModel protocolMapper : clientSession.getClient().getProtocolMappers()) {
            if (!protocolMapper.getProtocol().equals(clientSession.getAuthMethod())) continue;
            requestedProtocolMappers.add(protocolMapper.getId());
        }
        clientSession.setProtocolMappers(requestedProtocolMappers);
        Map transferredNotes = clientSession.getUserSessionNotes();
        for (Map.Entry entry : transferredNotes.entrySet()) {
            session.setNote((String)entry.getKey(), (String)entry.getValue());
        }
    }

    public static void dettachClientSession(UserSessionProvider sessions, RealmModel realm, ClientSessionModel clientSession) {
        UserSessionModel userSession = clientSession.getUserSession();
        if (userSession == null) {
            return;
        }
        clientSession.setUserSession(null);
        clientSession.setRoles(null);
        clientSession.setProtocolMappers(null);
        if (userSession.getClientSessions().isEmpty()) {
            sessions.removeUserSession(realm, userSession);
        }
    }

    public static Set<RoleModel> getAccess(String scopeParam, ClientModel client, UserModel user) {
        HashSet<RoleModel> requestedRoles = new HashSet<RoleModel>();
        Set roleMappings = user.getRoleMappings();
        if (client.isFullScopeAllowed()) {
            return roleMappings;
        }
        Set scopeMappings = client.getScopeMappings();
        if (client instanceof ClientModel) {
            scopeMappings.addAll(client.getRoles());
        }
        for (RoleModel role : roleMappings) {
            for (RoleModel desiredRole : scopeMappings) {
                HashSet<RoleModel> visited = new HashSet<RoleModel>();
                TokenManager.applyScope(role, desiredRole, visited, requestedRoles);
            }
        }
        return requestedRoles;
    }

    public void verifyAccess(AccessToken token, AccessToken newToken) throws OAuthErrorException {
        if (token.getRealmAccess() != null) {
            if (newToken.getRealmAccess() == null) {
                throw new OAuthErrorException("invalid_grant", "User no long has permission for realm roles");
            }
            for (String string : token.getRealmAccess().getRoles()) {
                if (newToken.getRealmAccess().getRoles().contains(string)) continue;
                throw new OAuthErrorException("invalid_grant", "User no long has permission for realm role: " + string);
            }
        }
        if (token.getResourceAccess() != null) {
            for (Map.Entry entry : token.getResourceAccess().entrySet()) {
                AccessToken.Access appAccess = newToken.getResourceAccess((String)entry.getKey());
                if (appAccess == null && !((AccessToken.Access)entry.getValue()).getRoles().isEmpty()) {
                    throw new OAuthErrorException("invalid_grant", "User or client no longer has role permissions for client key: " + (String)entry.getKey());
                }
                for (String roleName : ((AccessToken.Access)entry.getValue()).getRoles()) {
                    if (appAccess.getRoles().contains(roleName)) continue;
                    throw new OAuthErrorException("invalid_grant", "User no long has permission for client role " + roleName);
                }
            }
        }
    }

    public AccessToken transformAccessToken(KeycloakSession session, AccessToken token, RealmModel realm, ClientModel client, UserModel user, UserSessionModel userSession, ClientSessionModel clientSession) {
        Set<ProtocolMapperModel> mappings = new ClientSessionCode(realm, clientSession).getRequestedProtocolMappers();
        KeycloakSessionFactory sessionFactory = session.getKeycloakSessionFactory();
        for (ProtocolMapperModel mapping : mappings) {
            ProtocolMapper mapper = (ProtocolMapper)sessionFactory.getProviderFactory(ProtocolMapper.class, mapping.getProtocolMapper());
            if (mapper == null || !(mapper instanceof OIDCAccessTokenMapper)) continue;
            token = ((OIDCAccessTokenMapper)((Object)mapper)).transformAccessToken(token, mapping, session, userSession, clientSession);
        }
        return token;
    }

    public void transformIDToken(KeycloakSession session, IDToken token, RealmModel realm, ClientModel client, UserModel user, UserSessionModel userSession, ClientSessionModel clientSession) {
        Set<ProtocolMapperModel> mappings = new ClientSessionCode(realm, clientSession).getRequestedProtocolMappers();
        KeycloakSessionFactory sessionFactory = session.getKeycloakSessionFactory();
        for (ProtocolMapperModel mapping : mappings) {
            ProtocolMapper mapper = (ProtocolMapper)sessionFactory.getProviderFactory(ProtocolMapper.class, mapping.getProtocolMapper());
            if (mapper == null || !(mapper instanceof OIDCIDTokenMapper)) continue;
            token = ((OIDCIDTokenMapper)((Object)mapper)).transformIDToken(token, mapping, session, userSession, clientSession);
        }
    }

    protected AccessToken initToken(RealmModel realm, ClientModel client, UserModel user, UserSessionModel session, ClientSessionModel clientSession) {
        Set allowedOrigins;
        AccessToken token = new AccessToken();
        if (clientSession != null) {
            token.clientSession(clientSession.getId());
        }
        token.id(KeycloakModelUtils.generateId());
        token.subject(user.getId());
        token.audience(client.getClientId());
        token.issuedNow();
        token.issuedFor(client.getClientId());
        token.issuer(clientSession.getNote("iss"));
        token.setNonce(clientSession.getNote("nonce"));
        if (session != null) {
            token.setSessionState(session.getId());
        }
        if (realm.getAccessTokenLifespan() > 0) {
            token.expiration(Time.currentTime() + realm.getAccessTokenLifespan());
        }
        if ((allowedOrigins = client.getWebOrigins()) != null) {
            token.setAllowedOrigins(allowedOrigins);
        }
        return token;
    }

    protected void addComposites(AccessToken token, RoleModel role) {
        AccessToken.Access access = null;
        if (role.getContainer() instanceof RealmModel) {
            access = token.getRealmAccess();
            if (token.getRealmAccess() == null) {
                access = new AccessToken.Access();
                token.setRealmAccess(access);
            } else if (token.getRealmAccess().getRoles() != null && token.getRealmAccess().isUserInRole(role.getName())) {
                return;
            }
        } else {
            ClientModel app = (ClientModel)role.getContainer();
            access = token.getResourceAccess(app.getClientId());
            if (access == null) {
                access = token.addAccess(app.getClientId());
                if (app.isSurrogateAuthRequired()) {
                    access.verifyCaller(Boolean.valueOf(true));
                }
            } else if (access.isUserInRole(role.getName())) {
                return;
            }
        }
        access.addRole(role.getName());
        if (!role.isComposite()) {
            return;
        }
        for (RoleModel composite : role.getComposites()) {
            this.addComposites(token, composite);
        }
    }

    public String encodeToken(RealmModel realm, Object token) {
        String encodedToken = new JWSBuilder().jsonContent(token).rsa256(realm.getPrivateKey());
        return encodedToken;
    }

    public AccessTokenResponseBuilder responseBuilder(RealmModel realm, ClientModel client, EventBuilder event, KeycloakSession session, UserSessionModel userSession, ClientSessionModel clientSession) {
        return new AccessTokenResponseBuilder(realm, client, event, session, userSession, clientSession);
    }

    public class AccessTokenResponseBuilder {
        RealmModel realm;
        ClientModel client;
        EventBuilder event;
        KeycloakSession session;
        UserSessionModel userSession;
        ClientSessionModel clientSession;
        AccessToken accessToken;
        RefreshToken refreshToken;
        IDToken idToken;

        public AccessTokenResponseBuilder(RealmModel realm, ClientModel client, EventBuilder event, KeycloakSession session, UserSessionModel userSession, ClientSessionModel clientSession) {
            this.realm = realm;
            this.client = client;
            this.event = event;
            this.session = session;
            this.userSession = userSession;
            this.clientSession = clientSession;
        }

        public AccessTokenResponseBuilder accessToken(AccessToken accessToken) {
            this.accessToken = accessToken;
            return this;
        }

        public AccessTokenResponseBuilder refreshToken(RefreshToken refreshToken) {
            this.refreshToken = refreshToken;
            return this;
        }

        public AccessTokenResponseBuilder generateAccessToken(KeycloakSession session, String scopeParam, ClientModel client, UserModel user, UserSessionModel userSession, ClientSessionModel clientSession) {
            Set<RoleModel> requestedRoles = TokenManager.getAccess(scopeParam, client, user);
            this.accessToken = TokenManager.this.createClientAccessToken(session, requestedRoles, this.realm, client, user, userSession, clientSession);
            return this;
        }

        public AccessTokenResponseBuilder generateRefreshToken() {
            if (this.accessToken == null) {
                throw new IllegalStateException("accessToken not set");
            }
            this.refreshToken = new RefreshToken(this.accessToken);
            this.refreshToken.id(KeycloakModelUtils.generateId());
            this.refreshToken.issuedNow();
            this.refreshToken.expiration(Time.currentTime() + this.realm.getSsoSessionIdleTimeout());
            return this;
        }

        public AccessTokenResponseBuilder generateIDToken() {
            if (this.accessToken == null) {
                throw new IllegalStateException("accessToken not set");
            }
            this.idToken = new IDToken();
            this.idToken.id(KeycloakModelUtils.generateId());
            this.idToken.subject(this.accessToken.getSubject());
            this.idToken.audience(this.client.getClientId());
            this.idToken.issuedNow();
            this.idToken.issuedFor(this.accessToken.getIssuedFor());
            this.idToken.issuer(this.accessToken.getIssuer());
            this.idToken.setNonce(this.accessToken.getNonce());
            this.idToken.setSessionState(this.accessToken.getSessionState());
            if (this.realm.getAccessTokenLifespan() > 0) {
                this.idToken.expiration(Time.currentTime() + this.realm.getAccessTokenLifespan());
            }
            TokenManager.this.transformIDToken(this.session, this.idToken, this.realm, this.client, this.userSession.getUser(), this.userSession, this.clientSession);
            return this;
        }

        public AccessTokenResponse build() {
            String encodedToken;
            if (this.accessToken != null) {
                this.event.detail("token_id", this.accessToken.getId());
            }
            if (this.refreshToken != null) {
                if (this.event.getEvent().getDetails().containsKey("refresh_token_id")) {
                    this.event.detail("updated_refresh_token_id", this.refreshToken.getId());
                } else {
                    this.event.detail("refresh_token_id", this.refreshToken.getId());
                }
            }
            AccessTokenResponse res = new AccessTokenResponse();
            if (this.idToken != null) {
                encodedToken = new JWSBuilder().jsonContent((Object)this.idToken).rsa256(this.realm.getPrivateKey());
                res.setIdToken(encodedToken);
            }
            if (this.accessToken != null) {
                encodedToken = new JWSBuilder().jsonContent((Object)this.accessToken).rsa256(this.realm.getPrivateKey());
                res.setToken(encodedToken);
                res.setTokenType("bearer");
                res.setSessionState(this.accessToken.getSessionState());
                if (this.accessToken.getExpiration() != 0) {
                    res.setExpiresIn((long)(this.accessToken.getExpiration() - Time.currentTime()));
                }
            }
            if (this.refreshToken != null) {
                encodedToken = new JWSBuilder().jsonContent((Object)this.refreshToken).rsa256(this.realm.getPrivateKey());
                res.setRefreshToken(encodedToken);
                if (this.refreshToken.getExpiration() != 0) {
                    res.setRefreshExpiresIn((long)(this.refreshToken.getExpiration() - Time.currentTime()));
                }
            }
            int notBefore = this.realm.getNotBefore();
            if (this.client.getNotBefore() > notBefore) {
                notBefore = this.client.getNotBefore();
            }
            res.setNotBeforePolicy(notBefore);
            return res;
        }
    }

    public static class TokenValidation {
        public final UserModel user;
        public final UserSessionModel userSession;
        public final ClientSessionModel clientSession;
        public final AccessToken newToken;

        public TokenValidation(UserModel user, UserSessionModel userSession, ClientSessionModel clientSession, AccessToken newToken) {
            this.user = user;
            this.userSession = userSession;
            this.clientSession = clientSession;
            this.newToken = newToken;
        }
    }
}

