/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.services.clientregistration;

import java.net.URI;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Response;
import org.jboss.logging.Logger;
import org.keycloak.events.EventBuilder;
import org.keycloak.events.EventType;
import org.keycloak.models.AdminRoles;
import org.keycloak.models.ClientModel;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.ModelDuplicateException;
import org.keycloak.models.RealmModel;
import org.keycloak.models.utils.ModelToRepresentation;
import org.keycloak.models.utils.RepresentationToModel;
import org.keycloak.protocol.oidc.utils.AuthorizeClientUtil;
import org.keycloak.representations.AccessToken;
import org.keycloak.representations.idm.ClientRepresentation;
import org.keycloak.services.ErrorResponse;
import org.keycloak.services.ForbiddenException;
import org.keycloak.services.clientregistration.ClientRegistrationProvider;
import org.keycloak.services.managers.AppAuthManager;
import org.keycloak.services.managers.AuthenticationManager;

public class DefaultClientRegistrationProvider
implements ClientRegistrationProvider {
    private static final Logger logger = Logger.getLogger(DefaultClientRegistrationProvider.class);
    private KeycloakSession session;
    private EventBuilder event;
    private RealmModel realm;

    public DefaultClientRegistrationProvider(KeycloakSession session) {
        this.session = session;
    }

    @POST
    @Consumes(value={"application/json"})
    public Response create(ClientRepresentation client) {
        this.event.event(EventType.CLIENT_REGISTER);
        this.authenticate(true, null);
        try {
            ClientModel clientModel = RepresentationToModel.createClient((KeycloakSession)this.session, (RealmModel)this.realm, (ClientRepresentation)client, (boolean)true);
            client = ModelToRepresentation.toRepresentation((ClientModel)clientModel);
            URI uri = this.session.getContext().getUri().getAbsolutePathBuilder().path(clientModel.getId()).build(new Object[0]);
            logger.infov("Created client {0}", (Object)client.getClientId());
            this.event.client(client.getClientId()).success();
            return Response.created((URI)uri).entity((Object)client).build();
        }
        catch (ModelDuplicateException e) {
            return ErrorResponse.exists("Client " + client.getClientId() + " already exists");
        }
    }

    @GET
    @Path(value="{clientId}")
    @Produces(value={"application/json"})
    public Response get(@PathParam(value="clientId") String clientId) {
        this.event.event(EventType.CLIENT_INFO);
        ClientModel client = this.authenticate(false, clientId);
        if (client == null) {
            return Response.status((Response.Status)Response.Status.NOT_FOUND).build();
        }
        return Response.ok((Object)ModelToRepresentation.toRepresentation((ClientModel)client)).build();
    }

    @PUT
    @Path(value="{clientId}")
    @Consumes(value={"application/json"})
    public Response update(@PathParam(value="clientId") String clientId, ClientRepresentation rep) {
        this.event.event(EventType.CLIENT_UPDATE).client(clientId);
        ClientModel client = this.authenticate(false, clientId);
        RepresentationToModel.updateClient((ClientRepresentation)rep, (ClientModel)client);
        logger.infov("Updated client {0}", (Object)rep.getClientId());
        this.event.success();
        return Response.status((Response.Status)Response.Status.OK).build();
    }

    @DELETE
    @Path(value="{clientId}")
    public Response delete(@PathParam(value="clientId") String clientId) {
        this.event.event(EventType.CLIENT_DELETE).client(clientId);
        ClientModel client = this.authenticate(false, clientId);
        if (this.realm.removeClient(client.getId())) {
            this.event.success();
            return Response.ok().build();
        }
        return Response.status((Response.Status)Response.Status.NOT_FOUND).build();
    }

    public void close() {
    }

    private ClientModel authenticate(boolean create, String clientId) {
        boolean bearer;
        String authorizationHeader = (String)this.session.getContext().getRequestHeaders().getRequestHeaders().getFirst((Object)"Authorization");
        boolean bl = bearer = authorizationHeader != null && authorizationHeader.split(" ")[0].equalsIgnoreCase("Bearer");
        if (bearer) {
            AuthenticationManager.AuthResult authResult = new AppAuthManager().authenticateBearerToken(this.session, this.realm);
            AccessToken.Access realmAccess = authResult.getToken().getResourceAccess("realm-management");
            if (realmAccess != null) {
                if (realmAccess.isUserInRole(AdminRoles.MANAGE_CLIENTS)) {
                    return create ? null : this.realm.getClientByClientId(clientId);
                }
                if (create && realmAccess.isUserInRole(AdminRoles.CREATE_CLIENT)) {
                    return create ? null : this.realm.getClientByClientId(clientId);
                }
            }
        } else if (!create) {
            try {
                AuthorizeClientUtil.ClientAuthResult clientAuth = AuthorizeClientUtil.authorizeClient(this.session, this.event, this.realm);
                ClientModel client = clientAuth.getClient();
                if (client != null && !client.isPublicClient() && client.getClientId().equals(clientId)) {
                    return client;
                }
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        this.event.error("not_allowed");
        throw new ForbiddenException();
    }

    @Override
    public void setRealm(RealmModel realm) {
        this.realm = realm;
    }

    @Override
    public void setEvent(EventBuilder event) {
        this.event = event;
    }
}

