/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.forms.login.freemarker.model;

import java.io.UnsupportedEncodingException;
import java.net.URI;
import java.net.URLEncoder;
import org.keycloak.models.RealmModel;
import org.keycloak.models.UserModel;
import org.keycloak.models.utils.Base32;
import org.keycloak.models.utils.HmacOTP;

public class TotpBean {
    private final String totpSecret;
    private final String totpSecretEncoded;
    private final boolean enabled;
    private final String contextUrl;
    private final String keyUri;

    public TotpBean(RealmModel realm, UserModel user, URI baseUri) {
        this.enabled = user.isOtpEnabled();
        this.contextUrl = baseUri.getPath();
        this.totpSecret = HmacOTP.generateSecret((int)20);
        this.totpSecretEncoded = Base32.encode((byte[])this.totpSecret.getBytes());
        this.keyUri = realm.getOTPPolicy().getKeyURI(realm, user, this.totpSecret);
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public String getTotpSecret() {
        return this.totpSecret;
    }

    public String getTotpSecretEncoded() {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < this.totpSecretEncoded.length(); i += 4) {
            sb.append(this.totpSecretEncoded.substring(i, i + 4 < this.totpSecretEncoded.length() ? i + 4 : this.totpSecretEncoded.length()));
            if (i + 4 >= this.totpSecretEncoded.length()) continue;
            sb.append(" ");
        }
        return sb.toString();
    }

    public String getTotpSecretQrCodeUrl() throws UnsupportedEncodingException {
        String contents = URLEncoder.encode(this.keyUri, "utf-8");
        return this.contextUrl + "qrcode" + "?size=246x246&contents=" + contents;
    }
}

