/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.services.managers;

import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import org.keycloak.common.util.Time;
import org.keycloak.models.ClientModel;
import org.keycloak.models.ClientSessionModel;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.ModelException;
import org.keycloak.models.RealmModel;
import org.keycloak.models.RoleModel;
import org.keycloak.models.UserModel;
import org.keycloak.models.UserSessionModel;
import org.keycloak.models.session.UserSessionPersisterProvider;
import org.keycloak.services.ServicesLogger;

public class UserSessionManager {
    protected static ServicesLogger logger = ServicesLogger.ROOT_LOGGER;
    private final KeycloakSession kcSession;
    private final UserSessionPersisterProvider persister;

    public UserSessionManager(KeycloakSession session) {
        this.kcSession = session;
        this.persister = (UserSessionPersisterProvider)session.getProvider(UserSessionPersisterProvider.class);
    }

    public void createOrUpdateOfflineSession(ClientSessionModel clientSession, UserSessionModel userSession) {
        UserModel user = userSession.getUser();
        UserSessionModel offlineUserSession = this.kcSession.sessions().getOfflineUserSession(clientSession.getRealm(), userSession.getId());
        if (offlineUserSession == null) {
            offlineUserSession = this.createOfflineUserSession(user, userSession);
        } else {
            offlineUserSession.setLastSessionRefresh(Time.currentTime());
        }
        ClientSessionModel offlineClientSession = this.kcSession.sessions().getOfflineClientSession(clientSession.getRealm(), clientSession.getId());
        if (offlineClientSession == null) {
            this.createOfflineClientSession(user, clientSession, offlineUserSession);
        }
    }

    public ClientSessionModel findOfflineClientSession(RealmModel realm, String clientSessionId, String userSessionId) {
        ClientSessionModel clientSession = this.kcSession.sessions().getOfflineClientSession(realm, clientSessionId);
        if (clientSession == null) {
            return null;
        }
        if (!userSessionId.equals(clientSession.getUserSession().getId())) {
            throw new ModelException("User session don't match. Offline client session " + clientSession.getId() + ", It's user session " + clientSession.getUserSession().getId() + "  Wanted user session: " + userSessionId);
        }
        return clientSession;
    }

    public Set<ClientModel> findClientsWithOfflineToken(RealmModel realm, UserModel user) {
        List clientSessions = this.kcSession.sessions().getOfflineClientSessions(realm, user);
        HashSet<ClientModel> clients = new HashSet<ClientModel>();
        for (ClientSessionModel clientSession : clientSessions) {
            clients.add(clientSession.getClient());
        }
        return clients;
    }

    public List<UserSessionModel> findOfflineSessions(RealmModel realm, ClientModel client, UserModel user) {
        List clientSessions = this.kcSession.sessions().getOfflineClientSessions(realm, user);
        LinkedList<UserSessionModel> userSessions = new LinkedList<UserSessionModel>();
        for (ClientSessionModel clientSession : clientSessions) {
            userSessions.add(clientSession.getUserSession());
        }
        return userSessions;
    }

    public boolean revokeOfflineToken(UserModel user, ClientModel client) {
        RealmModel realm = client.getRealm();
        List clientSessions = this.kcSession.sessions().getOfflineClientSessions(realm, user);
        boolean anyRemoved = false;
        for (ClientSessionModel clientSession : clientSessions) {
            if (!clientSession.getClient().getId().equals(client.getId())) continue;
            if (logger.isTraceEnabled()) {
                logger.tracef("Removing existing offline token for user '%s' and client '%s' . ClientSessionID was '%s' .", user.getUsername(), client.getClientId(), clientSession.getId());
            }
            this.kcSession.sessions().removeOfflineClientSession(realm, clientSession.getId());
            this.persister.removeClientSession(clientSession.getId(), true);
            this.checkOfflineUserSessionHasClientSessions(realm, user, clientSession.getUserSession().getId(), clientSessions);
            anyRemoved = true;
        }
        return anyRemoved;
    }

    public void revokeOfflineUserSession(UserSessionModel userSession) {
        if (logger.isTraceEnabled()) {
            logger.tracef("Removing offline user session '%s' for user '%s' ", userSession.getId(), userSession.getLoginUsername());
        }
        this.kcSession.sessions().removeOfflineUserSession(userSession.getRealm(), userSession.getId());
        this.persister.removeUserSession(userSession.getId(), true);
    }

    public boolean isOfflineTokenAllowed(ClientSessionModel clientSession) {
        RoleModel offlineAccessRole = clientSession.getRealm().getRole("offline_access");
        if (offlineAccessRole == null) {
            logger.roleNotInRealm("offline_access");
            return false;
        }
        return clientSession.getRoles().contains(offlineAccessRole.getId());
    }

    private UserSessionModel createOfflineUserSession(UserModel user, UserSessionModel userSession) {
        if (logger.isTraceEnabled()) {
            logger.tracef("Creating new offline user session. UserSessionID: '%s' , Username: '%s'", userSession.getId(), user.getUsername());
        }
        UserSessionModel offlineUserSession = this.kcSession.sessions().createOfflineUserSession(userSession);
        this.persister.createUserSession(offlineUserSession, true);
        return offlineUserSession;
    }

    private void createOfflineClientSession(UserModel user, ClientSessionModel clientSession, UserSessionModel userSession) {
        if (logger.isTraceEnabled()) {
            logger.tracef("Creating new offline token client session. ClientSessionId: '%s', UserSessionID: '%s' , Username: '%s', Client: '%s'", new Object[]{clientSession.getId(), userSession.getId(), user.getUsername(), clientSession.getClient().getClientId()});
        }
        ClientSessionModel offlineClientSession = this.kcSession.sessions().createOfflineClientSession(clientSession);
        offlineClientSession.setUserSession(userSession);
        this.persister.createClientSession(clientSession, true);
    }

    private void checkOfflineUserSessionHasClientSessions(RealmModel realm, UserModel user, String userSessionId, List<ClientSessionModel> clientSessions) {
        for (ClientSessionModel clientSession : clientSessions) {
            if (!clientSession.getUserSession().getId().equals(userSessionId)) continue;
            return;
        }
        if (logger.isTraceEnabled()) {
            logger.tracef("Removing offline userSession for user %s as it doesn't have any client sessions attached. UserSessionID: %s", user.getUsername(), userSessionId);
        }
        this.kcSession.sessions().removeOfflineUserSession(realm, userSessionId);
        this.persister.removeUserSession(userSessionId, true);
    }
}

