/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.services.validation;

import java.util.ArrayList;
import java.util.List;
import java.util.regex.Pattern;
import javax.ws.rs.core.MultivaluedMap;
import org.keycloak.authentication.requiredactions.util.UpdateProfileContext;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.PasswordPolicy;
import org.keycloak.models.RealmModel;
import org.keycloak.models.utils.FormMessage;

public class Validation {
    public static final String FIELD_PASSWORD_CONFIRM = "password-confirm";
    public static final String FIELD_EMAIL = "email";
    public static final String FIELD_LAST_NAME = "lastName";
    public static final String FIELD_FIRST_NAME = "firstName";
    public static final String FIELD_PASSWORD = "password";
    public static final String FIELD_USERNAME = "username";
    private static final Pattern EMAIL_PATTERN = Pattern.compile("[a-zA-Z0-9!#$%&'*+/=?^_`{|}~.-]+@[a-zA-Z0-9-]+(\\.[a-zA-Z0-9-]+)*");

    public static List<FormMessage> validateRegistrationForm(KeycloakSession session, RealmModel realm, MultivaluedMap<String, String> formData, List<String> requiredCredentialTypes, PasswordPolicy policy) {
        PasswordPolicy.Error err;
        ArrayList<FormMessage> errors = new ArrayList<FormMessage>();
        if (!realm.isRegistrationEmailAsUsername() && Validation.isBlank((String)formData.getFirst((Object)FIELD_USERNAME))) {
            Validation.addError(errors, FIELD_USERNAME, "missingUsernameMessage");
        }
        if (Validation.isBlank((String)formData.getFirst((Object)FIELD_FIRST_NAME))) {
            Validation.addError(errors, FIELD_FIRST_NAME, "missingFirstNameMessage");
        }
        if (Validation.isBlank((String)formData.getFirst((Object)FIELD_LAST_NAME))) {
            Validation.addError(errors, FIELD_LAST_NAME, "missingLastNameMessage");
        }
        if (Validation.isBlank((String)formData.getFirst((Object)FIELD_EMAIL))) {
            Validation.addError(errors, FIELD_EMAIL, "missingEmailMessage");
        } else if (!Validation.isEmailValid((String)formData.getFirst((Object)FIELD_EMAIL))) {
            Validation.addError(errors, FIELD_EMAIL, "invalidEmailMessage");
        }
        if (requiredCredentialTypes.contains(FIELD_PASSWORD)) {
            if (Validation.isBlank((String)formData.getFirst((Object)FIELD_PASSWORD))) {
                Validation.addError(errors, FIELD_PASSWORD, "missingPasswordMessage");
            } else if (!((String)formData.getFirst((Object)FIELD_PASSWORD)).equals(formData.getFirst((Object)FIELD_PASSWORD_CONFIRM))) {
                Validation.addError(errors, FIELD_PASSWORD_CONFIRM, "invalidPasswordConfirmMessage");
            }
        }
        if (formData.getFirst((Object)FIELD_PASSWORD) != null && (err = policy.validate(session, realm.isRegistrationEmailAsUsername() ? (String)formData.getFirst((Object)FIELD_EMAIL) : (String)formData.getFirst((Object)FIELD_USERNAME), (String)formData.getFirst((Object)FIELD_PASSWORD))) != null) {
            errors.add(new FormMessage(FIELD_PASSWORD, err.getMessage(), err.getParameters()));
        }
        return errors;
    }

    private static void addError(List<FormMessage> errors, String field, String message) {
        errors.add(new FormMessage(field, message));
    }

    public static List<FormMessage> validateUpdateProfileForm(MultivaluedMap<String, String> formData) {
        return Validation.validateUpdateProfileForm(false, formData);
    }

    public static List<FormMessage> validateUpdateProfileForm(boolean editUsernameAllowed, MultivaluedMap<String, String> formData) {
        ArrayList<FormMessage> errors = new ArrayList<FormMessage>();
        if (editUsernameAllowed && Validation.isBlank((String)formData.getFirst((Object)FIELD_USERNAME))) {
            Validation.addError(errors, FIELD_USERNAME, "missingUsernameMessage");
        }
        if (Validation.isBlank((String)formData.getFirst((Object)FIELD_FIRST_NAME))) {
            Validation.addError(errors, FIELD_FIRST_NAME, "missingFirstNameMessage");
        }
        if (Validation.isBlank((String)formData.getFirst((Object)FIELD_LAST_NAME))) {
            Validation.addError(errors, FIELD_LAST_NAME, "missingLastNameMessage");
        }
        if (Validation.isBlank((String)formData.getFirst((Object)FIELD_EMAIL))) {
            Validation.addError(errors, FIELD_EMAIL, "missingEmailMessage");
        } else if (!Validation.isEmailValid((String)formData.getFirst((Object)FIELD_EMAIL))) {
            Validation.addError(errors, FIELD_EMAIL, "invalidEmailMessage");
        }
        return errors;
    }

    public static boolean validateUserMandatoryFields(RealmModel realm, UpdateProfileContext user) {
        return !Validation.isBlank(user.getFirstName()) && !Validation.isBlank(user.getLastName()) && !Validation.isBlank(user.getEmail());
    }

    public static boolean isEmpty(String s) {
        return s == null || s.length() == 0;
    }

    public static boolean isBlank(String s) {
        return s == null || s.trim().length() == 0;
    }

    public static boolean isEmailValid(String email) {
        return EMAIL_PATTERN.matcher(email).matches();
    }
}

