/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.services.resources.admin;

import java.net.URI;
import java.util.ArrayList;
import java.util.List;
import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriInfo;
import org.jboss.resteasy.annotations.cache.NoCache;
import org.jboss.resteasy.spi.ResteasyProviderFactory;
import org.keycloak.events.admin.OperationType;
import org.keycloak.models.ClientModel;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.ModelDuplicateException;
import org.keycloak.models.RealmModel;
import org.keycloak.models.utils.ModelToRepresentation;
import org.keycloak.representations.idm.ClientRepresentation;
import org.keycloak.services.ErrorResponse;
import org.keycloak.services.ServicesLogger;
import org.keycloak.services.managers.ClientManager;
import org.keycloak.services.resources.admin.AdminEventBuilder;
import org.keycloak.services.resources.admin.ClientResource;
import org.keycloak.services.resources.admin.RealmAuth;

public class ClientsResource {
    protected static final ServicesLogger logger = ServicesLogger.ROOT_LOGGER;
    protected RealmModel realm;
    private RealmAuth auth;
    private AdminEventBuilder adminEvent;
    @Context
    protected KeycloakSession session;

    public ClientsResource(RealmModel realm, RealmAuth auth, AdminEventBuilder adminEvent) {
        this.realm = realm;
        this.auth = auth;
        this.adminEvent = adminEvent;
        auth.init(RealmAuth.Resource.CLIENT);
    }

    @GET
    @Produces(value={"application/json"})
    @NoCache
    public List<ClientRepresentation> getClients(@QueryParam(value="clientId") String clientId) {
        this.auth.requireAny();
        ArrayList<ClientRepresentation> rep = new ArrayList<ClientRepresentation>();
        if (clientId == null) {
            List clientModels = this.realm.getClients();
            boolean view = this.auth.hasView();
            for (ClientModel clientModel : clientModels) {
                if (view) {
                    rep.add(ModelToRepresentation.toRepresentation((ClientModel)clientModel));
                    continue;
                }
                ClientRepresentation client = new ClientRepresentation();
                client.setId(clientModel.getId());
                client.setClientId(clientModel.getClientId());
                client.setDescription(clientModel.getDescription());
                rep.add(client);
            }
        } else {
            ClientModel client = this.realm.getClientByClientId(clientId);
            if (client != null) {
                rep.add(ModelToRepresentation.toRepresentation((ClientModel)client));
            }
        }
        return rep;
    }

    @POST
    @Consumes(value={"application/json"})
    public Response createClient(@Context UriInfo uriInfo, ClientRepresentation rep) {
        this.auth.requireManage();
        try {
            ClientModel clientModel = ClientManager.createClient(this.session, this.realm, rep, true);
            this.adminEvent.operation(OperationType.CREATE).resourcePath(uriInfo, clientModel.getId()).representation(rep).success();
            return Response.created((URI)uriInfo.getAbsolutePathBuilder().path(clientModel.getId()).build(new Object[0])).build();
        }
        catch (ModelDuplicateException e) {
            return ErrorResponse.exists("Client " + rep.getClientId() + " already exists");
        }
    }

    @Path(value="{id}")
    public ClientResource getClient(@PathParam(value="id") String id) {
        ClientModel clientModel = this.realm.getClientById(id);
        this.session.getContext().setClient(clientModel);
        ClientResource clientResource = new ClientResource(this.realm, this.auth, clientModel, this.session, this.adminEvent);
        ResteasyProviderFactory.getInstance().injectProperties((Object)clientResource);
        return clientResource;
    }
}

