/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.services.managers;

import java.io.IOException;
import java.net.URI;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.ws.rs.core.UriBuilder;
import org.jboss.logging.Logger;
import org.keycloak.Token;
import org.keycloak.TokenIdGenerator;
import org.keycloak.common.util.KeycloakUriBuilder;
import org.keycloak.common.util.MultivaluedHashMap;
import org.keycloak.common.util.StringPropertyReplacer;
import org.keycloak.common.util.Time;
import org.keycloak.connections.httpclient.HttpClientProvider;
import org.keycloak.models.AuthenticatedClientSessionModel;
import org.keycloak.models.ClientModel;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.RealmModel;
import org.keycloak.models.UserModel;
import org.keycloak.models.UserSessionModel;
import org.keycloak.protocol.LoginProtocol;
import org.keycloak.representations.adapters.action.GlobalRequestResult;
import org.keycloak.representations.adapters.action.LogoutAction;
import org.keycloak.representations.adapters.action.TestAvailabilityAction;
import org.keycloak.services.ServicesLogger;
import org.keycloak.services.managers.ClientManager;
import org.keycloak.services.util.ResolveRelative;

public class ResourceAdminManager {
    private static final Logger logger = Logger.getLogger(ResourceAdminManager.class);
    private static final String CLIENT_SESSION_HOST_PROPERTY = "${application.session.host}";
    private KeycloakSession session;

    public ResourceAdminManager(KeycloakSession session) {
        this.session = session;
    }

    public static String resolveUri(KeycloakSession session, String rootUrl, String uri) {
        String absoluteURI = ResolveRelative.resolveRelativeUri(session, rootUrl, uri);
        return StringPropertyReplacer.replaceProperties((String)absoluteURI);
    }

    public static String getManagementUrl(KeycloakSession session, ClientModel client) {
        String mgmtUrl = client.getManagementUrl();
        if (mgmtUrl == null || mgmtUrl.equals("")) {
            return null;
        }
        String absoluteURI = ResolveRelative.resolveRelativeUri(session, client.getRootUrl(), mgmtUrl);
        return StringPropertyReplacer.replaceProperties((String)absoluteURI);
    }

    private List<String> getAllManagementUrls(ClientModel client) {
        String baseMgmtUrl = ResourceAdminManager.getManagementUrl(this.session, client);
        if (baseMgmtUrl == null) {
            return Collections.emptyList();
        }
        Set<String> registeredNodesHosts = new ClientManager().validateRegisteredNodes(client);
        if (registeredNodesHosts.isEmpty()) {
            return Arrays.asList(baseMgmtUrl);
        }
        LinkedList<String> result = new LinkedList<String>();
        KeycloakUriBuilder uriBuilder = KeycloakUriBuilder.fromUri((String)baseMgmtUrl);
        for (String nodeHost : registeredNodesHosts) {
            String currentNodeUri = uriBuilder.clone().host(nodeHost).build(new Object[0]).toString();
            result.add(currentNodeUri);
        }
        return result;
    }

    public void logoutUser(RealmModel realm, UserModel user, KeycloakSession keycloakSession) {
        keycloakSession.users().setNotBeforeForUser(realm, user, Time.currentTime());
        List userSessions = keycloakSession.sessions().getUserSessions(realm, user);
        this.logoutUserSessions(realm, userSessions);
    }

    protected void logoutUserSessions(RealmModel realm, List<UserSessionModel> userSessions) {
        MultivaluedHashMap clientSessions = new MultivaluedHashMap();
        for (UserSessionModel userSession : userSessions) {
            this.putClientSessions((MultivaluedHashMap<String, AuthenticatedClientSessionModel>)clientSessions, userSession);
        }
        logger.debugv("logging out {0} resources ", (Object)clientSessions.size());
        for (Map.Entry entry : clientSessions.entrySet()) {
            if (((List)entry.getValue()).size() == 0) continue;
            this.logoutClientSessions(realm, ((AuthenticatedClientSessionModel)((List)entry.getValue()).get(0)).getClient(), (List)entry.getValue());
        }
    }

    private void putClientSessions(MultivaluedHashMap<String, AuthenticatedClientSessionModel> clientSessions, UserSessionModel userSession) {
        for (Map.Entry entry : userSession.getAuthenticatedClientSessions().entrySet()) {
            clientSessions.add(entry.getKey(), entry.getValue());
        }
    }

    public boolean logoutClientSession(RealmModel realm, ClientModel resource, AuthenticatedClientSessionModel clientSession) {
        return this.logoutClientSessions(realm, resource, Arrays.asList(clientSession));
    }

    protected boolean logoutClientSessions(RealmModel realm, ClientModel resource, List<AuthenticatedClientSessionModel> clientSessions) {
        String managementUrl = ResourceAdminManager.getManagementUrl(this.session, resource);
        if (managementUrl != null) {
            String host;
            MultivaluedHashMap adapterSessionIds = null;
            LinkedList<String> userSessions = new LinkedList<String>();
            if (clientSessions != null && clientSessions.size() > 0) {
                adapterSessionIds = new MultivaluedHashMap();
                for (AuthenticatedClientSessionModel clientSession : clientSessions) {
                    String adapterSessionId = clientSession.getNote("client_session_state");
                    if (adapterSessionId != null) {
                        host = clientSession.getNote("client_session_host");
                        adapterSessionIds.add((Object)host, (Object)adapterSessionId);
                    }
                    if (clientSession.getUserSession() == null) continue;
                    userSessions.add(clientSession.getUserSession().getId());
                }
            }
            if (adapterSessionIds == null || adapterSessionIds.isEmpty()) {
                logger.debugv("Can't logout {0}: no logged adapter sessions", (Object)resource.getClientId());
                return false;
            }
            if (managementUrl.contains(CLIENT_SESSION_HOST_PROPERTY)) {
                boolean allPassed = true;
                for (Map.Entry entry : adapterSessionIds.entrySet()) {
                    String currentHostMgmtUrl;
                    host = (String)entry.getKey();
                    List sessionIds = (List)entry.getValue();
                    allPassed = this.sendLogoutRequest(realm, resource, sessionIds, userSessions, 0, currentHostMgmtUrl = managementUrl.replace(CLIENT_SESSION_HOST_PROPERTY, host)) && allPassed;
                }
                return allPassed;
            }
            ArrayList<String> allSessionIds = new ArrayList<String>();
            for (List currentIds : adapterSessionIds.values()) {
                allSessionIds.addAll(currentIds);
            }
            return this.sendLogoutRequest(realm, resource, allSessionIds, userSessions, 0, managementUrl);
        }
        logger.debugv("Can't logout {0}: no management url", (Object)resource.getClientId());
        return false;
    }

    public GlobalRequestResult logoutAll(RealmModel realm) {
        realm.setNotBefore(Time.currentTime());
        List resources = realm.getClients();
        logger.debugv("logging out {0} resources ", (Object)resources.size());
        GlobalRequestResult finalResult = new GlobalRequestResult();
        for (ClientModel resource : resources) {
            GlobalRequestResult currentResult = this.logoutClient(realm, resource, realm.getNotBefore());
            finalResult.addAll(currentResult);
        }
        return finalResult;
    }

    public GlobalRequestResult logoutClient(RealmModel realm, ClientModel resource) {
        resource.setNotBefore(Time.currentTime());
        return this.logoutClient(realm, resource, resource.getNotBefore());
    }

    protected GlobalRequestResult logoutClient(RealmModel realm, ClientModel resource, int notBefore) {
        if (!resource.isEnabled()) {
            return new GlobalRequestResult();
        }
        List<String> mgmtUrls = this.getAllManagementUrls(resource);
        if (mgmtUrls.isEmpty()) {
            logger.debug((Object)("No management URL or no registered cluster nodes for the client " + resource.getClientId()));
            return new GlobalRequestResult();
        }
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Send logoutClient for URLs: " + mgmtUrls));
        }
        GlobalRequestResult result = new GlobalRequestResult();
        for (String mgmtUrl : mgmtUrls) {
            if (this.sendLogoutRequest(realm, resource, null, null, notBefore, mgmtUrl)) {
                result.addSuccessRequest(mgmtUrl);
                continue;
            }
            result.addFailedRequest(mgmtUrl);
        }
        return result;
    }

    protected boolean sendLogoutRequest(RealmModel realm, ClientModel resource, List<String> adapterSessionIds, List<String> userSessions, int notBefore, String managementUrl) {
        LogoutAction adminAction = new LogoutAction(TokenIdGenerator.generateId(), Time.currentTime() + 30, resource.getClientId(), adapterSessionIds, notBefore, userSessions);
        String token = this.session.tokens().encode((Token)adminAction);
        if (logger.isDebugEnabled()) {
            logger.debugv("logout resource {0} url: {1} sessionIds: " + adapterSessionIds, (Object)resource.getClientId(), (Object)managementUrl);
        }
        URI target = UriBuilder.fromUri((String)managementUrl).path("k_logout").build(new Object[0]);
        try {
            int status = ((HttpClientProvider)this.session.getProvider(HttpClientProvider.class)).postText(target.toString(), token);
            boolean success = status == 204 || status == 200;
            logger.debugf("logout success for %s: %s", (Object)managementUrl, (Object)success);
            return success;
        }
        catch (IOException e) {
            ServicesLogger.LOGGER.logoutFailed(e, resource.getClientId());
            return false;
        }
    }

    public GlobalRequestResult pushRealmRevocationPolicy(RealmModel realm) {
        GlobalRequestResult finalResult = new GlobalRequestResult();
        for (ClientModel client : realm.getClients()) {
            GlobalRequestResult currentResult = this.pushRevocationPolicy(realm, client, realm.getNotBefore());
            finalResult.addAll(currentResult);
        }
        return finalResult;
    }

    public GlobalRequestResult pushClientRevocationPolicy(RealmModel realm, ClientModel client) {
        return this.pushRevocationPolicy(realm, client, client.getNotBefore());
    }

    protected GlobalRequestResult pushRevocationPolicy(RealmModel realm, ClientModel resource, int notBefore) {
        List<String> mgmtUrls = this.getAllManagementUrls(resource);
        if (mgmtUrls.isEmpty()) {
            logger.debugf("No management URL or no registered cluster nodes for the client %s", (Object)resource.getClientId());
            return new GlobalRequestResult();
        }
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Sending push revocation to URLS: " + mgmtUrls));
        }
        GlobalRequestResult result = new GlobalRequestResult();
        for (String mgmtUrl : mgmtUrls) {
            if (this.sendPushRevocationPolicyRequest(realm, resource, notBefore, mgmtUrl)) {
                result.addSuccessRequest(mgmtUrl);
                continue;
            }
            result.addFailedRequest(mgmtUrl);
        }
        return result;
    }

    protected boolean sendPushRevocationPolicyRequest(RealmModel realm, ClientModel resource, int notBefore, String managementUrl) {
        LoginProtocol loginProtocol;
        String protocol = resource.getProtocol();
        if (protocol == null) {
            protocol = "openid-connect";
        }
        return (loginProtocol = (LoginProtocol)this.session.getProvider(LoginProtocol.class, protocol)) == null ? false : loginProtocol.sendPushRevocationPolicyRequest(realm, resource, notBefore, managementUrl);
    }

    public GlobalRequestResult testNodesAvailability(RealmModel realm, ClientModel client) {
        List<String> mgmtUrls = this.getAllManagementUrls(client);
        if (mgmtUrls.isEmpty()) {
            logger.debug((Object)("No management URL or no registered cluster nodes for the application " + client.getClientId()));
            return new GlobalRequestResult();
        }
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Sending test nodes availability: " + mgmtUrls));
        }
        GlobalRequestResult result = new GlobalRequestResult();
        for (String mgmtUrl : mgmtUrls) {
            if (this.sendTestNodeAvailabilityRequest(realm, client, mgmtUrl)) {
                result.addSuccessRequest(mgmtUrl);
                continue;
            }
            result.addFailedRequest(mgmtUrl);
        }
        return result;
    }

    protected boolean sendTestNodeAvailabilityRequest(RealmModel realm, ClientModel client, String managementUrl) {
        TestAvailabilityAction adminAction = new TestAvailabilityAction(TokenIdGenerator.generateId(), Time.currentTime() + 30, client.getClientId());
        String token = this.session.tokens().encode((Token)adminAction);
        logger.debugv("testNodes availability resource: {0} url: {1}", (Object)client.getClientId(), (Object)managementUrl);
        URI target = UriBuilder.fromUri((String)managementUrl).path("k_test_available").build(new Object[0]);
        try {
            int status = ((HttpClientProvider)this.session.getProvider(HttpClientProvider.class)).postText(target.toString(), token);
            boolean success = status == 204 || status == 200;
            logger.debugf("testAvailability success for %s: %s", (Object)managementUrl, (Object)success);
            return success;
        }
        catch (IOException e) {
            ServicesLogger.LOGGER.availabilityTestFailed(managementUrl);
            return false;
        }
    }
}

