/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.broker.saml;

import java.io.InputStream;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.xml.namespace.QName;
import org.keycloak.Config;
import org.keycloak.broker.provider.AbstractIdentityProviderFactory;
import org.keycloak.broker.saml.SAMLIdentityProvider;
import org.keycloak.broker.saml.SAMLIdentityProviderConfig;
import org.keycloak.dom.saml.v2.metadata.EndpointType;
import org.keycloak.dom.saml.v2.metadata.EntitiesDescriptorType;
import org.keycloak.dom.saml.v2.metadata.EntityDescriptorType;
import org.keycloak.dom.saml.v2.metadata.IDPSSODescriptorType;
import org.keycloak.dom.saml.v2.metadata.KeyDescriptorType;
import org.keycloak.dom.saml.v2.metadata.KeyTypes;
import org.keycloak.models.IdentityProviderModel;
import org.keycloak.models.KeycloakSession;
import org.keycloak.saml.common.constants.JBossSAMLURIConstants;
import org.keycloak.saml.common.exceptions.ParsingException;
import org.keycloak.saml.common.util.DocumentUtil;
import org.keycloak.saml.processing.core.parsers.saml.SAMLParser;
import org.keycloak.saml.validators.DestinationValidator;
import org.w3c.dom.Element;

public class SAMLIdentityProviderFactory
extends AbstractIdentityProviderFactory<SAMLIdentityProvider> {
    public static final String PROVIDER_ID = "saml";
    private DestinationValidator destinationValidator;

    public String getName() {
        return "SAML v2.0";
    }

    public SAMLIdentityProvider create(KeycloakSession session, IdentityProviderModel model) {
        return new SAMLIdentityProvider(session, new SAMLIdentityProviderConfig(model), this.destinationValidator);
    }

    public SAMLIdentityProviderConfig createConfig() {
        return new SAMLIdentityProviderConfig();
    }

    public Map<String, String> parseConfig(KeycloakSession session, InputStream inputStream) {
        try {
            Object parsedObject = SAMLParser.getInstance().parse(inputStream);
            EntityDescriptorType entityType = EntitiesDescriptorType.class.isInstance(parsedObject) ? (EntityDescriptorType)((EntitiesDescriptorType)parsedObject).getEntityDescriptor().get(0) : (EntityDescriptorType)parsedObject;
            List choiceType = entityType.getChoiceType();
            if (!choiceType.isEmpty()) {
                IDPSSODescriptorType idpDescriptor = null;
                for (EntityDescriptorType.EDTChoiceType edtChoiceType : entityType.getChoiceType()) {
                    List descriptors = edtChoiceType.getDescriptors();
                    if (descriptors.isEmpty() || ((EntityDescriptorType.EDTDescriptorChoiceType)descriptors.get(0)).getIdpDescriptor() == null) continue;
                    idpDescriptor = ((EntityDescriptorType.EDTDescriptorChoiceType)descriptors.get(0)).getIdpDescriptor();
                }
                if (idpDescriptor != null) {
                    SAMLIdentityProviderConfig samlIdentityProviderConfig = new SAMLIdentityProviderConfig();
                    String singleSignOnServiceUrl = null;
                    boolean postBindingResponse = false;
                    boolean postBindingLogout = false;
                    for (Object endpoint : idpDescriptor.getSingleSignOnService()) {
                        if (endpoint.getBinding().toString().equals(JBossSAMLURIConstants.SAML_HTTP_POST_BINDING.get())) {
                            singleSignOnServiceUrl = endpoint.getLocation().toString();
                            postBindingResponse = true;
                            break;
                        }
                        if (!endpoint.getBinding().toString().equals(JBossSAMLURIConstants.SAML_HTTP_REDIRECT_BINDING.get())) continue;
                        singleSignOnServiceUrl = endpoint.getLocation().toString();
                    }
                    String singleLogoutServiceUrl = null;
                    for (EndpointType endpoint : idpDescriptor.getSingleLogoutService()) {
                        if (postBindingResponse && endpoint.getBinding().toString().equals(JBossSAMLURIConstants.SAML_HTTP_POST_BINDING.get())) {
                            singleLogoutServiceUrl = endpoint.getLocation().toString();
                            postBindingLogout = true;
                            break;
                        }
                        if (postBindingResponse || !endpoint.getBinding().toString().equals(JBossSAMLURIConstants.SAML_HTTP_REDIRECT_BINDING.get())) continue;
                        singleLogoutServiceUrl = endpoint.getLocation().toString();
                        break;
                    }
                    samlIdentityProviderConfig.setSingleLogoutServiceUrl(singleLogoutServiceUrl);
                    samlIdentityProviderConfig.setSingleSignOnServiceUrl(singleSignOnServiceUrl);
                    samlIdentityProviderConfig.setWantAuthnRequestsSigned(idpDescriptor.isWantAuthnRequestsSigned());
                    samlIdentityProviderConfig.setAddExtensionsElementWithKeyInfo(false);
                    samlIdentityProviderConfig.setValidateSignature(idpDescriptor.isWantAuthnRequestsSigned());
                    samlIdentityProviderConfig.setPostBindingResponse(postBindingResponse);
                    samlIdentityProviderConfig.setPostBindingAuthnRequest(postBindingResponse);
                    samlIdentityProviderConfig.setPostBindingLogout(postBindingLogout);
                    List keyDescriptor = idpDescriptor.getKeyDescriptor();
                    String defaultCertificate = null;
                    if (keyDescriptor != null) {
                        for (KeyDescriptorType keyDescriptorType : keyDescriptor) {
                            Element keyInfo = keyDescriptorType.getKeyInfo();
                            Element x509KeyInfo = DocumentUtil.getChildElement((Element)keyInfo, (QName)new QName("dsig", "X509Certificate"));
                            if (KeyTypes.SIGNING.equals((Object)keyDescriptorType.getUse())) {
                                samlIdentityProviderConfig.addSigningCertificate(x509KeyInfo.getTextContent());
                                continue;
                            }
                            if (KeyTypes.ENCRYPTION.equals((Object)keyDescriptorType.getUse())) {
                                samlIdentityProviderConfig.setEncryptionPublicKey(x509KeyInfo.getTextContent());
                                continue;
                            }
                            if (keyDescriptorType.getUse() != null) continue;
                            defaultCertificate = x509KeyInfo.getTextContent();
                        }
                    }
                    if (defaultCertificate != null) {
                        if (samlIdentityProviderConfig.getSigningCertificates().length == 0) {
                            samlIdentityProviderConfig.addSigningCertificate(defaultCertificate);
                        }
                        if (samlIdentityProviderConfig.getEncryptionPublicKey() == null) {
                            samlIdentityProviderConfig.setEncryptionPublicKey(defaultCertificate);
                        }
                    }
                    return samlIdentityProviderConfig.getConfig();
                }
            }
        }
        catch (ParsingException pe) {
            throw new RuntimeException("Could not parse IdP SAML Metadata", pe);
        }
        return new HashMap<String, String>();
    }

    public String getId() {
        return PROVIDER_ID;
    }

    public void init(Config.Scope config) {
        super.init(config);
        this.destinationValidator = DestinationValidator.forProtocolMap((String[])config.getArray("knownProtocols"));
    }
}

