/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.protocol.oidc.endpoints;

import java.util.List;
import javax.ws.rs.Consumes;
import javax.ws.rs.POST;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.HttpHeaders;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.core.Response;
import org.jboss.resteasy.spi.HttpRequest;
import org.keycloak.common.ClientConnection;
import org.keycloak.events.EventBuilder;
import org.keycloak.events.EventType;
import org.keycloak.headers.SecurityHeadersProvider;
import org.keycloak.models.AuthenticatedClientSessionModel;
import org.keycloak.models.ClientModel;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.RealmModel;
import org.keycloak.models.UserModel;
import org.keycloak.models.UserSessionModel;
import org.keycloak.protocol.oidc.TokenManager;
import org.keycloak.protocol.oidc.utils.AuthorizeClientUtil;
import org.keycloak.representations.RefreshToken;
import org.keycloak.services.CorsErrorResponseException;
import org.keycloak.services.managers.UserSessionCrossDCManager;
import org.keycloak.services.managers.UserSessionManager;
import org.keycloak.services.resources.Cors;

public class TokenRevocationEndpoint {
    private static final String PARAM_TOKEN = "token";
    @Context
    private KeycloakSession session;
    @Context
    private HttpRequest request;
    @Context
    private HttpHeaders headers;
    @Context
    private ClientConnection clientConnection;
    private MultivaluedMap<String, String> formParams;
    private ClientModel client;
    private RealmModel realm;
    private EventBuilder event;
    private Cors cors;
    private RefreshToken token;
    private UserModel user;

    public TokenRevocationEndpoint(RealmModel realm, EventBuilder event) {
        this.realm = realm;
        this.event = event;
    }

    @POST
    @Consumes(value={"application/x-www-form-urlencoded"})
    public Response revoke() {
        this.event.event(EventType.REVOKE_GRANT);
        this.cors = Cors.add(this.request).auth().allowedMethods("POST").auth().exposedHeaders("Access-Control-Allow-Methods");
        this.checkSsl();
        this.checkRealm();
        this.checkClient();
        this.formParams = this.request.getDecodedFormParameters();
        this.checkToken();
        this.checkIssuedFor();
        this.checkUser();
        this.revokeClient();
        this.event.detail("revoked_client", this.client.getClientId()).success();
        ((SecurityHeadersProvider)this.session.getProvider(SecurityHeadersProvider.class)).options().allowEmptyContentType();
        return this.cors.builder(Response.ok()).build();
    }

    private void checkSsl() {
        if (!this.session.getContext().getUri().getBaseUri().getScheme().equals("https") && this.realm.getSslRequired().isRequired(this.clientConnection)) {
            throw new CorsErrorResponseException(this.cors.allowAllOrigins(), "invalid_request", "HTTPS required", Response.Status.FORBIDDEN);
        }
    }

    private void checkRealm() {
        if (!this.realm.isEnabled()) {
            throw new CorsErrorResponseException(this.cors.allowAllOrigins(), "access_denied", "Realm not enabled", Response.Status.FORBIDDEN);
        }
    }

    private void checkClient() {
        AuthorizeClientUtil.ClientAuthResult clientAuth = AuthorizeClientUtil.authorizeClient(this.session, this.event);
        this.client = clientAuth.getClient();
        this.event.client(this.client);
        this.cors.allowedOrigins(this.session, this.client);
        if (this.client.isBearerOnly()) {
            throw new CorsErrorResponseException(this.cors, "invalid_client", "Bearer-only not allowed", Response.Status.BAD_REQUEST);
        }
    }

    private void checkToken() {
        String encodedToken = (String)this.formParams.getFirst((Object)PARAM_TOKEN);
        if (encodedToken == null) {
            this.event.error("invalid_request");
            throw new CorsErrorResponseException(this.cors, "invalid_request", "Token not provided", Response.Status.BAD_REQUEST);
        }
        this.token = (RefreshToken)this.session.tokens().decode(encodedToken, RefreshToken.class);
        if (this.token == null) {
            this.event.error("invalid_token");
            throw new CorsErrorResponseException(this.cors, "invalid_token", "Invalid token", Response.Status.OK);
        }
        if (!"Refresh".equals(this.token.getType()) && !"Offline".equals(this.token.getType())) {
            this.event.error("invalid_token_type");
            throw new CorsErrorResponseException(this.cors, "unsupported_token_type", "Unsupported token type", Response.Status.BAD_REQUEST);
        }
    }

    private void checkIssuedFor() {
        String issuedFor = this.token.getIssuedFor();
        if (issuedFor == null) {
            this.event.error("invalid_token");
            throw new CorsErrorResponseException(this.cors, "invalid_token", "Invalid token", Response.Status.OK);
        }
        if (!this.client.getClientId().equals(issuedFor)) {
            this.event.error("invalid_request");
            throw new CorsErrorResponseException(this.cors, "invalid_request", "Unmatching clients", Response.Status.BAD_REQUEST);
        }
    }

    private void checkUser() {
        UserSessionModel userSession = new UserSessionCrossDCManager(this.session).getUserSessionWithClient(this.realm, this.token.getSessionState(), false, this.client.getId());
        if (userSession == null && (userSession = new UserSessionCrossDCManager(this.session).getUserSessionWithClient(this.realm, this.token.getSessionState(), true, this.client.getId())) == null) {
            this.event.error("user_session_not_found");
            throw new CorsErrorResponseException(this.cors, "invalid_token", "Invalid token", Response.Status.OK);
        }
        this.user = userSession.getUser();
        if (this.user == null) {
            this.event.error("user_not_found");
            throw new CorsErrorResponseException(this.cors, "invalid_token", "Invalid token", Response.Status.OK);
        }
        this.event.user(this.user);
    }

    private void revokeClient() {
        this.session.users().revokeConsentForClient(this.realm, this.user.getId(), this.client.getId());
        if ("Offline".equals(this.token.getType())) {
            new UserSessionManager(this.session).revokeOfflineToken(this.user, this.client);
        }
        List userSessions = this.session.sessions().getUserSessions(this.realm, this.user);
        for (UserSessionModel userSession : userSessions) {
            AuthenticatedClientSessionModel clientSession = userSession.getAuthenticatedClientSessionByClient(this.client.getId());
            if (clientSession == null) continue;
            TokenManager.dettachClientSession(this.session.sessions(), this.realm, clientSession);
        }
    }
}

