/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.theme;

import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URL;
import java.nio.charset.Charset;
import java.util.Locale;
import java.util.Properties;
import org.keycloak.theme.PropertiesUtil;
import org.keycloak.theme.Theme;

public class ClassLoaderTheme
implements Theme {
    private String name;
    private String parentName;
    private String importName;
    private Theme.Type type;
    private ClassLoader classLoader;
    private String templateRoot;
    private String resourceRoot;
    private String messageRoot;
    private Properties properties;

    public ClassLoaderTheme(String name, Theme.Type type, ClassLoader classLoader) throws IOException {
        this.init(name, type, classLoader);
    }

    public void init(String name, Theme.Type type, ClassLoader classLoader) throws IOException {
        String themeRoot;
        this.name = name;
        this.type = type;
        this.classLoader = classLoader;
        this.templateRoot = themeRoot = "theme/" + name + "/" + type.toString().toLowerCase() + "/";
        this.resourceRoot = themeRoot + "resources/";
        this.messageRoot = themeRoot + "messages/";
        this.properties = new Properties();
        URL p = classLoader.getResource(themeRoot + "theme.properties");
        if (p != null) {
            Charset encoding = PropertiesUtil.detectEncoding(p.openStream());
            try (InputStreamReader reader = new InputStreamReader(p.openStream(), encoding);){
                this.properties.load(reader);
            }
            this.parentName = this.properties.getProperty("parent");
            this.importName = this.properties.getProperty("import");
        } else {
            this.parentName = null;
            this.importName = null;
        }
    }

    public String getName() {
        return this.name;
    }

    public String getParentName() {
        return this.parentName;
    }

    public String getImportName() {
        return this.importName;
    }

    public Theme.Type getType() {
        return this.type;
    }

    public URL getTemplate(String name) {
        return this.classLoader.getResource(this.templateRoot + name);
    }

    public InputStream getResourceAsStream(String path) {
        return this.classLoader.getResourceAsStream(this.resourceRoot + path);
    }

    public Properties getMessages(Locale locale) throws IOException {
        return this.getMessages("messages", locale);
    }

    public Properties getMessages(String baseBundlename, Locale locale) throws IOException {
        if (locale == null) {
            return null;
        }
        Properties m = new Properties();
        URL url = this.classLoader.getResource(this.messageRoot + baseBundlename + "_" + locale.toString() + ".properties");
        if (url != null) {
            Charset encoding = PropertiesUtil.detectEncoding(url.openStream());
            try (InputStreamReader reader = new InputStreamReader(url.openStream(), encoding);){
                m.load(reader);
            }
        }
        return m;
    }

    public Properties getProperties() {
        return this.properties;
    }
}

