/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.authorization.protection.introspect;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.util.Collection;
import java.util.Collections;
import java.util.Set;
import java.util.stream.Collectors;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.Response;
import org.jboss.logging.Logger;
import org.keycloak.models.KeycloakSession;
import org.keycloak.protocol.oidc.AccessTokenIntrospectionProvider;
import org.keycloak.representations.AccessToken;
import org.keycloak.representations.idm.authorization.Permission;
import org.keycloak.util.JsonSerialization;

public class RPTIntrospectionProvider
extends AccessTokenIntrospectionProvider {
    protected static final Logger LOGGER = Logger.getLogger(RPTIntrospectionProvider.class);

    public RPTIntrospectionProvider(KeycloakSession session) {
        super(session);
    }

    @Override
    public Response introspect(String token) {
        LOGGER.debug((Object)"Introspecting requesting party token");
        try {
            ObjectNode tokenMetadata;
            AccessToken accessToken = this.verifyAccessToken(token);
            if (accessToken != null) {
                AccessToken metadata = new AccessToken();
                metadata.id(accessToken.getId());
                metadata.setAcr(accessToken.getAcr());
                metadata.type(accessToken.getType());
                metadata.expiration(accessToken.getExpiration());
                metadata.issuedAt(accessToken.getIssuedAt());
                metadata.audience(accessToken.getAudience());
                metadata.notBefore(accessToken.getNotBefore());
                metadata.setRealmAccess(null);
                metadata.setResourceAccess(null);
                tokenMetadata = JsonSerialization.createObjectNode((Object)metadata);
                AccessToken.Authorization authorization = accessToken.getAuthorization();
                if (authorization != null) {
                    Collection<Object> permissions = authorization.getPermissions() != null ? (Collection)authorization.getPermissions().stream().map(x$0 -> new UmaPermissionRepresentation((Permission)x$0)).collect(Collectors.toSet()) : Collections.emptyList();
                    tokenMetadata.putPOJO("permissions", permissions);
                }
            } else {
                tokenMetadata = JsonSerialization.createObjectNode();
            }
            tokenMetadata.put("active", accessToken != null);
            return Response.ok((Object)JsonSerialization.writeValueAsBytes((Object)tokenMetadata)).type(MediaType.APPLICATION_JSON_TYPE).build();
        }
        catch (Exception e) {
            throw new RuntimeException("Error creating token introspection response.", e);
        }
    }

    @Override
    public void close() {
    }

    public class UmaPermissionRepresentation
    extends Permission {
        public UmaPermissionRepresentation(Permission permission) {
            this.setResourceId(permission.getResourceId());
            this.setResourceName(permission.getResourceName());
            this.setScopes(permission.getScopes());
        }

        @JsonProperty(value="resource_id")
        public String getUmaResourceId() {
            return this.getResourceId();
        }

        @JsonProperty(value="resource_scopes")
        public Set<String> getUmaResourceScopes() {
            return this.getScopes();
        }
    }
}

