/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.services.resources;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import javax.ws.rs.core.MultivaluedMap;
import org.keycloak.userprofile.profile.representations.AttributeUserProfile;

public class AttributeFormDataProcessor {
    public static AttributeUserProfile process(MultivaluedMap<String, String> formData) {
        HashMap<String, List<String>> attributes = new HashMap<String, List<String>>();
        for (String key : formData.keySet()) {
            if (!key.startsWith("user.attributes.")) continue;
            String attribute = key.substring("user.attributes.".length());
            ArrayList<String> modelValue = new ArrayList<String>();
            int index = 0;
            for (String value : (List)formData.get((Object)key)) {
                AttributeFormDataProcessor.addOrSetValue(modelValue, index, value);
                ++index;
            }
            attributes.put(attribute, modelValue);
        }
        return new AttributeUserProfile(attributes);
    }

    public static AttributeUserProfile toUserProfile(MultivaluedMap<String, String> formData) {
        AttributeUserProfile profile = AttributeFormDataProcessor.process(formData);
        AttributeFormDataProcessor.copyAttribute("username", formData, profile);
        AttributeFormDataProcessor.copyAttribute("firstName", formData, profile);
        AttributeFormDataProcessor.copyAttribute("lastName", formData, profile);
        AttributeFormDataProcessor.copyAttribute("email", formData, profile);
        return profile;
    }

    private static void copyAttribute(String key, MultivaluedMap<String, String> formData, AttributeUserProfile rep) {
        if (formData.getFirst((Object)key) != null) {
            rep.getAttributes().setSingleAttribute(key, (String)formData.getFirst((Object)key));
        }
    }

    private static void addOrSetValue(List<String> list, int index, String value) {
        if (list.size() > index) {
            list.set(index, value);
        } else {
            list.add(value);
        }
    }
}

