/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.authentication.requiredactions;

import java.util.List;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.core.Response;
import org.keycloak.Config;
import org.keycloak.authentication.DisplayTypeRequiredActionFactory;
import org.keycloak.authentication.InitiatedActionSupport;
import org.keycloak.authentication.RequiredActionContext;
import org.keycloak.authentication.RequiredActionFactory;
import org.keycloak.authentication.RequiredActionProvider;
import org.keycloak.authentication.requiredactions.ConsoleUpdateProfile;
import org.keycloak.events.EventBuilder;
import org.keycloak.events.EventType;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.KeycloakSessionFactory;
import org.keycloak.models.UserModel;
import org.keycloak.models.utils.FormMessage;
import org.keycloak.services.validation.Validation;
import org.keycloak.userprofile.UserProfile;
import org.keycloak.userprofile.profile.UserProfileContextFactory;
import org.keycloak.userprofile.utils.UserUpdateHelper;
import org.keycloak.userprofile.validation.UserProfileValidationResult;

public class UpdateProfile
implements RequiredActionProvider,
RequiredActionFactory,
DisplayTypeRequiredActionFactory {
    public InitiatedActionSupport initiatedActionSupport() {
        return InitiatedActionSupport.SUPPORTED;
    }

    public void evaluateTriggers(RequiredActionContext context) {
    }

    public void requiredActionChallenge(RequiredActionContext context) {
        Response challenge = context.form().createResponse(UserModel.RequiredAction.UPDATE_PROFILE);
        context.challenge(challenge);
    }

    public void processAction(RequiredActionContext context) {
        EventBuilder event = context.getEvent();
        event.event(EventType.UPDATE_PROFILE);
        MultivaluedMap formData = context.getHttpRequest().getDecodedFormParameters();
        UserModel user = context.getUser();
        String oldEmail = user.getEmail();
        UserProfileValidationResult result = UserProfileContextFactory.forUpdateProfile(user, (MultivaluedMap<String, String>)formData, context.getSession()).validate();
        UserProfile updatedProfile = result.getProfile();
        List<FormMessage> errors = Validation.getFormErrorsFromValidation(result);
        if (errors != null && !errors.isEmpty()) {
            Response challenge = context.form().setErrors(errors).setFormData(formData).createResponse(UserModel.RequiredAction.UPDATE_PROFILE);
            context.challenge(challenge);
            return;
        }
        String newEmail = updatedProfile.getAttributes().getFirstAttribute("email");
        UserUpdateHelper.updateUserProfile(context.getRealm(), user, updatedProfile);
        if (result.hasAttributeChanged("email")) {
            user.setEmailVerified(false);
            event.clone().event(EventType.UPDATE_EMAIL).detail("previous_email", oldEmail).detail("updated_email", newEmail).success();
        }
        context.success();
    }

    public void close() {
    }

    public RequiredActionProvider create(KeycloakSession session) {
        return this;
    }

    public RequiredActionProvider createDisplay(KeycloakSession session, String displayType) {
        if (displayType == null) {
            return this;
        }
        if (!"console".equalsIgnoreCase(displayType)) {
            return null;
        }
        return ConsoleUpdateProfile.SINGLETON;
    }

    public void init(Config.Scope config) {
    }

    public void postInit(KeycloakSessionFactory factory) {
    }

    public String getDisplayText() {
        return "Update Profile";
    }

    public String getId() {
        return UserModel.RequiredAction.UPDATE_PROFILE.name();
    }
}

