/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.services.resources.admin;

import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriInfo;
import org.jboss.logging.Logger;
import org.jboss.resteasy.annotations.cache.NoCache;
import org.jboss.resteasy.spi.ResteasyProviderFactory;
import org.keycloak.events.admin.OperationType;
import org.keycloak.events.admin.ResourceType;
import org.keycloak.models.ClientScopeModel;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.ModelDuplicateException;
import org.keycloak.models.ModelException;
import org.keycloak.models.ProtocolMapperContainerModel;
import org.keycloak.models.RealmModel;
import org.keycloak.models.ScopeContainerModel;
import org.keycloak.models.utils.ModelToRepresentation;
import org.keycloak.models.utils.RepresentationToModel;
import org.keycloak.representations.idm.ClientScopeRepresentation;
import org.keycloak.services.ErrorResponse;
import org.keycloak.services.resources.admin.AdminEventBuilder;
import org.keycloak.services.resources.admin.ProtocolMappersResource;
import org.keycloak.services.resources.admin.ScopeMappedResource;
import org.keycloak.services.resources.admin.permissions.AdminPermissionEvaluator;

public class ClientScopeResource {
    protected static final Logger logger = Logger.getLogger(ClientScopeResource.class);
    protected RealmModel realm;
    private AdminPermissionEvaluator auth;
    private AdminEventBuilder adminEvent;
    protected ClientScopeModel clientScope;
    protected KeycloakSession session;

    public ClientScopeResource(RealmModel realm, AdminPermissionEvaluator auth, ClientScopeModel clientScope, KeycloakSession session, AdminEventBuilder adminEvent) {
        this.realm = realm;
        this.auth = auth;
        this.clientScope = clientScope;
        this.session = session;
        this.adminEvent = adminEvent.resource(ResourceType.CLIENT_SCOPE);
    }

    @Path(value="protocol-mappers")
    public ProtocolMappersResource getProtocolMappers() {
        AdminPermissionEvaluator.RequirePermissionCheck manageCheck = () -> this.auth.clients().requireManage(this.clientScope);
        AdminPermissionEvaluator.RequirePermissionCheck viewCheck = () -> this.auth.clients().requireView(this.clientScope);
        ProtocolMappersResource mappers = new ProtocolMappersResource(this.realm, (ProtocolMapperContainerModel)this.clientScope, this.auth, this.adminEvent, manageCheck, viewCheck);
        ResteasyProviderFactory.getInstance().injectProperties((Object)mappers);
        return mappers;
    }

    @Path(value="scope-mappings")
    public ScopeMappedResource getScopeMappedResource() {
        AdminPermissionEvaluator.RequirePermissionCheck manageCheck = () -> this.auth.clients().requireManage(this.clientScope);
        AdminPermissionEvaluator.RequirePermissionCheck viewCheck = () -> this.auth.clients().requireView(this.clientScope);
        return new ScopeMappedResource(this.realm, this.auth, (ScopeContainerModel)this.clientScope, this.session, this.adminEvent, manageCheck, viewCheck);
    }

    @PUT
    @Consumes(value={"application/json"})
    public Response update(ClientScopeRepresentation rep) {
        this.auth.clients().requireManageClientScopes();
        try {
            RepresentationToModel.updateClientScope((ClientScopeRepresentation)rep, (ClientScopeModel)this.clientScope);
            this.adminEvent.operation(OperationType.UPDATE).resourcePath((UriInfo)this.session.getContext().getUri()).representation(rep).success();
            if (this.session.getTransactionManager().isActive()) {
                this.session.getTransactionManager().commit();
            }
            return Response.noContent().build();
        }
        catch (ModelDuplicateException e) {
            return ErrorResponse.exists("Client Scope " + rep.getName() + " already exists");
        }
    }

    @GET
    @NoCache
    @Produces(value={"application/json"})
    public ClientScopeRepresentation getClientScope() {
        this.auth.clients().requireView(this.clientScope);
        return ModelToRepresentation.toRepresentation((ClientScopeModel)this.clientScope);
    }

    @DELETE
    @NoCache
    public Response deleteClientScope() {
        this.auth.clients().requireManage(this.clientScope);
        try {
            this.realm.removeClientScope(this.clientScope.getId());
            this.adminEvent.operation(OperationType.DELETE).resourcePath((UriInfo)this.session.getContext().getUri()).success();
            return Response.noContent().build();
        }
        catch (ModelException me) {
            return ErrorResponse.error(me.getMessage(), Response.Status.BAD_REQUEST);
        }
    }
}

