/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.protocol.oidc.utils;

import java.net.URI;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import java.util.stream.Collectors;
import org.jboss.logging.Logger;
import org.keycloak.common.util.UriUtils;
import org.keycloak.models.ClientModel;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.KeycloakUriInfo;
import org.keycloak.models.RealmModel;
import org.keycloak.services.Urls;
import org.keycloak.services.util.ResolveRelative;

public class RedirectUtils {
    private static final Logger logger = Logger.getLogger(RedirectUtils.class);

    public static String verifyRealmRedirectUri(KeycloakSession session, String redirectUri) {
        Set<String> validRedirects = RedirectUtils.getValidateRedirectUris(session);
        return RedirectUtils.verifyRedirectUri(session, null, redirectUri, validRedirects, true);
    }

    public static String verifyRedirectUri(KeycloakSession session, String redirectUri, ClientModel client) {
        return RedirectUtils.verifyRedirectUri(session, redirectUri, client, true);
    }

    public static String verifyRedirectUri(KeycloakSession session, String redirectUri, ClientModel client, boolean requireRedirectUri) {
        if (client != null) {
            return RedirectUtils.verifyRedirectUri(session, client.getRootUrl(), redirectUri, client.getRedirectUris(), requireRedirectUri);
        }
        return null;
    }

    public static Set<String> resolveValidRedirects(KeycloakSession session, String rootUrl, Set<String> validRedirects) {
        HashSet<String> resolveValidRedirects = new HashSet<String>();
        for (String validRedirect : validRedirects) {
            if (validRedirect.startsWith("/")) {
                validRedirect = RedirectUtils.relativeToAbsoluteURI(session, rootUrl, validRedirect);
                logger.debugv("replacing relative valid redirect with: {0}", (Object)validRedirect);
                resolveValidRedirects.add(validRedirect);
                continue;
            }
            resolveValidRedirects.add(validRedirect);
        }
        return resolveValidRedirects;
    }

    private static Set<String> getValidateRedirectUris(KeycloakSession session) {
        return session.getContext().getRealm().getClientsStream().filter(client -> client.isEnabled() && "openid-connect".equals(client.getProtocol()) && !client.isBearerOnly() && (client.isStandardFlowEnabled() || client.isImplicitFlowEnabled())).map(c -> RedirectUtils.resolveValidRedirects(session, c.getRootUrl(), c.getRedirectUris())).flatMap(Collection::stream).collect(Collectors.toSet());
    }

    public static String verifyRedirectUri(KeycloakSession session, String rootUrl, String redirectUri, Set<String> validRedirects, boolean requireRedirectUri) {
        KeycloakUriInfo uriInfo = session.getContext().getUri();
        RealmModel realm = session.getContext().getRealm();
        if (redirectUri != null) {
            try {
                URI uri = URI.create(redirectUri);
                redirectUri = uri.normalize().toString();
            }
            catch (IllegalArgumentException cause) {
                logger.debug((Object)"Invalid redirect uri", (Throwable)cause);
                return null;
            }
            catch (Exception cause) {
                logger.debug((Object)"Unexpected error when parsing redirect uri", (Throwable)cause);
                return null;
            }
        }
        if (redirectUri == null) {
            if (!requireRedirectUri) {
                redirectUri = RedirectUtils.getSingleValidRedirectUri(validRedirects);
            }
            if (redirectUri == null) {
                logger.debug((Object)"No Redirect URI parameter specified");
                return null;
            }
        } else if (validRedirects.isEmpty()) {
            logger.debug((Object)"No Redirect URIs supplied");
            redirectUri = null;
        } else {
            String r = redirectUri = RedirectUtils.lowerCaseHostname(redirectUri);
            Set<String> resolveValidRedirects = RedirectUtils.resolveValidRedirects(session, rootUrl, validRedirects);
            boolean valid = RedirectUtils.matchesRedirects(resolveValidRedirects, r);
            if (!valid && (r.startsWith("http://localhost") || r.startsWith("http://127.0.0.1")) && r.indexOf(58, "http://localhost".length()) >= 0) {
                int i = r.indexOf(58, "http://localhost".length());
                StringBuilder sb = new StringBuilder();
                sb.append(r.substring(0, i));
                i = r.indexOf(47, i);
                if (i >= 0) {
                    sb.append(r.substring(i));
                }
                r = sb.toString();
                valid = RedirectUtils.matchesRedirects(resolveValidRedirects, r);
            }
            if (valid && redirectUri.startsWith("/")) {
                redirectUri = RedirectUtils.relativeToAbsoluteURI(session, rootUrl, redirectUri);
            }
            String string = redirectUri = valid ? redirectUri : null;
        }
        if ("urn:ietf:wg:oauth:2.0:oob".equals(redirectUri)) {
            return Urls.realmInstalledAppUrnCallback(uriInfo.getBaseUri(), realm.getName()).toString();
        }
        return redirectUri;
    }

    private static String lowerCaseHostname(String redirectUri) {
        int n = redirectUri.indexOf(47, 7);
        if (n == -1) {
            return redirectUri.toLowerCase();
        }
        return redirectUri.substring(0, n).toLowerCase() + redirectUri.substring(n);
    }

    private static String relativeToAbsoluteURI(KeycloakSession session, String rootUrl, String relative) {
        if (rootUrl != null) {
            rootUrl = ResolveRelative.resolveRootUrl(session, rootUrl);
        }
        if (rootUrl == null || rootUrl.isEmpty()) {
            rootUrl = UriUtils.getOrigin((URI)session.getContext().getUri().getBaseUri());
        }
        StringBuilder sb = new StringBuilder();
        sb.append(rootUrl);
        sb.append(relative);
        return sb.toString();
    }

    private static boolean matchesRedirects(Set<String> validRedirects, String redirect) {
        for (String validRedirect : validRedirects) {
            if (validRedirect.endsWith("*") && !validRedirect.contains("?")) {
                int length;
                String r = redirect.contains("?") ? redirect.substring(0, redirect.indexOf("?")) : redirect;
                if (r.startsWith(validRedirect = validRedirect.substring(0, length = validRedirect.length() - 1))) {
                    return true;
                }
                if (length - 1 > 0 && validRedirect.charAt(length - 1) == '/') {
                    --length;
                }
                if (!(validRedirect = validRedirect.substring(0, length)).equals(r)) continue;
                return true;
            }
            if (!validRedirect.equals(redirect)) continue;
            return true;
        }
        return false;
    }

    private static String getSingleValidRedirectUri(Collection<String> validRedirects) {
        if (validRedirects.size() != 1) {
            return null;
        }
        String validRedirect = validRedirects.iterator().next();
        return RedirectUtils.validateRedirectUriWildcard(validRedirect);
    }

    public static String validateRedirectUriWildcard(String redirectUri) {
        if (redirectUri == null) {
            return null;
        }
        int idx = redirectUri.indexOf("/*");
        if (idx > -1) {
            redirectUri = redirectUri.substring(0, idx);
        }
        return redirectUri;
    }

    private static String getFirstValidRedirectUri(Collection<String> validRedirects) {
        String redirectUri = validRedirects.stream().findFirst().orElse(null);
        return redirectUri != null ? RedirectUtils.validateRedirectUriWildcard(redirectUri) : null;
    }

    public static String getFirstValidRedirectUri(KeycloakSession session, String rootUrl, Set<String> validRedirects) {
        return RedirectUtils.getFirstValidRedirectUri(RedirectUtils.resolveValidRedirects(session, rootUrl, validRedirects));
    }
}

