/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.services.clientpolicy.executor;

import org.jboss.logging.Logger;
import org.keycloak.models.KeycloakSession;
import org.keycloak.protocol.oidc.endpoints.request.AuthorizationEndpointRequest;
import org.keycloak.protocol.oidc.utils.OIDCResponseType;
import org.keycloak.services.clientpolicy.ClientPolicyContext;
import org.keycloak.services.clientpolicy.ClientPolicyException;
import org.keycloak.services.clientpolicy.context.AuthorizationRequestContext;
import org.keycloak.services.clientpolicy.executor.ClientPolicyExecutorConfiguration;
import org.keycloak.services.clientpolicy.executor.ClientPolicyExecutorProvider;

public class SecureResponseTypeExecutor
implements ClientPolicyExecutorProvider<ClientPolicyExecutorConfiguration> {
    private static final Logger logger = Logger.getLogger(SecureResponseTypeExecutor.class);
    protected final KeycloakSession session;

    public SecureResponseTypeExecutor(KeycloakSession session) {
        this.session = session;
    }

    public String getProviderId() {
        return "secure-responsetype-executor";
    }

    public void executeOnEvent(ClientPolicyContext context) throws ClientPolicyException {
        switch (context.getEvent()) {
            case AUTHORIZATION_REQUEST: {
                AuthorizationRequestContext authorizationRequestContext = (AuthorizationRequestContext)context;
                this.executeOnAuthorizationRequest(authorizationRequestContext.getparsedResponseType(), authorizationRequestContext.getAuthorizationEndpointRequest(), authorizationRequestContext.getRedirectUri());
                break;
            }
        }
    }

    public void executeOnAuthorizationRequest(OIDCResponseType parsedResponseType, AuthorizationEndpointRequest request, String redirectUri) throws ClientPolicyException {
        logger.trace((Object)"Authz Endpoint - authz request");
        if (parsedResponseType.hasResponseType("code") && parsedResponseType.hasResponseType("id_token")) {
            if (parsedResponseType.hasResponseType("token")) {
                logger.trace((Object)"Passed. response_type = code id_token token");
            } else {
                logger.trace((Object)"Passed. response_type = code id_token");
            }
            return;
        }
        logger.tracev("invalid response_type = {0}", (Object)parsedResponseType);
        throw new ClientPolicyException("invalid_request", "invalid response_type");
    }
}

